package com.ejianc.business.pay.service;

import com.ejianc.business.pay.bean.PayEntity;
import com.ejianc.business.pay.vo.PayVO;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 风险金缴纳表
 *
 * @author baipengyan
 */
public interface IPayService extends IBaseService<PayEntity> {

	/**
	 * 获取历史版本缴纳金额
	 *
	 * @param userId 用户id
	 * @param orgId  组织id
	 *
	 * @return 历史版本缴纳金额
	 */
	BigDecimal fetchLastPayTaxMny(Long userId, Long orgId);

	/**
	 * 获取当前人员缴纳明细的最大缴纳日期
	 *
	 * @param userId 用户id
	 * @param orgId  组织id
	 *
	 * @return 最大缴纳日期
	 */
	Date fetchMaxPayDate(Long userId, Long orgId);

	/**
	 * 是否是最新单据
	 *
	 * @param billId 单据id
	 * @param userId 用户id
	 * @param orgId  组织id
	 *
	 * @return 是否是最新单据
	 */
	boolean isLatestBill(Long billId, Long userId, Long orgId);

	/**
	 * 风险金缴纳：批量确认
	 *
	 * @param pays 要确认的单据信息
	 */
	void batchConfirm(List<PayVO> pays);
}
