package com.ejianc.business.payer.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.payer.bean.PayerChangeEntity;
import com.ejianc.business.payer.bean.PayerDetailEntity;
import com.ejianc.business.payer.bean.PayerEntity;
import com.ejianc.business.payer.bean.PayerRecordEntity;
import com.ejianc.business.payer.service.IpayerChangeService;
import com.ejianc.business.payer.service.IpayerRecordService;
import com.ejianc.business.payer.service.IpayerService;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

@Service("payerChange") 
public class payerChangeBpmServiceImpl implements ICommonBusinessService {

    @Autowired
    private IBillTypeApi billTypeApi;

    @Autowired
    private IpayerChangeService changeService;

	@Autowired
	private IpayerRecordService recordService;

	@Autowired
	private IpayerService payerService;

	private Logger logger = LoggerFactory.getLogger(this.getClass());



	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return doBpmBack(billId, state, billTypeCode);
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		return changeService.effectiveSaveWriteStandard(billId, billTypeCode);
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		return doBpmBack(billId, state, billTypeCode);
	}



	private CommonResponse<String> doBpmBack(Long billId, Integer state, String billTypeCode) {
		//提交通过、且未签章则可弃审
		PayerChangeEntity changeEntity = changeService.selectById(billId);
		changeEntity.setEffectDate(null);
		changeService.saveOrUpdate(changeEntity);

		//把记录表的数据复制到缴纳员工明细表上
		QueryParam queryParam = new QueryParam();
		queryParam.getParams().put("main_payer_id", new Parameter(QueryParam.EQ, changeEntity.getMainPayerId()));
		queryParam.getParams().put("change_id", new Parameter(QueryParam.EQ, billId));
		List<PayerRecordEntity> recordEntityList = recordService.queryList(queryParam);
		logger.info("查询到缴纳员工明细表的记录表集合{}", JSONObject.toJSONString(recordEntityList));
		if (CollectionUtils.isNotEmpty(recordEntityList) && null != recordEntityList.get(0)){
			logger.info("查询到缴纳员工明细表的记录表{}", JSONObject.toJSONString(recordEntityList.get(0)));
			PayerRecordEntity recordEntity = recordEntityList.get(0);
			PayerEntity payerEntity = BeanMapper.map(recordEntity, PayerEntity.class);
			logger.info("撤回更新前缴纳员工明细表数据,standardEntity---------->: {}", JSONObject.toJSONString(payerEntity));

			payerEntity.setId(changeEntity.getMainPayerId());
			payerEntity.setChangingPayerMny(null);

			//把记录表子表的id赋值为原缴纳员工明细表子表id
			if(CollectionUtils.isNotEmpty(recordEntity.getDetailList())){
				recordEntity.getDetailList().forEach(vo -> {
					vo.setId(vo.getSrcTableId());
				});
			}
			payerEntity.setDetailList(BeanMapper.mapList(recordEntity.getDetailList(), PayerDetailEntity.class));
			payerService.saveOrUpdate(payerEntity, false);
			//删除记录表
			recordService.removeById(recordEntity.getId(), false);

			logger.info("撤回更新缴纳员工明细表数据成功,standardEntity---------->: {}", JSONObject.toJSONString(payerEntity));
		}

		return CommonResponse.success("执行变更单撤回回调逻辑成功！");
	}

}
