package com.ejianc.business.standard.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.standard.bean.*;
import com.ejianc.business.standard.enums.ChangeStatusEnum;
import com.ejianc.business.standard.service.IStandardRecordService;
import com.ejianc.business.standard.service.IStandardService;
import com.ejianc.business.standard.vo.StandardChangeDetailVO;
import com.ejianc.business.standard.vo.StandardChangeVO;
import com.ejianc.business.standard.vo.StandardRecordVO;
import com.ejianc.business.standard.vo.StandardVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.sun.jmx.remote.internal.ArrayQueue;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.standard.mapper.StandardChangeMapper;
import com.ejianc.business.standard.service.IStandardChangeService;
import org.springframework.transaction.annotation.Transactional;

import javax.json.JsonObject;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 风险金缴纳标准变更表主实体
 * 
 * @author generator
 * 
 */
@Service("standardChangeService")
public class StandardChangeServiceImpl extends BaseServiceImpl<StandardChangeMapper, StandardChangeEntity> implements IStandardChangeService{

    @Autowired
    private IStandardService standardService;
    @Autowired
    private IStandardRecordService recordService;

    @Autowired
    private IAttachmentApi attachmentApi;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private final String STANDARD_FILE_SOURCE_TYPE = "standardFile"; // 记录单据业务
    private final String STANDARD_ATTACH_SOURCE_TYPE = "standardBill"; //原单据业务类型


    //直管部标准表单据编码
    private final String DIRECT_Bill_CODE = "EJCBT202206000037";
    //直管部标准表记录单据编码
    private final String DIRECT_RECORD_Bill_CODE = "EJCBT202206000039";

    //项目部标准表单据编码
    private final String PROSUB_Bill_CODE = "EJCBT202206000040";
    //项目部标准表记录单据编码
    private final String PROSUB_RECORD_Bill_CODE = "EJCBT202206000042";

    @Override
    public StandardChangeVO addConvertById(Long standardId) {
        StandardEntity standardEntity = standardService.selectById(standardId);
        StandardChangeVO changeVO = BeanMapper.map(standardEntity, StandardChangeVO.class);
        changeVO.setBillState(null);

        changeVO.setMainStandardId(standardId);
        changeVO.setMainStandardCode(standardEntity.getBillCode());
        changeVO.setChangeVersion(standardEntity.getChangeVersion() == null ? 1 : standardEntity.getChangeVersion()+ 1);
        changeVO.setCreateUserCode(null);
        changeVO.setCreateTime(null);
        changeVO.setUpdateUserCode(null);
        changeVO.setUpdateTime(null);
        changeVO.setChangeDate(new Date());
        changeVO.setId(null);
        changeVO.setEffectDate(null);
        changeVO.setBeforeChangeRiskDepositMny(standardEntity.getRiskDepositMny());

        changeVO.setChangeRiskDepositMny(BigDecimal.ZERO);
        changeVO.setChangeScale(BigDecimal.ZERO);

        //设置明细表字段
        for (StandardChangeDetailVO changeDetailVO : changeVO.getDetailList()) {
            changeDetailVO.setStandardId(standardId);
            changeDetailVO.setSrcTblId(changeDetailVO.getId());
            changeDetailVO.setId(IdWorker.getId());
        }

        return changeVO;
    }



    @Override
    @Transactional(rollbackFor = Exception.class)
    public StandardChangeVO insertOrUpdate(StandardChangeVO saveOrUpdateVO) {
        StandardChangeEntity entity = BeanMapper.map(saveOrUpdateVO, StandardChangeEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            StandardEntity standardEntity = standardService.selectById(entity.getMainStandardId());
            //历史记录 单据编码 第一个是 123456 第二个是123456101
            if(entity.getChangeVersion() < 11){
                if (entity.getChangeVersion() == 1){
                    entity.setBillCode(standardEntity.getBillCode());
                }else {
                    entity.setBillCode(entity.getBillCode() + "10" + (entity.getChangeVersion() - 1));
                }
            }else{
                entity.setBillCode(entity.getBillCode() + "1" + (entity.getChangeVersion() - 1));
            }

        }
        super.saveOrUpdate(entity, false);
        writeBackStandard(entity);
        return BeanMapper.map(super.selectById(entity.getId()), StandardChangeVO.class);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void removeStandardChange(Long id) {
        StandardChangeEntity changeEntity = super.selectById(id);
        //回写主标准表 把相关变更内容都删除
        StandardEntity standardEntity = standardService.selectById(changeEntity.getMainStandardId());
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("mainStandardId", new Parameter(QueryParam.EQ, changeEntity.getMainStandardId()));
        List<StandardChangeEntity> changeEntityList = super.queryList(queryParam);
        if (CollectionUtils.isNotEmpty(changeEntityList) && changeEntityList.size() > 1){
            standardEntity.setChangeStatus(ChangeStatusEnum.已变更.getCode());
        }else {
            standardEntity.setChangeStatus(ChangeStatusEnum.未变更.getCode());
        }
        standardEntity.setChangeId(null);
        standardEntity.setChangeCode(null);
        standardEntity.setChangeVersion(standardEntity.getChangeStatus() - 1);
        standardEntity.setChangeDate(null);
        standardEntity.setChangeEmployeeId(null);
        standardEntity.setChangeEmployeeName(null);
        standardService.saveOrUpdate(standardEntity, false);
        super.removeById(id, false);
    }


    /**
     * 变更单生效回写主标准表
     * @param changeBillId
     * @param billTypeCode
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public CommonResponse<String> effectiveSaveWriteStandard(Long changeBillId, String billTypeCode) {
        CommonResponse<String> resp = null;
        StandardChangeEntity changeEntity = super.selectById(changeBillId);
        logger.info("进入变更终审！变更表数据------------->: {}", JSONObject.toJSONString(changeEntity));

        /**复制标准表数据到记录表 begin */
        StandardEntity standardEntity = standardService.selectById(changeEntity.getMainStandardId());
        standardEntity.setChangeEffectDate(new Date());

        StandardRecordEntity recordEntity = BeanMapper.map(standardEntity, StandardRecordEntity.class);

        //设置变更后金额（暂时用变更中金额代替）
        recordEntity.setChangingRiskDepositMny(changeEntity.getRiskDepositMny());
        recordEntity.setId(null);
        recordEntity.setMainStandardId(standardEntity.getId());
        recordEntity.setBillCode(changeEntity.getBillCode());
        logger.info("变更前主标准表数据: {}", JSONObject.toJSONString(standardEntity));
        logger.info("变更前主标准表子表detail数据: {}", JSONObject.toJSONString(standardEntity.getDetailList()));
        logger.info("记录表从主标准表复制的数据: {}", JSONObject.toJSONString(recordEntity));
        logger.info("记录表从主标准表复制的数据的子表detail数据: {}", JSONObject.toJSONString(recordEntity.getDetailList()));
        logger.info("记录表从主标准表复制的数据的变更前金额: {}", JSONObject.toJSONString(recordEntity.getBeforeChangeRiskDepositMny()));

        if(CollectionUtils.isNotEmpty(recordEntity.getDetailList())){
            recordEntity.getDetailList().forEach(vo -> {
                vo.setSrcTableId(vo.getId());
                vo.setId(null);
            });
        }

        logger.info("记录表从主标准表表复制的子表detail数据，设置id后的值: {}", JSONObject.toJSONString(recordEntity.getDetailList()));
        recordService.saveOrUpdate(recordEntity, false);
        logger.info("审批-变更记录表保存主标准表数据成功！");

        //根据实体RefCode查询实体单据类型
        String srcBillCode = PROSUB_Bill_CODE;
        String targetBillCode = PROSUB_RECORD_Bill_CODE;
        if (standardEntity.getRiskDepositType().equals("directDept")){//直管部
            srcBillCode = DIRECT_Bill_CODE;
            targetBillCode = DIRECT_RECORD_Bill_CODE;
        }

        //原标准表附件、起草附件同步到记录单据中
        resp = copyFile(standardEntity.getId().toString(), srcBillCode,
                recordEntity.getId().toString(), targetBillCode, STANDARD_ATTACH_SOURCE_TYPE, STANDARD_FILE_SOURCE_TYPE);
        if(resp != null) {
            logger.error("同步原标准表附件到记录单据失败，失败原因：{}", JSONObject.toJSONString(resp));
        }
        /**复制标准表数据到记录表 end */


        /**更新变更表主表数据到原标准表 begin */
        logger.info("更新变更数据到主标准表,standardEntity---------------->: {}", JSONObject.toJSONString(standardEntity));
        //基本信息

        standardEntity.setBeforeChangeRiskDepositMny(changeEntity.getBeforeChangeRiskDepositMny());
//        standardEntity.setChangeEmployeeId(changeEntity.getChangeEmployeeId());
//        standardEntity.setChangeEmployeeName(changeEntity.getChangeEmployeeName());
        standardEntity.setChangeStatus(ChangeStatusEnum.已变更.getCode());
//        standardEntity.setContractCode(changeEntity.getContractCode());
//        standardEntity.setContractId(changeEntity.getContractId());
        standardEntity.setContractMny(changeEntity.getContractMny());
//        standardEntity.setContractName(changeEntity.getContractName());
//        standardEntity.setContractSignDate(changeEntity.getContractSignDate());
        standardEntity.setLastYearContractMny(changeEntity.getLastYearContractMny());
        standardEntity.setLastYearOutputMny(changeEntity.getLastYearOutputMny());
        standardEntity.setOutputMny(changeEntity.getOutputMny());
//        standardEntity.setProjectCode(changeEntity.getProjectCode());
//        standardEntity.setProjectId(changeEntity.getProjectId());
//        standardEntity.setProjectName(changeEntity.getProjectName());
        standardEntity.setRiskDepositMny(changeEntity.getRiskDepositMny());
        standardEntity.setRiskDepositPayableMny(changeEntity.getRiskDepositPayableMny());
        standardEntity.setRiskDepositPayableScale(changeEntity.getRiskDepositPayableScale());
        standardEntity.setWorkerCongressContractMny(changeEntity.getWorkerCongressContractMny());

        logger.info("1212-进入变更终审审核完回调：billTypeCode------>", billTypeCode);
        //同步变更单附件（不包含变更变更附件）到原标准表

        resp = copyFile(changeBillId.toString(), billTypeCode, standardEntity.getId().toString(), srcBillCode, "standardChangeFile", STANDARD_ATTACH_SOURCE_TYPE);
        if(resp != null) {
            logger.error("同步变更附件到原标准表失败，失败原因：{}", JSONObject.toJSONString(resp));
        }

        //变更单更新
        changeEntity.setEffectDate(new Date());
        super.saveOrUpdate(changeEntity);
        logger.info("更新变更表生效时间,changeEntity---------->： {}", JSONObject.toJSONString(changeEntity));

        /**更新变更表数据到原标准表 end */

        /**更新变更子表数据到原标准表 begin */
        logger.info("更新变更表数据到原标准表开始----------->" + standardEntity.getChangeStatus());


        List<StandardChangeDetailEntity> changeDetailList = changeEntity.getDetailList();
		/*
			变更详情表和标准表详情表有一个字段不一样
			变更详情表里 来源子表主键 srcTblId
		 */
        Map<Long, StandardChangeDetailEntity> changeSrcIdMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(changeDetailList)){
            changeDetailList.forEach(changeDetailEntity -> {
                //设置id和来源子表主键对应map
                changeSrcIdMap.put(changeDetailEntity.getSrcTblId() == null ? IdWorker.getId() : changeDetailEntity.getSrcTblId(), changeDetailEntity);
            });
        }

        List<StandardDetailEntity> standardDetailList = standardEntity.getDetailList();
        if(CollectionUtils.isNotEmpty(standardDetailList)){
            for(StandardDetailEntity standardDetail : standardDetailList) {
                if (changeSrcIdMap.containsKey(standardDetail.getId())){
                    standardDetail.setDetailMemo(changeSrcIdMap.get(standardDetail.getId()).getDetailMemo());
                    changeSrcIdMap.remove(standardDetail.getId());
                }else {
                    standardDetail.setRowState("del");
                }
            }

            if (null != changeSrcIdMap){
                for (Long key : changeSrcIdMap.keySet()) {
                    StandardChangeDetailEntity changeDetailEntity = changeSrcIdMap.get(key);
//                changeDetailEntity.setChangeBid();//变更子表id
                    changeDetailEntity.setId(null);
                    changeDetailEntity.setRowState("add");
                    standardDetailList.add(BeanMapper.map(changeDetailEntity, StandardDetailEntity.class));
                }
            }
        }
        standardEntity.setDetailList(standardDetailList);

        standardService.saveOrUpdate(standardEntity, false);
        logger.info("更新标准表数据成功,standardEntity---------->: {}", JSONObject.toJSONString(standardEntity));

        /**更新变更子表数据到原标准表子表 end */
        return CommonResponse.success("变更单生效，回写主标准表成功！");
    }



    /**
     * 回写主标准表
     * @param changeEntity
     */
    private void writeBackStandard(StandardChangeEntity changeEntity) {
        StandardEntity standardEntity = standardService.selectById(changeEntity.getMainStandardId());
        if (!(null != standardEntity.getChangeId() && standardEntity.getChangeId().equals(changeEntity.getId()))){
            standardEntity.setChangeId(changeEntity.getId());
            standardEntity.setChangeCode(changeEntity.getBillCode());
            standardEntity.setChangeVersion(changeEntity.getChangeVersion());
            standardEntity.setChangeStatus(ChangeStatusEnum.变更中.getCode());
            standardEntity.setChangeDate(new Date());
        }
        standardEntity.setChangeEmployeeId(changeEntity.getChangeEmployeeId());
        standardEntity.setChangeEmployeeName(changeEntity.getChangeEmployeeName());
        standardService.saveOrUpdate(standardEntity, false);
    }

    private StandardChangeVO queryDetail(Long changeId) {
        return BeanMapper.map(super.selectById(changeId), StandardChangeVO.class);
    }


    /**
     * 文件复制
     *
     * @param srcBillId 源单据Id
     * @param srcBillTypeCode 源单据类型
     * @param targetBillId 目标单据Id
     * @param targetBillTypeCode 目标单据类型
     * @param srcAttachSourceType 源单据附件业务类型
     * @param targetBillType 目标单据附件业务类型
     * @return
     */
    private CommonResponse copyFile(String srcBillId, String srcBillTypeCode, String targetBillId, String targetBillTypeCode, String srcAttachSourceType, String targetBillType) {

        //同步原标准表附件列表
        CommonResponse copyContractAttachResp = attachmentApi.copyFilesFromSourceBillToTargetBill(srcBillId, srcBillTypeCode,
                srcAttachSourceType, targetBillId, targetBillTypeCode, targetBillType);
        if (!copyContractAttachResp.isSuccess()){
            logger.info("同步标准表文件失败--------------->srcBillId-{},srcBillTypeCode-{},srcSourceType-{},targetBillId-{},targetBillTypeCode-{},targetSourceType-{},：{}"
                    ,srcBillId, srcBillTypeCode, targetBillType, targetBillId, targetBillTypeCode, targetBillType, copyContractAttachResp.getMsg());
            logger.info("同步附件管理中的附件失败--------------->失败信息------------>：{}", copyContractAttachResp.getMsg());
            return CommonResponse.error("审批失败，同步附件失败，错误信息：" + copyContractAttachResp.getMsg());
        }


        return null;
    }
}
