package com.ejianc.business.payer.controller;

import java.io.Serializable;

import com.ejianc.business.payer.bean.PayerRecordEntity;
import com.ejianc.business.payer.service.IpayerRecordService;
import com.ejianc.business.payer.vo.PayerDetailVO;
import com.ejianc.business.payer.vo.PayerRecordVO;
import com.ejianc.business.standard.bean.StandardEntity;
import com.ejianc.business.standard.enums.ChangeStatusEnum;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.payer.bean.PayerEntity;
import com.ejianc.business.payer.service.IpayerService;
import com.ejianc.business.payer.vo.PayerVO;

/**
 * 缴纳员工明细表主实体
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("payer")
public class payerController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;



    @Autowired
    private IpayerService service;

    @Autowired
    private IpayerRecordService recordService;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PayerVO> saveOrUpdate(@RequestBody PayerVO payerVO) {
    	PayerVO vo = service.insertOrUpdate(payerVO);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PayerVO> queryDetail(Long id) {
        PayerEntity entity = service.selectById(id);
        PayerVO vo = BeanMapper.map(entity, PayerVO.class);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("mainPayerId", new Parameter(QueryParam.EQ, vo.getId()));
        queryParam.getOrderMap().put("update_time", QueryParam.DESC);
        List<PayerRecordEntity> recordList = recordService.queryList(queryParam);
        vo.setRecordList(BeanMapper.mapList(recordList, PayerRecordVO.class));
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PayerVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (PayerVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(PayerVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        //当前组织id相当于是项目的parentOrgId，则根据项目部Id来进行查询
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentId(orgId);
        if (!orgResp.isSuccess()) {
            logger.error("分页查询失败，获取当前本下组织信息失败, {}", orgResp.getMsg());
            return CommonResponse.error("查询失败，获取组织信息失败！");
        }
        if (orgResp.getData().size() > 0){
            param.getParams().put("orgId", new Parameter(QueryParam.IN,
                    orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }else {
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
        }
        IPage<PayerEntity> pageData = service.queryPage(param,false);
        JSONObject page = new JSONObject();
        page.put("records", BeanMapper.mapList(pageData.getRecords(), PayerVO.class));
        page.put("total", pageData.getTotal());
        page.put("current", pageData.getCurrent());
        page.put("size", pageData.getSize());
        page.put("pages", pageData.getPages());

        //页面统计，累计申请金额，累计批复金额，累计实付金额
        Map<String, Object> sumMnyMap = service.countSumMny(param);
        page.put("sumMnyMap", sumMnyMap);

        return CommonResponse.success("查询列表数据成功！", page);
//        return null;
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {

        param.setPageSize(-1);
        CommonResponse<JSONObject> commonResponse = queryList(param);
        List<PayerVO> payerVOList = new ArrayList<>();
        if (null != commonResponse.getData()) {
            payerVOList = (List<PayerVO>) commonResponse.getData().get("records");
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");

            if (null != payerVOList && payerVOList.size() > 0) {
                for (PayerVO payerVO : payerVOList) {
                    //变更状态
                    payerVO.setChangeStatusName(ChangeStatusEnum.getEnumByCode(payerVO.getChangeStatus()).getDescription());
                    //流程状态
                    payerVO.setBillStateName(BillStateEnum.getEnumByStateCode(payerVO.getBillState()).getDescription());
                }
            }
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", payerVOList);
        if (null != param.getParams().get("riskDepositType")) {
            //导出无合同付款申请列表
            if (param.getParams().get("riskDepositType").getValue().equals("projectDept")) {
                ExcelExport.getInstance().export("projectDeptPayer-export.xlsx", beans, response);
            } else {
                ExcelExport.getInstance().export("directDeptPayer-export.xlsx", beans, response);
            }
        }
    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refpayerData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<PayerVO>> refpayerData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                       String condition,
                                                       String searchObject,
                                                       String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<PayerEntity> page = service.queryPage(param,false);
        IPage<PayerVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), PayerVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }



    /**
     * @Description 判断标准表是否被其他缴纳人员明细使用
     * @param
     */
    @RequestMapping(value = "/queryStandardFlag", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Integer> queryStandardFlag(@RequestBody Map<String, String> param) {
        String standardId = param.get("standardId");
        if (StringUtils.isNotBlank(standardId)){
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("standardId", new Parameter(QueryParam.EQ, standardId));
            return CommonResponse.success("查询数据成功",  service.queryList(queryParam).size());
        }
        return CommonResponse.error("请传入正确的项目id参数！");
    }



    /**
     * @Description 导出缴纳人员明细子表信息
     * @param
     * @Return void
     */
    @RequestMapping(value = "/payerDetailExcelExport", method = RequestMethod.POST)
    @ResponseBody
    public void payerDetailExcelExport(@RequestBody Map paramMap, HttpServletResponse response)    {

        String payerId = String.valueOf(paramMap.get("payerId"));
        PayerEntity payerEntity = service.selectById(payerId);
        List<PayerDetailVO> detailList = new ArrayList<>();
        if (null != payerEntity && CollectionUtils.isNotEmpty(payerEntity.getDetailList())){
            detailList = BeanMapper.mapList(payerEntity.getDetailList(), PayerDetailVO.class);
        }

        if (CollectionUtils.isNotEmpty(detailList)) {
            detailList.forEach(detailVO -> {
                //设置是否已分期
                //（0：否，1：是）
                if (null != detailVO.getPeriodizationFlag()){
                    if (0 == detailVO.getPeriodizationFlag()){
                        detailVO.setPeriodizationFlagName("否");
                    }else {
                        detailVO.setPeriodizationFlagName("是");
                    }
                }
            });
        }
        Map<String, Object> beans = new HashMap<>();

        beans.put("records", detailList);
        ExcelExport.getInstance().export("payerDetail-export.xlsx", beans, response);
    }

}
