/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pay.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.pay.bean.PayEntity;
import com.ejianc.business.pay.enums.ConfirmStatusEnum;
import com.ejianc.business.pay.mapper.PayMapper;
import com.ejianc.business.pay.service.IPayService;
import com.ejianc.business.pay.utils.MoneyUtils;
import com.ejianc.business.pay.vo.PayVO;
import com.ejianc.business.payer.bean.PayerDetailEntity;
import com.ejianc.business.payer.service.IpayerDetailService;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="payService")
public class PayServiceImpl
extends BaseServiceImpl<PayMapper, PayEntity>
implements IPayService {
    private final SessionManager sessionManager;
    private final IpayerDetailService payerDetailService;

    public PayServiceImpl(SessionManager sessionManager, IpayerDetailService payerDetailService) {
        this.sessionManager = sessionManager;
        this.payerDetailService = payerDetailService;
    }

    @Override
    public BigDecimal fetchLastPayTaxMny(Long userId, Long orgId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.select(new String[]{"ifnull(sum(pay_tax_mny),0) as lastPayTaxMny"}).eq((Object)"user_id", (Object)userId)).eq((Object)"org_id", (Object)orgId);
        return (BigDecimal)super.getMap((Wrapper)queryWrapper).get("lastPayTaxMny");
    }

    @Override
    public Date fetchMaxPayDate(Long userId, Long orgId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)queryWrapper.select(new String[]{"max(pay_date) as payDate"}).eq((Object)"user_id", (Object)userId)).eq((Object)"org_id", (Object)orgId)).eq((Object)"confirm_status", (Object)ConfirmStatusEnum.CONFIRM.getCode());
        if (super.getMap((Wrapper)queryWrapper) == null) {
            return null;
        }
        return (Date)super.getMap((Wrapper)queryWrapper).get("payDate");
    }

    @Override
    public boolean isLatestBill(Long billId, Long userId, Long orgId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)queryWrapper.eq((Object)"user_id", (Object)userId)).eq((Object)"org_id", (Object)orgId)).orderByDesc((Object)"pay_date");
        List list = super.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return ((PayEntity)((Object)list.get(0))).getId().equals(billId);
        }
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchConfirm(List<PayVO> pays) {
        List payEntities = BeanMapper.mapList(pays, PayEntity.class);
        UserContext userContext = this.sessionManager.getUserContext();
        Map payMap = payEntities.stream().collect(Collectors.toMap(PayEntity::getSourceBillId, Function.identity()));
        ArrayList<Long> ids = new ArrayList<Long>();
        for (Map.Entry entry : payMap.entrySet()) {
            PayEntity pay = (PayEntity)((Object)entry.getValue());
            pay.setConfirmStatus(ConfirmStatusEnum.CONFIRM.getCode());
            pay.setConfirmStatusName(ConfirmStatusEnum.CONFIRM.getName());
            pay.setConfirmDate(new Date());
            pay.setConfirmUserId(userContext.getUserId());
            pay.setConfirmUserCode(userContext.getUserCode());
            pay.setConfirmUserName(userContext.getUserName());
            ids.add(pay.getSourceBillId());
        }
        Collection payerDetails = this.payerDetailService.listByIds(ids);
        for (PayerDetailEntity pd : payerDetails) {
            PayEntity pay = (PayEntity)((Object)payMap.get(pd.getId()));
            pd.setPeriodizationFlag(Integer.parseInt(pay.getInstallmentFlag()));
            if (Integer.parseInt(pay.getInstallmentFlag()) == 1) {
                pd.setPeriodizationMny(MoneyUtils.yuanToTenThousand(pay.getInstallmentTaxMny()));
                pd.setPeriodizationNum(pay.getInstallmentNum());
                pd.setEachPeriodizationMny(MoneyUtils.yuanToTenThousand(pay.getInstallmentTaxMny().divide(pay.getPayTaxMny(), 2, RoundingMode.HALF_UP)));
            }
            pd.setActualPayerMny(MoneyUtils.yuanToTenThousand(pay.getTotalTaxMny()));
            pd.setActualPayerScale(pay.getPayScale());
            pd.setRemainderPayerMny(MoneyUtils.yuanToTenThousand(pay.getRemainPayTaxMny()));
        }
        this.payerDetailService.saveOrUpdateBatch(payerDetails, 10);
        super.saveOrUpdateBatch((Collection)payEntities, 10);
    }
}

