/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.payer.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.payer.bean.PayerDetailEntity;
import com.ejianc.business.payer.bean.PayerEntity;
import com.ejianc.business.payer.mapper.payerMapper;
import com.ejianc.business.payer.service.IpayerDetailService;
import com.ejianc.business.payer.service.IpayerService;
import com.ejianc.business.payer.vo.PayerVO;
import com.ejianc.business.standard.enums.ChangeStatusEnum;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="payerService")
public class payerServiceImpl
extends BaseServiceImpl<payerMapper, PayerEntity>
implements IpayerService {
    private static final String DIRECT_BILL_CODE = "DIRECT_DEPT_PAYER";
    private static final String PROJECT_BILL_CODE = "PROJECT_DEPT_PAYER";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IpayerDetailService payerDetailService;

    @Override
    public Map<String, Object> countSumMny(QueryParam param) {
        Map<String, Integer> resp = new HashMap();
        QueryWrapper wrapper = payerServiceImpl.changeToQueryWrapper((QueryParam)param);
        wrapper.select(new String[]{"sum(total_payer_mny) as totalPayMny, sum(base_mny) as totalBasePayMny"});
        resp = super.getMap((Wrapper)wrapper);
        if (null == resp) {
            resp = new HashMap();
            resp.put("totalPayMny", 0);
            resp.put("totalBasePayMny", 0);
        }
        return resp;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public PayerVO insertOrUpdate(PayerVO payerVO) {
        PayerEntity entity = (PayerEntity)((Object)BeanMapper.map((Object)payerVO, PayerEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)("directDept".equals(payerVO.getRiskDepositType()) ? DIRECT_BILL_CODE : PROJECT_BILL_CODE), (Long)InvocationInfoProxy.getTenantid(), (BaseVO)payerVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                this.logger.error("\u4fdd\u5b58\u6807\u51c6\u8868\u5931\u8d25\uff0c\u81ea\u52a8\u751f\u6210\u6807\u51c6\u8868\u5355\u636e\u7f16\u7801\u5931\u8d25: {}", (Object)billCode.getMsg());
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setId(IdWorker.getId());
            entity.setBillCode((String)billCode.getData());
            entity.setChangeStatus(ChangeStatusEnum.\u672a\u53d8\u66f4.getCode());
            entity.setBeforeChangePayerMny(payerVO.getTotalPayerMny());
            entity.setChangeVersion(0);
            entity.setBaseMny(payerVO.getTotalPayerMny());
        } else {
            PayerEntity oldEntity = (PayerEntity)((Object)super.selectById((Serializable)entity.getId()));
            if (oldEntity != null && !oldEntity.getStandardId().equals(payerVO.getStandardId())) {
                for (PayerDetailEntity oldDetail : oldEntity.getDetailList()) {
                    oldDetail.setRowState("del");
                }
                entity.getDetailList().addAll(oldEntity.getDetailList());
            }
        }
        List<PayerDetailEntity> payerDetailList = entity.getDetailList();
        for (PayerDetailEntity detail : payerDetailList) {
            if (null == detail.getPayerOrgId()) {
                detail.setPayerId(entity.getId());
                detail.setPayerCode(entity.getBillCode());
                detail.setPayerName(entity.getBillCode());
                detail.setPayerOrgCode(entity.getOrgCode());
                detail.setPayerOrgId(entity.getOrgId());
                detail.setPayerOrgName(entity.getOrgName());
                detail.setPayerBelongYear(entity.getBelongYear());
            }
            detail.setPayerEmployeeId(entity.getEmployeeId());
            detail.setPayerEmployeeName(entity.getEmployeeName());
        }
        super.saveOrUpdate((Object)entity, false);
        PayerVO vo = (PayerVO)BeanMapper.map((Object)super.selectById((Serializable)entity.getId()), PayerVO.class);
        return vo;
    }
}

