package com.ejianc.business.pay.enums;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author baipengyan
 * @date 2022/6/27
 * @description 风险金缴纳确认状态枚举
 */
public enum ConfirmStatusEnum {
	/**
	 * 未确认
	 */
	UNCONFIRM(0, "待确认"),
	/**
	 * 确认中
	 */
	CONFIRMING(1, "确认中"),
	/**
	 * 已确认
	 */
	CONFIRM(2, "已确认");

	private final Integer code;
	private final String name;

	ConfirmStatusEnum(Integer code, String name) {
		this.code = code;
		this.name = name;
	}

	public Integer getCode() {
		return code;
	}

	public String getName() {
		return name;
	}

	private static Map<Integer, ConfirmStatusEnum> enumMap = new HashMap<>();

	static {
		enumMap = EnumSet.allOf(ConfirmStatusEnum.class).stream().collect(Collectors.toMap(ConfirmStatusEnum::getCode, Function.identity(), (k1, k2) -> k2));
	}

	public static ConfirmStatusEnum getEnumByCode(Integer code) {
		return enumMap.get(code);
	}
}
