package com.ejianc.business.pay.service;

import com.ejianc.business.pay.bean.PayEntity;
import com.ejianc.business.pay.vo.PayVO;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.Date;
import java.util.List;

/**
 * 风险金缴纳表
 *
 * @author baipengyan
 */
public interface IPayService extends IBaseService<PayEntity> {

	/**
	 * 获取当前人员缴纳明细的最大缴纳日期
	 *
	 * @param sourceBillId 来源单据id
	 *
	 * @return 最大缴纳日期
	 */
	Date fetchMaxPayDate(Long sourceBillId);

	/**
	 * 是否是最新单据
	 *
	 * @param billId       单据id
	 * @param sourceBillId 来源单据id
	 *
	 * @return 是否是最新单据
	 */
	boolean isLatestBill(Long billId, Long sourceBillId);

	/**
	 * 风险金缴纳：批量确认
	 *
	 * @param pays 要确认的单据信息
	 */
	void batchConfirm(List<PayVO> pays);
}
