package com.ejianc.business.standard.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.standard.bean.StandardDetailEntity;
import com.ejianc.business.standard.bean.StandardEntity;
import com.ejianc.business.standard.enums.ChangeStatusEnum;
import com.ejianc.business.standard.service.IStandardDetailService;
import com.ejianc.business.standard.service.IStandardService;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

@Service("standard") 
public class StandardBpmServiceImpl implements ICommonBusinessService {

    @Autowired
    private IBillTypeApi billTypeApi;

    @Autowired
	private IStandardService standardService;

    @Autowired
	private IStandardDetailService standardDetailService;

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return doBpmBack(billId, state, billTypeCode);
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		StandardEntity e = standardService.selectById(billId);
		e.setEffectDate(new Date());
		standardService.saveOrUpdate(e, false);
		return CommonResponse.success("风险金缴纳标准表审批回调处理成功！");
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		return doBpmBack(billId, state, billTypeCode);
	}


	@Transactional(rollbackFor = Exception.class)
	public CommonResponse<String> doBpmBack(Long billId, Integer state, String billTypeCode) {
		StandardEntity e = standardService.selectById(billId);
		if(e!=null){
			if(e.getChangeStatus() == ChangeStatusEnum.变更中.getCode()){
				return CommonResponse.error("变更中单据无法撤回");
			}
			if(e.getChangeStatus() == ChangeStatusEnum.已变更.getCode()){
				return CommonResponse.error("已变更单据无法撤回");
			}
		}

		List<StandardDetailEntity> detailEntityList = e.getDetailList();
		if (CollectionUtils.isNotEmpty(detailEntityList)){
			List<Long> projectIds = detailEntityList.stream().map(StandardDetailEntity::getProjectId).collect(Collectors.toList());
			if (CollectionUtils.isNotEmpty(projectIds)){
				QueryParam queryParam = new QueryParam();
				queryParam.getParams().put("projectId", new Parameter(QueryParam.IN, projectIds));
				queryParam.getParams().put("riskDepositType", new Parameter(QueryParam.EQ, "projectDept"));
				List<StandardEntity> standardEntityList = standardService.queryList(queryParam);

				if (CollectionUtils.isNotEmpty(standardEntityList)){
					return CommonResponse.error("当前单据子表中项目：" + standardEntityList.get(0).getProjectName() + "已被下游项目标准表引用，无法撤回！");
				}
			}
		}


		logger.info("风险金缴纳标准表单据【billId-{}】,【billTypeCode-{}】执行弃审前校验！", billId, billTypeCode);
		CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
		logger.info("风险金缴纳标准表单据【billId-{}】,【billTypeCode-{}】校验被下游单据引用结果：{}", billId, billTypeCode, JSONObject.toJSONString(resp));
		if(!resp.isSuccess()) {
			logger.info("风险金缴纳标准表单据【billId-{}】,【billTypeCode-{}】执行弃审操作校验结束，未通过校验，原因：{}", resp.getMsg());
			return CommonResponse.error(resp.getMsg());
		}

		return CommonResponse.success("风险金缴纳标准表单据弃审/撤回成功！");
	}

}
