package com.ejianc.business.pay.utils;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;

/**
 * @author baipengyan
 * @date 2022/7/8
 * @description 金额工具类
 */
public class MoneyUtils {

	public static final BigDecimal TEN_THOUSAND = new BigDecimal("10000");

	public MoneyUtils() {
		super();
	}

	/**
	 * 万元转元
	 *
	 * @param tenThousand 万元
	 *
	 * @return 元
	 */
	public static BigDecimal tenThousandToYuan(BigDecimal tenThousand) {
		if (tenThousand == null) {
			return BigDecimal.ZERO;
		}
		return tenThousand.multiply(TEN_THOUSAND, new MathContext(2, RoundingMode.HALF_UP));
	}

	/**
	 * 元转万元
	 *
	 * @param yuan 元
	 *
	 * @return 万元
	 */
	public static BigDecimal yuanToTenThousand(BigDecimal yuan) {
		if (yuan == null) {
			return BigDecimal.ZERO;
		}
		return yuan.divide(TEN_THOUSAND, new MathContext(2, RoundingMode.HALF_UP));
	}

}
