package com.ejianc.business.payer.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.payer.bean.PayerChangeDetailEntity;
import com.ejianc.business.payer.bean.PayerDetailEntity;
import com.ejianc.business.payer.bean.PayerEntity;
import com.ejianc.business.payer.service.IPayerChangeDetailService;
import com.ejianc.business.payer.vo.PayerDetailVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.business.payer.service.IPayerService;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.payer.bean.PayerDetailEntity;
import com.ejianc.business.payer.service.IPayerDetailService;
import com.ejianc.business.payer.vo.PayerDetailVO;

/**
 * 缴纳员工明细表子实体
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("payerDetail")
public class PayerDetailController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IPayerDetailService service;

    @Autowired
    private IPayerChangeDetailService payerChangeDetailService;

    @Autowired
    private IPayerService ipayerService;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PayerDetailVO> saveOrUpdate(@RequestBody PayerDetailVO saveOrUpdateVO) {
    	PayerDetailEntity entity = BeanMapper.map(saveOrUpdateVO, PayerDetailEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	PayerDetailVO vo = BeanMapper.map(entity, PayerDetailVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PayerDetailVO> queryDetail(Long id) {
    	PayerDetailEntity entity = service.selectById(id);
    	PayerDetailVO vo = BeanMapper.map(entity, PayerDetailVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PayerDetailVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (PayerDetailVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(PayerDetailVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PayerDetailVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<PayerDetailEntity> page = service.queryPage(param,false);
        IPage<PayerDetailVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), PayerDetailVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<PayerDetailEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("payerDetail-export.xlsx", beans, response);
    }

    /**
     * @Description 参照 缴纳员工明细表参照
     * @Return void
     * @return
     */
    @RequestMapping(value = "/refpayerDetailData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<PayerDetailVO>> refpayerDetailData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                             String condition,
                                                             String searchObject,
                                                             String searchText,
                                                             String relyCondition) {

        QueryParam param = new QueryParam();
        String userId = "";
        Long sourceBillId = null;
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if (StringUtils.isBlank(_con.getString("userId"))) {
                return CommonResponse.error("查询失败，缺少参数用户id-userId！");
            }
            if (_con.getLong("sourceBillId") != null) {
                sourceBillId = _con.getLong("sourceBillId");
                // 排除员工明细
                param.getParams().put("id", new Parameter(QueryParam.NE, sourceBillId));
            }
            userId = _con.getString("userId");
        }

        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("userId", new Parameter(QueryParam.EQ, userId));

        //筛选出出已生效的缴纳明细单
        List<Long> effectIds = new ArrayList<>();
        QueryParam payerDetailQuery = new QueryParam();
        payerDetailQuery.getParams().put("userId", new Parameter(QueryParam.EQ, userId));

        List<PayerDetailEntity> payerDetailEntities = service.queryList(payerDetailQuery);
        if (CollectionUtils.isNotEmpty(payerDetailEntities)) {
            List<Long> payerIds = payerDetailEntities.stream().map(PayerDetailEntity::getPayerId).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(payerIds)) {
                QueryParam queryParam = new QueryParam();
                queryParam.getParams().put("id", new Parameter(QueryParam.IN, payerIds));
                queryParam.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(
                        BillStateEnum.COMMITED_STATE.getBillStateCode(),
                        BillStateEnum.PASSED_STATE.getBillStateCode())));
                List<PayerEntity> payerEntityList = ipayerService.queryList(queryParam);
                if (CollectionUtils.isNotEmpty(payerEntityList)){
                    effectIds = payerEntityList.stream().map(PayerEntity::getId).distinct().collect(Collectors.toList());
                }
            }
        }
        if (CollectionUtils.isNotEmpty(effectIds)){
            param.getParams().put("payerId", new Parameter(QueryParam.IN, effectIds));
        }
        else {
            param.getParams().put("payerId", new Parameter(QueryParam.EQ, null));
        }
        IPage<PayerDetailEntity> page = service.queryPage(param,false);
        IPage<PayerDetailVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<PayerDetailVO> resultRecord = BeanMapper.mapList(page.getRecords(), PayerDetailVO.class);
        if (CollectionUtils.isNotEmpty(resultRecord)){
            for (PayerDetailVO record : resultRecord) {
                if (null != record.getPeriodizationFlag()){
                    record.setPeriodizationFlagName(0 == record.getPeriodizationFlag() ? "否" : "是");
                }
            }
        }
        if (CollectionUtils.isNotEmpty(resultRecord)){
            for (PayerDetailVO detail : resultRecord) {
                if (null != detail.getPayerMny()){
                    detail.setPayerMnyWan(detail.getPayerMny().divide(new BigDecimal(10000)));
                }else {
                    detail.setPayerMnyWan(BigDecimal.ZERO);
                }
                if (null != detail.getActualPayerMny()){
                    detail.setActualPayerMnyWan(detail.getActualPayerMny().divide(new BigDecimal(10000)));
                }else {
                    detail.setActualPayerMnyWan(BigDecimal.ZERO);
                }
                if (null != detail.getRemainderPayerMny()){
                    detail.setRemainderPayerMnyWan(detail.getRemainderPayerMny().divide(new BigDecimal(10000)));
                }else {
                    detail.setRemainderPayerMnyWan(BigDecimal.ZERO);
                }
                if (null != detail.getActualPayerScale()){
                    detail.setActualPayerScale(detail.getActualPayerScale().multiply(new BigDecimal(100)));
                }else {
                    detail.setActualPayerScale(BigDecimal.ZERO);
                }
            }
        }
        pageData.setRecords(resultRecord);

        return CommonResponse.success("查询参照数据成功！",pageData);
    }


    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refpayerDetails", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<PayerDetailVO>> refpayerDetails(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                   String condition,
                                                                   String searchObject,
                                                                   String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if (_con.containsKey("payerId")) {
                param.getParams().put("payerId", new Parameter(QueryParam.EQ, Long.valueOf(String.valueOf(_con.get("payerId")))));
            }
        }
        IPage<PayerDetailEntity> page = service.queryPage(param,false);
        if(null!=page&&CollectionUtils.isNotEmpty(page.getRecords())){
            IPage<PayerDetailVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
            pageData.setRecords(BeanMapper.mapList(page.getRecords(), PayerDetailVO.class));
            return CommonResponse.success("查询参照数据成功！",pageData);
        }else{
            //取变更对应的数据
            IPage<PayerChangeDetailEntity> changeDetailEntityIPage = payerChangeDetailService.queryPage(param,false);
            IPage<PayerDetailVO> pageData = new Page<>(changeDetailEntityIPage.getCurrent(), changeDetailEntityIPage.getSize(), changeDetailEntityIPage.getTotal());
            pageData.setRecords(BeanMapper.mapList(changeDetailEntityIPage.getRecords(), PayerDetailVO.class));
            return CommonResponse.success("查询参照数据成功！",pageData);
        }
    }
}
