/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.approve.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.approve.bean.ApproveCashEntity;
import com.ejianc.business.approve.bean.ApproveCollectEntity;
import com.ejianc.business.approve.bean.ApproveEntity;
import com.ejianc.business.approve.service.IApproveService;
import com.ejianc.business.approve.vo.ApproveVO;
import com.ejianc.business.cash.bean.CashEntity;
import com.ejianc.business.cash.service.ICashService;
import com.ejianc.business.cash.vo.CashCostVO;
import com.ejianc.business.collect.bean.CollectEntity;
import com.ejianc.business.collect.service.ICollectService;
import com.ejianc.business.payer.bean.PayerEntity;
import com.ejianc.business.payer.service.IPayerService;
import com.ejianc.business.standard.bean.StandardEntity;
import com.ejianc.business.standard.service.IStandardService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"approve"})
public class ApproveController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "APPROVE_CODE";
    @Autowired
    private IApproveService service;
    @Autowired
    private ICashService cashService;
    @Autowired
    private ICollectService collectService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IStandardService standardService;
    @Autowired
    private IPayerService payerService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ApproveVO> saveOrUpdate(@RequestBody ApproveVO saveOrUpdateVO) {
        LambdaUpdateWrapper updateWrapper;
        ApproveEntity entity = (ApproveEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ApproveEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        if (CollectionUtils.isNotEmpty(entity.getApproveCashList())) {
            List cashIds = entity.getApproveCashList().stream().map(ApproveCashEntity::getCashId).collect(Collectors.toList());
            updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.in(BaseEntity::getId, cashIds);
            updateWrapper.set(CashEntity::getApproveFlag, (Object)1);
            this.cashService.update((Wrapper)updateWrapper);
        }
        if (CollectionUtils.isNotEmpty(entity.getApproveCollectList())) {
            List collectIds = entity.getApproveCollectList().stream().map(ApproveCollectEntity::getCollectId).collect(Collectors.toList());
            updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.in(BaseEntity::getId, collectIds);
            updateWrapper.set(CollectEntity::getApproveFlag, (Object)1);
            this.collectService.update((Wrapper)updateWrapper);
        }
        ApproveVO vo = (ApproveVO)BeanMapper.map((Object)((Object)entity), ApproveVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ApproveVO> queryDetail(Long id) {
        ApproveEntity entity = (ApproveEntity)((Object)this.service.selectById(id));
        ApproveVO vo = (ApproveVO)BeanMapper.map((Object)((Object)entity), ApproveVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryCostMny"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<CashCostVO> queryCostMny(Long projectId) {
        CashCostVO resVo = new CashCostVO();
        ArrayList<Integer> billList = new ArrayList<Integer>();
        billList.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        billList.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(StandardEntity::getRiskDepositType, (Object)"projectDept");
        lambda.eq(StandardEntity::getProjectId, (Object)projectId);
        lambda.in(StandardEntity::getBillState, billList);
        List resList = this.standardService.list((Wrapper)lambda);
        if (CollectionUtils.isNotEmpty((Collection)resList)) {
            resVo.setType(Integer.valueOf(0));
            resVo.setRiskDepositMny(((StandardEntity)((Object)resList.get(0))).getRiskDepositMny());
        } else {
            resVo.setType(Integer.valueOf(1));
        }
        LambdaQueryWrapper lambda2 = Wrappers.lambdaQuery();
        lambda2.eq(PayerEntity::getRiskDepositType, (Object)"projectDept");
        lambda2.eq(PayerEntity::getProjectId, (Object)projectId);
        lambda2.in(PayerEntity::getBillState, billList);
        List payerEntities = this.payerService.list((Wrapper)lambda2);
        if (CollectionUtils.isNotEmpty((Collection)payerEntities)) {
            resVo.setPayRiskDeductionMny(((PayerEntity)((Object)payerEntities.get(0))).getTotalActualPayerMny());
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)resVo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ApproveVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (ApproveVO vo : vos) {
                LambdaUpdateWrapper updateWrapper;
                ApproveEntity entity = (ApproveEntity)((Object)this.service.selectById(vo.getId()));
                if (CollectionUtils.isNotEmpty(entity.getApproveCashList())) {
                    List cashIds = entity.getApproveCashList().stream().map(ApproveCashEntity::getCashId).collect(Collectors.toList());
                    updateWrapper = new LambdaUpdateWrapper();
                    updateWrapper.in(BaseEntity::getId, cashIds);
                    updateWrapper.set(CashEntity::getApproveFlag, (Object)0);
                    this.cashService.update((Wrapper)updateWrapper);
                }
                if (!CollectionUtils.isNotEmpty(entity.getApproveCollectList())) continue;
                List collectIds = entity.getApproveCollectList().stream().map(ApproveCollectEntity::getCollectId).collect(Collectors.toList());
                updateWrapper = new LambdaUpdateWrapper();
                updateWrapper.in(BaseEntity::getId, collectIds);
                updateWrapper.set(CollectEntity::getApproveFlag, (Object)0);
                this.collectService.update((Wrapper)updateWrapper);
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ApproveVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ApproveVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Approve-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refApproveData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ApproveVO>> refApproveData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ApproveVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

