/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.rmat.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.finance.pub.vo.PubContractSettleVO;
import com.ejianc.business.finance.util.MathUtil;
import com.ejianc.business.rmat.bean.RentContractEntity;
import com.ejianc.business.rmat.bean.RentSettlementEntity;
import com.ejianc.business.rmat.service.IRentContractService;
import com.ejianc.business.rmat.service.IRentSettlementService;
import com.ejianc.business.rmat.vo.RmatSettlementVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/rmat/"})
public class RmatContractApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IRentSettlementService rentSettleService;
    @Autowired
    private IRentContractService rentContractService;

    @PostMapping(value={"getContract"})
    public CommonResponse<JSONObject> getContract(@RequestBody QueryParam param) {
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", null);
    }

    @PostMapping(value={"getContractSettle"})
    public CommonResponse<JSONObject> getContractSettle(@RequestBody QueryParam param) {
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", null);
    }

    @PostMapping(value={"getRmatSettle"})
    public CommonResponse<JSONObject> getRmatSettle(@RequestBody QueryParam param) {
        try {
            List fuzzyFields = param.getFuzzyFields();
            fuzzyFields.add("billCode");
            fuzzyFields.add("orgName");
            fuzzyFields.add("employeeName");
            fuzzyFields.add("customerName");
            fuzzyFields.add("supplierName");
            param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
            param.getOrderMap().put("createTime", "desc");
            param.getComplexParams().add(ComplexParam.getApprovedComplexParam((String)"and"));
            IPage pageData = this.rentSettleService.queryPage(param, false);
            List entityList = pageData.getRecords();
            ArrayList<PubContractSettleVO> voList = new ArrayList<PubContractSettleVO>();
            for (RentSettlementEntity entity : entityList) {
                PubContractSettleVO vo = new PubContractSettleVO();
                vo.setId(entity.getId());
                vo.setBillCode(entity.getBillCode());
                vo.setSettleMny(MathUtil.safeSub((BigDecimal)entity.getSettlementTaxMny(), (BigDecimal)entity.getOffsetMny()));
                vo.setCreateUserCode(entity.getCreateUserCode());
                vo.setCreateTime(entity.getCreateTime());
                voList.add(vo);
            }
            JSONObject page = new JSONObject();
            page.put("records", voList);
            page.put("total", (Object)pageData.getTotal());
            page.put("current", (Object)pageData.getCurrent());
            page.put("size", (Object)pageData.getSize());
            page.put("pages", (Object)pageData.getPages());
            return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
        }
        catch (Exception e) {
            this.logger.error("\u7cfb\u7edf\u5f02\u5e38\uff1a" + e.getMessage());
            e.printStackTrace();
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25");
        }
    }

    @GetMapping(value={"updateRentSettleSumPayMny"})
    public CommonResponse<String> updateRentSettleSumPayMny(@RequestParam(value="settleId", required=true) Long settleId, @RequestParam(value="payMny") BigDecimal payMny) {
        RentSettlementEntity entity = (RentSettlementEntity)((Object)this.rentSettleService.selectById(settleId));
        if (entity == null) {
            return CommonResponse.error((String)"\u6ca1\u6709\u627e\u5230\u76f8\u5e94\u5468\u8f6c\u6750\u79df\u8d41\u7ed3\u7b97\u5355\uff01");
        }
        BigDecimal sumPayMny = entity.getSumPayMny();
        sumPayMny = MathUtil.safeAdd((BigDecimal)sumPayMny, (BigDecimal)payMny);
        entity.setSumPayMny(sumPayMny);
        this.rentSettleService.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((String)"\u56de\u5199\u5468\u8f6c\u6750\u79df\u8d41\u7ed3\u7b97\u5355\u7d2f\u8ba1\u4ed8\u6b3e\u91d1\u989d\u6210\u529f\uff01");
    }

    @GetMapping(value={"getRentSettlementById"})
    public CommonResponse<RmatSettlementVO> getRentSettlementById(@RequestParam(value="contractId", required=true) Long contractId, @RequestParam(value="orgId", required=true) Long orgId) {
        RmatSettlementVO vo = new RmatSettlementVO();
        vo.setSumOffsetMny(new BigDecimal("0.00").setScale(2, 4));
        LambdaQueryWrapper lambdachange = Wrappers.lambdaQuery();
        lambdachange.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        lambdachange.eq(RentSettlementEntity::getContractId, (Object)contractId);
        lambdachange.eq(RentSettlementEntity::getOrgId, (Object)orgId);
        lambdachange.in(RentSettlementEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        List list = this.rentSettleService.list((Wrapper)lambdachange);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            BigDecimal[] sumOffsetMny = new BigDecimal[]{new BigDecimal("0.00").setScale(2, 4)};
            list.forEach(e -> {
                sumOffsetMny[0] = sumOffsetMny[0].add(e.getOffsetMny() == null ? BigDecimal.ZERO : e.getOffsetMny());
            });
            vo.setSumOffsetMny(sumOffsetMny[0]);
        }
        return CommonResponse.success((String)"\u83b7\u53d6\u4fe1\u606f\u6210\u529f", (Object)vo);
    }

    @GetMapping(value={"updateRentSettleSumApplyMny"})
    public CommonResponse<String> updateRentSettleSumApplyMny(@RequestParam(value="settleId", required=true) Long settleId, @RequestParam(value="applyMny") BigDecimal applyMny) {
        RentSettlementEntity entity = (RentSettlementEntity)((Object)this.rentSettleService.selectById(settleId));
        if (entity == null) {
            return CommonResponse.error((String)"\u6ca1\u6709\u627e\u5230\u76f8\u5e94\u5468\u8f6c\u6750\u79df\u8d41\u7ed3\u7b97\u5355\uff01");
        }
        BigDecimal sumApplyMny = entity.getSumApplyMny();
        sumApplyMny = MathUtil.safeAdd((BigDecimal)sumApplyMny, (BigDecimal)applyMny);
        entity.setSumApplyMny(sumApplyMny);
        BigDecimal surplusApplyMny = MathUtil.safeSub((BigDecimal)MathUtil.safeSub((BigDecimal)entity.getSettlementTaxMny(), (BigDecimal)entity.getOffsetMny()), (BigDecimal)applyMny);
        entity.setSurplusApplyMny(surplusApplyMny);
        this.rentSettleService.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((String)"\u56de\u5199\u5468\u8f6c\u6750\u79df\u8d41\u7ed3\u7b97\u5355\u7d2f\u8ba1\u7533\u8bf7\u91d1\u989d\u3001\u5269\u4f59\u53ef\u7533\u8bf7\u91d1\u989d\u6210\u529f\uff01");
    }

    @GetMapping(value={"updateRentContractSumPayMny"})
    public CommonResponse<String> updateRentContractSumPayMny(@RequestParam(value="contractId", required=true) Long contractId, @RequestParam(value="payMny") BigDecimal payMny, @RequestParam(value="prepayMny") BigDecimal prepayMny) {
        RentContractEntity entity = (RentContractEntity)((Object)this.rentContractService.selectById(contractId));
        if (entity == null) {
            return CommonResponse.error((String)"\u6ca1\u6709\u627e\u5230\u76f8\u5e94\u5468\u8f6c\u6750\u79df\u8d41\u5408\u540c\uff01");
        }
        BigDecimal sumPayMny = entity.getSumPayMny();
        sumPayMny = MathUtil.safeAdd((BigDecimal)sumPayMny, (BigDecimal)payMny);
        entity.setSumPayMny(sumPayMny);
        BigDecimal sumPrepayMny = entity.getSumPrepayMny();
        sumPrepayMny = MathUtil.safeAdd((BigDecimal)sumPrepayMny, (BigDecimal)prepayMny);
        entity.setSumPrepayMny(sumPrepayMny);
        this.rentContractService.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((String)"\u56de\u5199\u5468\u8f6c\u6750\u79df\u8d41\u5408\u540c\u7d2f\u8ba1\u4ed8\u6b3e\u91d1\u989d\u3001\u7d2f\u8ba1\u9884\u4ed8\u6b3e\u91d1\u989d\u6210\u529f\uff01");
    }
}

