/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.rmat.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.finance.api.IPayContractApi;
import com.ejianc.business.finance.util.MathUtil;
import com.ejianc.business.finance.vo.SumPayMnyVO;
import com.ejianc.business.rmat.bean.RentSettlementEntity;
import com.ejianc.business.rmat.service.IRentContractService;
import com.ejianc.business.rmat.service.IRentSettlementService;
import com.ejianc.business.rmat.vo.ParamsCheckVO;
import com.ejianc.business.rmat.vo.RentContractVO;
import com.ejianc.business.rmat.vo.RentSettlementDetailVO;
import com.ejianc.business.rmat.vo.RentSettlementRecordVO;
import com.ejianc.business.rmat.vo.RentSettlementVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"rentSettlement"})
public class RentSettlementController {
    @Autowired
    private IRentSettlementService rentSettlementService;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IPayContractApi payContractApi;
    @Autowired
    private IRentContractService rentContractService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<RentSettlementVO> saveOrUpdate(@RequestBody RentSettlementVO rentSettlementVo) {
        System.out.println(rentSettlementVo);
        if (null != rentSettlementVo.getId() && !"".equals(rentSettlementVo.getId()) && rentSettlementVo.getSettlementType() != 1) {
            if (this.rentSettlementService.queryById(rentSettlementVo.getId(), rentSettlementVo.getContractId()) == 0) {
                return this.rentSettlementService.saveOrUpdate(rentSettlementVo);
            }
            return CommonResponse.error((String)"\u5408\u540c\u5b58\u5728\u6700\u7ec8\u7ed3\u7b97!");
        }
        if (this.rentSettlementService.queryByContractId(rentSettlementVo.getContractId()) == 0) {
            return this.rentSettlementService.saveOrUpdate(rentSettlementVo);
        }
        return CommonResponse.error((String)"\u5408\u540c\u5b58\u5728\u6700\u7ec8\u7ed3\u7b97!");
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<RentSettlementVO> queryDetail(@RequestParam Long id) {
        RentSettlementVO rentSettlementVo = this.rentSettlementService.queryDetail(id);
        return CommonResponse.success((Object)rentSettlementVo);
    }

    @RequestMapping(value={"/queryDetails"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<RentSettlementVO> queryDetails(@RequestParam Long id) {
        RentSettlementVO rentSettlementVO = this.rentSettlementService.queryDetails(id);
        return CommonResponse.success((Object)rentSettlementVO);
    }

    @RequestMapping(value={"/queryDetailRecord"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<RentSettlementRecordVO> queryDetailRecord(@RequestParam Long id) {
        RentSettlementRecordVO rentSettlementRecordVO = this.rentSettlementService.querySettlementRecord(id);
        return CommonResponse.success((Object)rentSettlementRecordVO);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<RentSettlementVO> vos) {
        this.rentSettlementService.deleteRentSettlement(vos);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"/pageList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> pageList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        ArrayList commonOrgIds = new ArrayList();
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse orgListResp = this.orgApi.findChildrenByParentId(orgId);
        if (!orgListResp.isSuccess()) {
            return CommonResponse.success((String)"\u5408\u540c\u5206\u9875\u5217\u8868\u67e5\u8be2\u5931\u8d25, \u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        commonOrgIds.addAll(((List)orgListResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        }
        IPage pageData = this.rentSettlementService.queryPage(param, false);
        JSONObject page = new JSONObject();
        page.put("records", (Object)BeanMapper.mapList((Iterable)pageData.getRecords(), RentSettlementVO.class));
        page.put("total", (Object)pageData.getTotal());
        page.put("current", (Object)pageData.getCurrent());
        page.put("size", (Object)pageData.getSize());
        page.put("pages", (Object)pageData.getPages());
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("SettlementName");
        fuzzyFields.add("billCode");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        ArrayList commonOrgIds = new ArrayList();
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse orgListResp = this.orgApi.findChildrenByParentId(orgId);
        if (!orgListResp.isSuccess()) {
            throw new BusinessException("\u5408\u540c\u5206\u9875\u5217\u8868\u67e5\u8be2\u5931\u8d25, \u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        commonOrgIds.addAll(((List)orgListResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        }
        IPage pageData = this.rentSettlementService.queryPage(param, false);
        List list = new ArrayList();
        if (null != pageData.getRecords() && CollectionUtils.isNotEmpty((Collection)pageData.getRecords())) {
            list = BeanMapper.mapList((Iterable)pageData.getRecords(), RentSettlementVO.class);
            System.out.println(pageData.getRecords());
            list.forEach(vo -> {
                vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
                vo.setSumSettleRate(MathUtil.safeMultiply((BigDecimal)MathUtil.safeDiv((BigDecimal)vo.getSumSettlementTaxMny(), (BigDecimal)vo.getContractTaxMny()), (BigDecimal)new BigDecimal(100)));
                vo.setContainSumSettlementTaxMny(vo.getSettlementTaxMny().add(vo.getSumSettlementTaxMny()));
            });
        }
        HashMap beans = new HashMap();
        beans.put("records", list);
        ExcelExport.getInstance().export("rentSettlementListExport.xlsx", beans, response);
    }

    @RequestMapping(value={"/rentSettlementRef"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<RentSettlementVO>> rentSettlementRef(@RequestParam(defaultValue="1") Integer pageNumber, @RequestParam(defaultValue="10") Integer pageSize, @RequestParam(value="condition", required=false) String condition, @RequestParam(value="searchText", required=false) String searchText) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber.intValue());
        queryParam.setPageSize(pageSize.intValue());
        queryParam.setSearchText(searchText);
        queryParam.getFuzzyFields().add("contractName");
        queryParam.getFuzzyFields().add("billCode");
        queryParam.getFuzzyFields().add("supplierName");
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getComplexParams().add(ComplexParam.getApprovedComplexParam((String)"and"));
        queryParam.getOrderMap().put("create_time", "desc");
        if (StringUtils.isNotBlank((CharSequence)condition)) {
            JSONObject con = JSONObject.parseObject((String)condition);
            if (condition.contains("contractId")) {
                queryParam.getParams().put("contractId", new Parameter("eq", (Object)con.getLong("contractId")));
            }
            if (condition.contains("orgId")) {
                queryParam.getParams().put("orgId", new Parameter("eq", (Object)con.getLong("orgId")));
            }
            if (condition.contains("supplierId")) {
                queryParam.getParams().put("supplierId", new Parameter("eq", (Object)con.getLong("supplierId")));
            }
        }
        IPage pageData = this.rentSettlementService.queryPage(queryParam, false);
        Page result = new Page(pageData.getCurrent(), pageData.getSize(), pageData.getTotal());
        for (RentSettlementEntity entity : pageData.getRecords()) {
            entity.setSurplusApplyMny(MathUtil.safeSub((BigDecimal)MathUtil.safeSub((BigDecimal)entity.getSettlementTaxMny(), (BigDecimal)entity.getOffsetMny()), (BigDecimal)entity.getSumApplyMny()));
        }
        List voList = BeanMapper.mapList((Iterable)pageData.getRecords(), RentSettlementVO.class);
        voList.forEach(e -> e.setSettleType("6"));
        result.setRecords(voList);
        return CommonResponse.success((String)"\u53c2\u7167\u67e5\u8be2\u6210\u529f\uff01", (Object)result);
    }

    @GetMapping(value={"/hasNoFinishedRent"})
    @ResponseBody
    public CommonResponse<Long> hasNoFinishedRent(@RequestParam Long contractId) {
        if (contractId == null) {
            return CommonResponse.error((String)"\u53c2\u6570\u9519\u8bef\uff01");
        }
        List<RentSettlementEntity> entities = this.getHasRentd(contractId);
        if (ListUtil.isEmpty(entities)) {
            return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01");
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)entities.get(0).getId());
    }

    public List<RentSettlementEntity> getHasRentd(Long contractId) {
        QueryParam param = new QueryParam();
        param.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        param.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.UNCOMMITED_STATE.getBillStateCode(), BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode(), BillStateEnum.APPROVING_HAS_STATE.getBillStateCode())));
        return this.rentSettlementService.queryList(param, false);
    }

    @RequestMapping(value={"/querySumSettlementTaxMny"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<RentSettlementVO> querySumSettlementTaxMny(@RequestParam Long contractId, @RequestParam Long orgId) {
        BigDecimal sumOffsetMnys;
        RentSettlementVO vo = new RentSettlementVO();
        CommonResponse sumPayMnyVO = this.payContractApi.getSumPayMny(contractId, orgId);
        if (!sumPayMnyVO.isSuccess()) {
            return CommonResponse.success((String)"\u83b7\u53d6\u4ed8\u6b3e\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u5237\u65b0\u540e\u518d\u8bd5\uff01");
        }
        BigDecimal sumPayMny = ((SumPayMnyVO)sumPayMnyVO.getData()).getSumPayMny();
        BigDecimal sumPrePayMny = ((SumPayMnyVO)sumPayMnyVO.getData()).getSumPrePayMny();
        vo.setSumPayMny(sumPayMny == null ? BigDecimal.ZERO : sumPayMny);
        vo.setSumPrepayMny(sumPrePayMny == null ? BigDecimal.ZERO : sumPrePayMny);
        LambdaQueryWrapper lambdachange = Wrappers.lambdaQuery();
        lambdachange.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        lambdachange.eq(RentSettlementEntity::getContractId, (Object)contractId);
        lambdachange.eq(RentSettlementEntity::getOrgId, (Object)orgId);
        lambdachange.in(RentSettlementEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        List list = this.rentSettlementService.list((Wrapper)lambdachange);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            BigDecimal[] alreadyRentMoney = new BigDecimal[]{new BigDecimal("0.00").setScale(2, 4), new BigDecimal("0.00").setScale(2, 4), new BigDecimal("0.00").setScale(2, 4)};
            list.forEach(e -> {
                alreadyRentMoney[0] = alreadyRentMoney[0].add(e.getSettlementTaxMny() == null ? BigDecimal.ZERO : e.getSettlementTaxMny());
                alreadyRentMoney[1] = alreadyRentMoney[1].add(e.getOffsetMny() == null ? BigDecimal.ZERO : e.getOffsetMny());
                alreadyRentMoney[2] = alreadyRentMoney[0].add(e.getSettlementMny() == null ? BigDecimal.ZERO : e.getSettlementMny());
            });
            vo.setSumSettlementTaxMny(alreadyRentMoney[0]);
            vo.setSumOffsetMny(alreadyRentMoney[1]);
            vo.setSumSettlementMny(alreadyRentMoney[2]);
        }
        BigDecimal bigDecimal = sumOffsetMnys = vo.getSumOffsetMny() == null ? BigDecimal.ZERO : vo.getSumOffsetMny();
        if (vo.getSumPrepayMny().compareTo(BigDecimal.ZERO) >= 0 && sumOffsetMnys.compareTo(BigDecimal.ZERO) >= 0) {
            vo.setSymny(vo.getSumPrepayMny().subtract(sumOffsetMnys));
        }
        RentContractVO rentContractVO = this.rentContractService.queryDetail(contractId);
        vo.setStageList(rentContractVO.getRentstage());
        return CommonResponse.success((Object)vo);
    }

    @GetMapping(value={"/hasNoFinishedPurchase"})
    @ResponseBody
    public CommonResponse<Long> hasNoFinishedPurchase(@RequestParam Long contractId) {
        if (contractId == null) {
            return CommonResponse.error((String)"\u53c2\u6570\u9519\u8bef\uff01");
        }
        List<RentSettlementEntity> entities = this.getHasPurchased(contractId);
        if (ListUtil.isEmpty(entities)) {
            return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01");
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)entities.get(0).getId());
    }

    @RequestMapping(value={"/pushCost"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<RentSettlementVO> pushCost(@RequestBody RentSettlementVO rentSettlementVo) {
        return this.rentSettlementService.pushCost(rentSettlementVo);
    }

    public List<RentSettlementEntity> getHasPurchased(Long contractId) {
        QueryParam param = new QueryParam();
        param.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        param.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.UNCOMMITED_STATE.getBillStateCode(), BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode(), BillStateEnum.APPROVING_HAS_STATE.getBillStateCode())));
        return this.rentSettlementService.queryList(param, false);
    }

    @RequestMapping(value={"/checkParams"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ParamsCheckVO> checkParams(@RequestBody RentSettlementVO vo) {
        return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u6210\u529f\uff01", (Object)this.rentSettlementService.checkParams(vo.getPurchaseType(), vo.getSettlementTaxMny(), vo.getSumSettlementTaxMny(), vo.getContractTaxMny()));
    }

    @PostMapping(value={"/settleExcelDownload"})
    public void settleExcelDownload(HttpServletResponse response, @RequestBody RentSettlementVO vo) {
        HashMap<String, List<RentSettlementDetailVO>> beans = new HashMap<String, List<RentSettlementDetailVO>>();
        List<RentSettlementDetailVO> list = this.rentSettlementService.settleExcelDownload(vo);
        beans.put("records", list);
        ExcelExport.getInstance().export("rentSettlement-detail-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/downloadDescription"}, method={RequestMethod.POST})
    @ResponseBody
    public void downloadDescription(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"subject-description.xlsx", (String)"\u6210\u672c\u79d1\u76ee\u6302\u63a5\u8bf4\u660e");
    }
}

