package com.ejianc.business.rmat.controller;


import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.rmat.bean.RentContractDetailEntity;
import com.ejianc.business.rmat.service.IRentContractDetailService;
import com.ejianc.business.rmat.vo.RentContractDetailVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;

import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.Map;

/**
 * <p>
 * 设备明细 前端控制器
 * </p>
 *
 * @author yqls
 * @since 2020-06-08
 */
@RestController
@RequestMapping("rentContractDetail")
public class RentContractDetailController {
    @Autowired
    private IRentContractDetailService rentContractDetailService;

    @Autowired
    private IOrgApi orgApi;
    @GetMapping("/rentContractDetailRef")
    public  CommonResponse<IPage<RentContractDetailVO>>  projectListRefe(@RequestParam(defaultValue = "1") Integer pageNumber,
                                                                             @RequestParam(defaultValue = "10") Integer pageSize,
                                                                             @RequestParam(value = "condition", required = false) String condition,
                                                                             @RequestParam(value = "searchText", required = false) String searchText) {

        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
        queryParam.getFuzzyFields().add("spec");
        queryParam.getFuzzyFields().add("materialName");

        if(StringUtils.isNotBlank(condition)) {
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if(null != conditionMap.get("contractId")) {
                queryParam.getParams().put("contract_id",new Parameter("eq",conditionMap.get("contractId")));
                //queryParam.getParams().put("change_type",new Parameter("ne","3"));
            }
        }
        IPage<RentContractDetailEntity> pageData = rentContractDetailService.queryPage(queryParam,false);
        List<RentContractDetailVO> voList = BeanMapper.mapList(pageData.getRecords(), RentContractDetailVO.class);
        for(int i=0;i<voList.size();i++){
            RentContractDetailVO vo = voList.get(i);
            RentContractDetailEntity entityTemp=rentContractDetailService.querySumNum(vo.getId());
            vo.setSumNum(entityTemp.getSumNum());
            if(StringUtils.isNotEmpty(vo.getChangeType())){
                if(vo.getChangeType().equals("3")){
                    voList.remove(i);
                }
            }
        }
        IPage<RentContractDetailVO> data = new Page<>();
        data.setRecords(voList);
        data.setTotal(pageData.getTotal());
        data.setSize(pageData.getSize());
        data.setCurrent(pageData.getCurrent());
        data.setPages(pageData.getPages());
        return CommonResponse.success("参照查询成功！", data);
    }
}
