package com.ejianc.business.rmat.service;

import com.ejianc.business.bidprice.material.vo.MaterialPicketageVO;
import com.ejianc.business.rmat.bean.RentContractEntity;
import com.ejianc.business.rmat.controller.SqlParam;
import com.ejianc.business.rmat.vo.ParamsCheckVO;
import com.ejianc.business.rmat.vo.RentContractControlVO;
import com.ejianc.business.rmat.vo.RentContractVO;
import com.ejianc.business.rmat.vo.RmatProjectReportVo;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 设备合同表 服务类
 * </p>
 *
 * @author yqls
 * @since 2020-06-08
 */
public interface IRentContractService extends IBaseService<RentContractEntity> {
    /**
     * 保存或修改信息
     *
     * @param RentContractVo
     * @return
     */
    CommonResponse<RentContractVO> saveOrUpdate(RentContractVO RentContractVo);

    /**
     * 根据主键ID查询详情
     *
     * @param id
     * @return
     */
    RentContractVO queryDetail(Long id);

    /**
     * 删除信息
     *
     * @param
     */
    void deleteRentContract(List<RentContractVO> vos);
    /**
     　* @Description: 统计页面原合同总金额，现合同总金额
     　* @param [queryParam]
     　* @return java.util.Map<java.lang.String,java.math.BigDecimal>
     　* @throws
     　* @author CJ
     　* @date 2020/6/8 11:28
     　*/
    Map<String, Object> countContractAmount(QueryParam queryParam);

    List<Map<String, Object>> querySettleWarnContract(List<SqlParam> sqlParamList);

    List<Map<String, Object>> queryPayWarnContract(List<SqlParam> sqlParamList);

    List<Map<String, Object>> queryPrePayWarnContract(List<SqlParam> sqlParamList);

    List<Map<String, Object>> queryTaxWarnContract(List<SqlParam> sqlParamList);

    List<RmatProjectReportVo> getMonthRmatMny(Long projectId, Integer lastDay);

    RmatProjectReportVo getRmatContract(Long projectId);

    /**
     * 按项目维度，获取合同金额(含税)
     *
     * @param projectId 项目id
     *
     * @return {@link BigDecimal}
     */
    BigDecimal fetchContractTaxMny(Long projectId);

    /**
     * 参数控制
     *
     * @param vo 周转材租赁合同参数控制vo
     *
     * @return {@link ParamsCheckVO}
     */
    ParamsCheckVO checkParams(RentContractControlVO vo);

    /**
     * @description: 根据定标单溶剂已签合同数量和金额
     *
     * @param enquiryPriceBillIds
     * @return {@link MaterialPicketageVO}
     * @author songlx
     * @date: 2023/2/10
     */
    List<MaterialPicketageVO> countContractNumAndMnyByEnquiry(Long... enquiryPriceBillIds);
}
