package com.ejianc.business.rmat.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.rmat.bean.*;
import com.ejianc.business.rmat.service.*;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * <p>
 * 设备合同变更单审批操作业务类
 * </p>
 *
 * @author sunyj
 * @since 2020-06-04
 */
@Service("rentChange")
public class RentChangeBpmServiceImpl implements ICommonBusinessService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IRentContractService rentContractService;

    @Autowired
    private IRentChangeService rentChangeService;

    @Autowired
    private IRentContractClauseService rentContractClauseService;

    @Autowired
    private IRentContractFeeService rentContractFeeService;

    @Autowired
    private IRentContractStageService rentContractStageService;


    @Autowired
    private IRentRecordService rentRecordService;

    @Autowired
    private IAttachmentApi attachmentApi;


    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state,String billTypeCode) {
        logger.info("进入审批同意后回写--- billId:"+billId+"  state:"+state);
        RentChangeEntity changeEntity = rentChangeService.selectById(billId);
        //1，先复制合同表到合同历史表
        RentContractEntity contractEntity = rentContractService.selectById(changeEntity.getContractId());
        RentRecordEntity recordEntity = BeanMapper.map(contractEntity, RentRecordEntity.class);
        logger.info("进入审批同意后回写--- changeEntity:"+changeEntity+"  contractEntity:"+contractEntity);
        recordEntity.setContractId(recordEntity.getId());
        recordEntity.setId(null);
        if(CollectionUtils.isNotEmpty(recordEntity.getRentdetail())){
            recordEntity.getRentdetail().forEach(vo -> {
                vo.setContractDetailId(vo.getId());
                vo.setId(null);
            });
        }
        if(CollectionUtils.isNotEmpty(recordEntity.getRentfee())){
            recordEntity.getRentfee().forEach(vo -> {
                vo.setContractFeeId(vo.getId());
                vo.setId(null);
            });
        }
        if(CollectionUtils.isNotEmpty(recordEntity.getRentclause())){
            recordEntity.getRentclause().forEach(vo -> {
                vo.setContractClauseId(vo.getId());
                vo.setId(null);
            });
        }
        if(CollectionUtils.isNotEmpty(recordEntity.getRentstage())){
            recordEntity.getRentstage().forEach(vo -> {
                vo.setContractStageId(vo.getId());
                vo.setId(null);
            });
        }
        recordEntity.setContractUndiscountMny(contractEntity.getContractUndiscountMny());
        recordEntity.setDiscountMny(contractEntity.getDiscountMny());
        rentRecordService.saveOrUpdate(recordEntity,false);
        LambdaUpdateWrapper<RentChangeEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(RentChangeEntity::getId,changeEntity.getId());
        updateWrapper.set(RentChangeEntity::getChangeTime,new Date());
        rentChangeService.update(updateWrapper);
        logger.info("进入审批同意后回写--2");
        //2，回写合同，变更状态改为已变更，并回写字段
        contractEntity.setChangeStatus(3);
        contractEntity.setContractMny(contractEntity.getChangingMny());
        contractEntity.setContractTaxMny(contractEntity.getChangingTaxMny());
        contractEntity.setMemo(changeEntity.getMemo());
        contractEntity.setSignDate(changeEntity.getSignDate());
        contractEntity.setCustomerId(changeEntity.getCustomerId());
        contractEntity.setCustomerName(changeEntity.getCustomerName());
        contractEntity.setSupplierId(changeEntity.getSupplierId());
        contractEntity.setSupplierName(changeEntity.getSupplierName());
        contractEntity.setContractName(changeEntity.getContractName());
        contractEntity.setBillCode(changeEntity.getBillCode());
        contractEntity.setTaxRate(changeEntity.getTaxRate());
        contractEntity.setPayScale(changeEntity.getPayScale());
        contractEntity.setTaxMny(changeEntity.getTaxMny());
        contractEntity.setContractStatus(changeEntity.getContractStatus());
        contractEntity.setContractUndiscountMny(changeEntity.getContractUndiscountMny());
        contractEntity.setDiscountMny(changeEntity.getDiscountMny());

        rentContractClauseService.deleteByContractId(changeEntity.getContractId());
        rentContractFeeService.deleteByContractId(changeEntity.getContractId());
        rentContractStageService.deleteByContractId(changeEntity.getContractId());
        contractEntity.setRentclause(null);
        contractEntity.setRentfee(null);
        contractEntity.setRentstage(null);
        if(CollectionUtils.isNotEmpty(changeEntity.getRentdetail())){
            logger.info("复制子表开始--"+changeEntity.getRentdetail());
            changeEntity.getRentdetail().forEach(vo -> {
                logger.info("复制子表--"+vo.getContractDetailId()+"---type"+vo.getChangeType());
                if(null!=vo.getContractDetailId()){
                    Map<Long, Integer> map = contractEntity.getRentdetail().stream().collect(Collectors.toMap(RentContractDetailEntity::getId, RentContractDetailEntity::getVersion));
                    vo.setId(vo.getContractDetailId());
                    vo.setVersion(map.get(vo.getContractDetailId()));
                }
            });
            contractEntity.setRentdetail(BeanMapper.mapList(changeEntity.getRentdetail(),RentContractDetailEntity.class));
        }
        if(CollectionUtils.isNotEmpty(changeEntity.getRentfee())){
            changeEntity.getRentfee().forEach(vo -> {
                vo.setId(null);
            });
            contractEntity.setRentfee(BeanMapper.mapList(changeEntity.getRentfee(),RentContractFeeEntity.class));
        }
        if(CollectionUtils.isNotEmpty(changeEntity.getRentclause())){
            changeEntity.getRentclause().forEach(vo -> {
                vo.setId(null);
            });
            contractEntity.setRentclause(BeanMapper.mapList(changeEntity.getRentclause(),RentContractClauseEntity.class));
        }
        if(CollectionUtils.isNotEmpty(changeEntity.getRentstage())){
            changeEntity.getRentstage().forEach(vo -> {
                vo.setId(null);
            });
            contractEntity.setRentstage(BeanMapper.mapList(changeEntity.getRentstage(),RentContractStageEntity.class));
        }

        CommonResponse<String> response = attachmentApi.copyFilesFromSourceBillToTargetBill(
                String.valueOf(billId), "BT210615000000002", "rentContractBill",
                String.valueOf(changeEntity.getContractId()), "BT210615000000001", "rentContractBill");

        boolean flag =  rentContractService.saveOrUpdate(contractEntity,false);


        logger.info("业务逻辑完成--返回"+flag);
        if(flag){
            rentContractService.countContractNumAndMnyByEnquiry(contractEntity.getEnquiryPriceBillId());
            return CommonResponse.success();
        }else{
            return CommonResponse.error("审批回写异常!");
        }
    }

    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state,String billTypeCode) {
        return CommonResponse.error("合同变更单暂不支持回退功能!");
    }


}
