package com.ejianc.business.rmat.service.impl;

import cn.hutool.core.util.NumberUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.bidprice.material.api.ImaterialPicketageApi;
import com.ejianc.business.bidprice.material.vo.MaterialPicketageVO;
import com.ejianc.business.budget.api.IBudgetProjectProApi;
import com.ejianc.business.budget.vo.BudgetProjectProParamControlVO;
import com.ejianc.business.budget.vo.BudgetProjectProQuantityAndMnyVO;
import com.ejianc.business.budget.vo.cons.CostTypeEnum;
import com.ejianc.business.equipment.api.IEquipmentContractApi;
import com.ejianc.business.finance.api.IFinanceLoadReimburseApi;
import com.ejianc.business.finance.api.IFinancePayReimburseApi;
import com.ejianc.business.finance.api.IFinancePaySporadicApi;
import com.ejianc.business.finance.util.MathUtil;
import com.ejianc.business.income.api.IIncomeContractApi;
import com.ejianc.business.material.api.IMaterialContractApi;
import com.ejianc.business.other.api.IOtherContractApi;
import com.ejianc.business.rmat.bean.RentChangeEntity;
import com.ejianc.business.rmat.bean.RentContractDetailEntity;
import com.ejianc.business.rmat.bean.RentContractEntity;
import com.ejianc.business.rmat.bean.RentSettlementEntity;
import com.ejianc.business.rmat.controller.SqlParam;
import com.ejianc.business.rmat.mapper.RentContractMapper;
import com.ejianc.business.rmat.service.IRentChangeService;
import com.ejianc.business.rmat.service.IRentContractDetailService;
import com.ejianc.business.rmat.service.IRentContractService;
import com.ejianc.business.rmat.service.IRentSettlementService;
import com.ejianc.business.rmat.vo.*;
import com.ejianc.business.sub.api.ISubContractApi;
import com.ejianc.business.utils.ComputeUtil;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * <p>
 * 设备合同表 服务实现类
 * </p>
 *
 * @author yqls
 * @since 2020-06-08
 */
@Service("RentContractService")
public class RentContractServiceImpl extends BaseServiceImpl<RentContractMapper, RentContractEntity> implements IRentContractService {

    private static final String RENT_CONTRACT_BILL_CODE = "RMAT_CONTRACT";
    private static final String PARAM_TOTAL_MNY = "P-t58ih142"; // 【预算材料费总金额】 控 【物资合同总金额】
    private static final String SGHTZJE_K_SJZCJE = "P-nkX4Sk61";
    @Autowired
    private IIncomeContractApi incomeContractApi;
    @Autowired
    private ISubContractApi subContractApi;
    @Autowired
    private IEquipmentContractApi equipmentContractApi;
    @Autowired
    private IOtherContractApi otherContractApi;
    @Autowired
    private IFinancePayReimburseApi financePayReimburseApi;
    @Autowired
    private IFinancePaySporadicApi financePaySporadicApi;
    @Autowired
    private IFinanceLoadReimburseApi financeLoadReimburseApi;

    @Autowired
    private IRentChangeService rentChangeService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IRentContractDetailService rentContractDetailService;

    @Autowired
    private IRentSettlementService settlementService;
    @Autowired
    private IBudgetProjectProApi budgetProjectProApi;
    @Autowired
    private IMaterialContractApi materialContractApi;
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private RentContractMapper rentContractMapper;

    @Autowired
    private ImaterialPicketageApi materialPicketageApi;



    @Override
    public CommonResponse<RentContractVO> saveOrUpdate(RentContractVO rentContractVo) {
        if (rentContractVo.getContractTaxMny() == null) {
            rentContractVo.setContractTaxMny(BigDecimal.ZERO);
        }
        Long tenantId = InvocationInfoProxy.getTenantid();
        RentContractEntity entity = BeanMapper.map(rentContractVo, RentContractEntity.class);

        List<RentContractEntity> entities = null;
        List<RentChangeEntity> entitiesc = null;
        if (StringUtils.isEmpty(rentContractVo.getBillCode())) {
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(RENT_CONTRACT_BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        if(StringUtils.isEmpty(rentContractVo.getIsSupplement())) {
        	entity.setIsSupplement("0");
        }
        }
        if (rentContractVo.getId() != null && rentContractVo.getId() > 0) {
            //修改  校验合同编号是否重复   需校验合同表和变更表(状态为变更中)同时唯一
            LambdaQueryWrapper<RentContractEntity> lambda = Wrappers.<RentContractEntity>lambdaQuery();
            lambda.eq(RentContractEntity::getSupplementFlag, 0);
            lambda.eq(RentContractEntity::getBillCode, rentContractVo.getBillCode());
            lambda.eq(RentContractEntity::getTenantId, tenantId);
            lambda.ne(RentContractEntity::getId, rentContractVo.getId());
            entities = super.list(lambda);

            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ, tenantId));
            queryParam.getParams().put("supplement_flag",new Parameter("eq",0));//过滤补合同充协议
            queryParam.getParams().put("bill_code", new Parameter(QueryParam.EQ, rentContractVo.getBillCode()));
            queryParam.getParams().put("contract_id", new Parameter(QueryParam.NE, rentContractVo.getId()));
            entitiesc = rentChangeService.queryList(queryParam, false);
        } else {
            //校验合同编号是否重复
            LambdaQueryWrapper<RentContractEntity> lambda = Wrappers.<RentContractEntity>lambdaQuery();
            lambda.eq(RentContractEntity::getTenantId, tenantId);
            lambda.eq(RentContractEntity::getSupplementFlag, 0);
            lambda.eq(RentContractEntity::getBillCode, rentContractVo.getBillCode());
            entities = super.list(lambda);

            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ, tenantId));
            queryParam.getParams().put("supplement_flag",new Parameter("eq",0));//过滤补合同充协议
            queryParam.getParams().put("bill_code", new Parameter(QueryParam.EQ, rentContractVo.getBillCode()));
            entitiesc = rentChangeService.queryList(queryParam, false);
            entity.setChangeVersion(0);
            entity.setChangeStatus(1);
        }
        if (CollectionUtils.isNotEmpty(entities) || CollectionUtils.isNotEmpty(entitiesc)) {
            return CommonResponse.error("存在相同编码，不允许保存!");
        }
        entity.setBaseMoney(rentContractVo.getContractMny() == null ? BigDecimal.ZERO : rentContractVo.getContractMny());
        entity.setBaseTaxMoney(rentContractVo.getContractTaxMny() == null ? BigDecimal.ZERO : rentContractVo.getContractTaxMny());
        entity.setBeforeChangeMny(rentContractVo.getContractMny() == null ? BigDecimal.ZERO : rentContractVo.getContractMny());
        entity.setBeforeChangeTaxMny(rentContractVo.getContractTaxMny() == null ? BigDecimal.ZERO : rentContractVo.getContractTaxMny());
        boolean b = super.saveOrUpdate(entity, false);
        if(b){
            this.countContractNumAndMnyByEnquiry(entity.getEnquiryPriceBillId());
        }

        return CommonResponse.success(BeanMapper.map(entity, RentContractVO.class));
    }

    @Override
    public RentContractVO queryDetail(Long id) {
        RentContractEntity entity = super.selectById(id);
        entity.setRentdetail(null);
        RentContractVO rentContractVo = BeanMapper.map(entity, RentContractVO.class);
        List<RentContractDetailEntity> details = null;
        LambdaQueryWrapper<RentContractDetailEntity> lambda = Wrappers.<RentContractDetailEntity>lambdaQuery();
        lambda.eq(RentContractDetailEntity::getContractId, id);
        lambda.apply("IFNULL(change_type,0) <> 3");
        details = rentContractDetailService.list(lambda);
        if (CollectionUtils.isNotEmpty(details)) {
            rentContractVo.setRentdetail(BeanMapper.mapList(details, RentContractDetailVO.class));
        }
        return rentContractVo;
    }

    @Override
    public Map<String, Object> countContractAmount(QueryParam queryParam) {
        Map<String, Object> resp = new HashMap<>();
        QueryWrapper wrapper = changeToQueryWrapper(queryParam);
        wrapper.select("sum(base_tax_money) as originalAmount, sum(contract_tax_mny) as curAmount");
        resp = super.getMap(wrapper);
//
        return resp;
    }

    @Override
    public void deleteRentContract(List<RentContractVO> vos) {
        List<Long> ids = vos.stream().map(RentContractVO::getId).collect(Collectors.toList());

        //删除前先获取到根据定标单新增的
        LambdaQueryWrapper<RentContractEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.in(RentContractEntity::getId, ids);
        queryWrapper.isNotNull(RentContractEntity::getEnquiryPriceBillId);
        List<RentContractEntity> rentContractEntities = this.list(queryWrapper);

        boolean b = super.removeByIds(ids, false);

        if(b && CollectionUtils.isNotEmpty(rentContractEntities)){
            List<Long> enquiryPriceBillIds = rentContractEntities.stream().map(RentContractEntity::getEnquiryPriceBillId).collect(Collectors.toList());
            this.countContractNumAndMnyByEnquiry(enquiryPriceBillIds.toArray(new Long[enquiryPriceBillIds.size()]));
        }
    }

    @Override
    public List<Map<String, Object>> querySettleWarnContract(List<SqlParam> sqlParamList) {
        return baseMapper.querySettleWarnContract(sqlParamList);
    }
    @Override
    public List<Map<String, Object>> queryPayWarnContract(List<SqlParam> sqlParamList) {
        return baseMapper.queryPayWarnContract(sqlParamList);
    }
    @Override
    public List<Map<String, Object>> queryPrePayWarnContract(List<SqlParam> sqlParamList) {
        return baseMapper.queryPrePayWarnContract(sqlParamList);
    }
    @Override
    public List<Map<String, Object>> queryTaxWarnContract(List<SqlParam> sqlParamList) {
        return baseMapper.queryTaxWarnContract(sqlParamList);
    }

    @Override
    public List<RmatProjectReportVo> getMonthRmatMny(Long projectId, Integer lastDay) {
        return baseMapper.getMonthRmatMny(projectId, lastDay);
    }

    @Override
    public RmatProjectReportVo getRmatContract(Long projectId) {
        BigDecimal mny = BigDecimal.ZERO;
        BigDecimal settleMny = BigDecimal.ZERO;
        List<Integer> billStatus = new ArrayList<>();
        billStatus.add(1);
        billStatus.add(3);
        LambdaQueryWrapper<RentContractEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(RentContractEntity::getProjectId, projectId);
        wrapper.eq(RentContractEntity::getDr, 0);
        wrapper.eq(RentContractEntity::getSupplementFlag, 0);
        wrapper.in(RentContractEntity::getBillState, billStatus);
        List<RentContractEntity> contractEntityList = super.list(wrapper);
        for (RentContractEntity entity : contractEntityList) {
            mny = MathUtil.safeAdd(mny, entity.getContractTaxMny());
        }
        LambdaQueryWrapper<RentSettlementEntity> wrapper2 = new LambdaQueryWrapper<>();
        wrapper2.eq(RentSettlementEntity::getProjectId, projectId);
        wrapper2.eq(RentSettlementEntity::getDr, 0);
        wrapper2.in(RentSettlementEntity::getBillState, billStatus);
        List<RentSettlementEntity> settlementEntityList = settlementService.list(wrapper2);
        for (RentSettlementEntity entity : settlementEntityList) {
            settleMny = MathUtil.safeAdd(settleMny, entity.getSettlementTaxMny());
        }
        RmatProjectReportVo vo = new RmatProjectReportVo();
        vo.setMny(mny);
        vo.setNum(contractEntityList.size());
        vo.setSettleMny(settleMny);

        return vo;
    }


    /**
     * 按项目维度，获取合同金额(含税)
     *
     * @param projectId 项目id
     *
     * @return {@link BigDecimal}
     */
    @Override
    public BigDecimal fetchContractTaxMny(Long projectId) {
        // 历史累计周转材租赁合同总金额(含变更中，有变更中取变更中的)
        return rentContractMapper.sumLastTotalContractTaxMny(projectId, null);
    }


    /**
     * 更新参数控制结果
     *
     * @param paramsArray      参数数组
     * @param paramsCheckVOMap 预警结果map
     * @param billParamVO      控制参数
     * @param paramsCheckDsVO  预警信息
     */
    private static void updateParamsCheckVOMap(String[] paramsArray, Map<String, List<ParamsCheckDsVO>> paramsCheckVOMap, BillParamVO billParamVO, ParamsCheckDsVO paramsCheckDsVO) {
        if ("alert".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> alert = paramsCheckVOMap.get("alert");
            alert.add(paramsCheckDsVO);
        }
        if ("warn".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> warn = paramsCheckVOMap.get("warn");
            warn.add(paramsCheckDsVO);
        }
    }

    /**
     * 参数控制
     *
     * @param vo 周转材租赁合同参数控制vo
     *
     * @return {@link ParamsCheckVO}
     */
    @Override
    public ParamsCheckVO checkParams(RentContractControlVO vo) {
        if (vo.getContractTaxMny() == null) {
            vo.setContractTaxMny(BigDecimal.ZERO);
        }
        String[] paramsArray = {"none", "warn", "alert"};

        // 存放预警结果
        Map<String, List<ParamsCheckDsVO>> paramsCheckVOMap = new HashMap<>();
        paramsCheckVOMap.put("alert", new ArrayList<>());
        paramsCheckVOMap.put("warn", new ArrayList<>());

        // 预算材料费总金额
        BudgetProjectProParamControlVO paramControlVO = new BudgetProjectProParamControlVO();
        paramControlVO.setProjectId(vo.getProjectId());
        paramControlVO.setCostType(CostTypeEnum.MATERIAL_COST_TYPE.getType());
        CommonResponse<BudgetProjectProQuantityAndMnyVO> res = budgetProjectProApi.fetchQuantityAndMny(paramControlVO);
        if (!res.isSuccess()) {
            throw new BusinessException("预算材料费总金额，查询项目预算信息失败，失败原因：" + res.getMsg());
        }
        // 没有预算不控制，预算不包含不控制
        if (null != res.getData()) {
            // 预算总金额
            BudgetProjectProQuantityAndMnyVO quantityAndMnyVO = res.getData();

            // 【预算材料费总金额】 控 【物资合同总金额】
            CommonResponse<List<BillParamVO>> response = paramConfigApi.getBillParamByCodeAndOrgId(PARAM_TOTAL_MNY, InvocationInfoProxy.getOrgId());
            if (!response.isSuccess()) {
                throw new BusinessException("【预算材料费总金额】 控 【物资总计划金额】，获取控制参数失败，失败原因：" + response.getMsg());
            }
            List<BillParamVO> billParamVOS = response.getData();

            if (CollectionUtils.isNotEmpty(billParamVOS)) {
                for (BillParamVO billParamVO : billParamVOS) {
                    if (0 != billParamVO.getControlType()) {
                        BigDecimal roleValue = billParamVO.getRoleValue();
                        BigDecimal scale = roleValue.divide(new BigDecimal("100"));
                        BigDecimal budgetTaxMnyResult = quantityAndMnyVO.getMaterialTaxMny().multiply(scale);

                        // 历史累计物资采购合同总金额(含变更中，有变更中取变更中的)
                        BigDecimal lastTotalContractTaxMny = rentContractMapper.sumLastTotalContractTaxMny(vo.getProjectId(), vo.getContractId());

                        // 本期周转材租赁合同总金额
                        BigDecimal currentContractTaxMny = vo.getContractTaxMny();
                        // 周转材租赁合同总金额 = 历史累计周转材租赁合同总金额 + 本期周转材租赁合同总金额
                        BigDecimal am = lastTotalContractTaxMny.add(currentContractTaxMny);

                        // 物资采购合同按照项目维度，获取总金额
                        CommonResponse<BigDecimal> response1 = materialContractApi.fetchAmountWithTax(vo.getProjectId());
                        if (!response1.isSuccess()) {
                            throw new BusinessException("物资采购合同按照项目维度，合同总金额获取失败，失败原因：" + response.getMsg());
                        }

                        BigDecimal contractTaxMny = response1.getData().add(am);

                        // 周转材租赁合同总金额 和 预算材料费总金额比较
                        if (contractTaxMny.compareTo(budgetTaxMnyResult) > 0) {

                            // 超出金额 = 周转材租赁合同总金额 - 预算材料费总金额 * X%
                            BigDecimal over = contractTaxMny.subtract(budgetTaxMnyResult);

                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                            paramsCheckDsVO.setWarnItem("物资采购合同总金额超预算材料费总金额");
                            paramsCheckDsVO.setWarnName("物资采购合同总金额大于预算材料费总金额 * " + roleValue + "%");

                            // 物资采购合同总金额：XX元，预算材料费总金额 * X%：XX元，超出金额：XX元。
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("该项目物资采购合同总金额：")
                                    .append(contractTaxMny.setScale(2, RoundingMode.HALF_UP))
                                    .append("元，预算材料费总金额 * ")
                                    .append(roleValue).append("%：")
                                    .append(budgetTaxMnyResult.setScale(2, RoundingMode.HALF_UP))
                                    .append("元，超出金额：")
                                    .append(over.setScale(2, RoundingMode.HALF_UP))
                                    .append("元。");
                            paramsCheckDsVO.setContent(stringBuffer.toString());

                            updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                        }
                    }
                }
            }
        }


        // 施工合同金额控制支出
        CommonResponse<List<BillParamVO>> sghtkzc = paramConfigApi.getBillParamByCodeAndOrgId(SGHTZJE_K_SJZCJE, InvocationInfoProxy.getOrgId());
        if (sghtkzc.isSuccess() && null != sghtkzc.getData()) {
            List<BillParamVO> billParamVOS = sghtkzc.getData();
            if (CollectionUtils.isNotEmpty(billParamVOS)) {
                BigDecimal sjzcje = this.getSjzcje(vo.getContractId(), vo.getProjectId(), vo.getContractTaxMny());
                CommonResponse<BigDecimal> res996 = incomeContractApi.fetchSghtzje(vo.getProjectId());
                if (!res996.isSuccess()) {
                    throw new BusinessException("获取施工合同工总金额失败");
                }
                BigDecimal sght = res996.getData();
                for (BillParamVO billParamVO : billParamVOS) {
                    if (0 != billParamVO.getControlType()) {
                        BigDecimal roleValue = billParamVO.getRoleValue();
                        BigDecimal scale = NumberUtil.div(roleValue, new BigDecimal("100"), 8);
                        BigDecimal sghtzje = NumberUtil.mul(sght, scale);
                        if (sjzcje.compareTo(sghtzje) > 0) {
//                            controlType = billParamVO.getControlType() > controlType ? billParamVO.getControlType() : controlType;
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("该项目实际支出总金额：")
                                    .append(sjzcje.setScale(2, RoundingMode.HALF_UP))
                                    .append("，施工合同工总金额*")
                                    .append(roleValue)
                                    .append("%：")
                                    .append(sghtzje.setScale(2, RoundingMode.HALF_UP))
                                    .append("，超出金额：")
                                    .append(com.ejianc.framework.core.util.ComputeUtil.safeSub(sjzcje, sghtzje).setScale(2, RoundingMode.HALF_UP));
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                            paramsCheckDsVO.setWarnItem("实际支出总金额超施工合同总金额");
                            paramsCheckDsVO.setWarnName("实际支出总金额大于施工合同总金额");
                            paramsCheckDsVO.setContent(stringBuffer.toString());
//                            checkDsVOS.add(paramsCheckDsVO);
                            updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                        }
                    }
                }
            }
        }

        ParamsCheckVO pc = new ParamsCheckVO();
        if (CollectionUtils.isNotEmpty(paramsCheckVOMap.get("alert"))) {
            pc.setWarnType("alert");
            pc.setDataSource(paramsCheckVOMap.get("alert"));
        } else if (CollectionUtils.isNotEmpty(paramsCheckVOMap.get("warn"))) {
            pc.setWarnType("warn");
            pc.setDataSource(paramsCheckVOMap.get("warn"));
        } else {
            pc.setWarnType("none");
            pc.setDataSource(null);
        }
        return pc;
    }


    private BigDecimal getSjzcje(Long contractId, Long projectId, BigDecimal mny) {
        CommonResponse<BigDecimal> fbCommonResponse = subContractApi.fetchSjzcje(projectId);
        if (!fbCommonResponse.isSuccess()) {
            throw new BusinessException("获取" + "分包" + "实际支出金额失败");
        }
        BigDecimal fb = fbCommonResponse.getData();
        CommonResponse<BigDecimal> wzCommonResponse = materialContractApi.fetchSjzcje(projectId);
        if (!wzCommonResponse.isSuccess()) {
            throw new BusinessException("获取" + "物资" + "实际支出金额失败");
        }
        BigDecimal wz = wzCommonResponse.getData();
        BigDecimal zzc = baseMapper.fetchSjzcje(projectId, contractId);
        CommonResponse<BigDecimal> sbcgCommonResponse = equipmentContractApi.fetchSjzcjePurchase(projectId);
        if (!sbcgCommonResponse.isSuccess()) {
            throw new BusinessException("获取" + "设备采购" + "实际支出金额失败");
        }
        BigDecimal sbcg = sbcgCommonResponse.getData();
        CommonResponse<BigDecimal> sbzlCommonResponse = equipmentContractApi.fetchSjzcjeRent(projectId);
        if (!sbzlCommonResponse.isSuccess()) {
            throw new BusinessException("获取" + "设备租赁" + "实际支出金额失败");
        }
        BigDecimal sbzl = sbzlCommonResponse.getData();
        CommonResponse<BigDecimal> qtCommonResponse = otherContractApi.fetchSjzcje(projectId);
        if (!qtCommonResponse.isSuccess()) {
            throw new BusinessException("获取" + "其他" + "实际支出金额失败");
        }
        BigDecimal qt = qtCommonResponse.getData();
        CommonResponse<BigDecimal> fybxCommonResponse = financePayReimburseApi.fetchSjzcje(projectId);
        if (!fybxCommonResponse.isSuccess()) {
            throw new BusinessException("获取" + "费用报销" + "实际支出金额失败");
        }
        BigDecimal fybx = fybxCommonResponse.getData();
        CommonResponse<BigDecimal> lxCommonResponse = financePaySporadicApi.fetchSjzcje(projectId);
        if (!lxCommonResponse.isSuccess()) {
            throw new BusinessException("获取" + "零星" + "实际支出金额失败");
        }
        BigDecimal lx = lxCommonResponse.getData();
        CommonResponse<BigDecimal> yjCommonResponse = financeLoadReimburseApi.fetchSjzcje(projectId);
        if (!yjCommonResponse.isSuccess()) {
            throw new BusinessException("获取" + "备用金" + "实际支出金额失败");
        }
        BigDecimal yj = yjCommonResponse.getData();
        return NumberUtil.add(mny, fb, wz, zzc, sbcg, sbzl, qt, fybx, lx, yj);
    }

    /**
     * @param enquiryPriceBillIds
     *
     * @return {@link MaterialPicketageVO}
     *
     * @description: 根据定标单溶剂已签合同数量和金额
     * @author songlx
     * @date: 2023/2/10
     */
    @Override
    public List<MaterialPicketageVO> countContractNumAndMnyByEnquiry(Long... enquiryPriceBillIds) {
        if(enquiryPriceBillIds != null) {
            for (Long enquiryPriceBillId : enquiryPriceBillIds) {
                QueryWrapper<RentContractEntity> queryWrapper = new QueryWrapper<>();
                queryWrapper.select("count(1) as num, IFNULL(sum(contract_tax_mny),0) as money")
                        .eq("enquiry_price_bill_id", enquiryPriceBillId);
                Map<String, Object> map = this.getMap(queryWrapper);
                MaterialPicketageVO materialPicketageVO = new MaterialPicketageVO();
                if(MapUtils.isNotEmpty(map)){
                    Integer num = map.get("num") != null ?  Integer.valueOf(map.get("num").toString()) : 0;
                    BigDecimal money = ComputeUtil.toBigDecimal(map.get("money"));
                    materialPicketageVO.setId(enquiryPriceBillId);
                    materialPicketageVO.setContractSign(num);
                    materialPicketageVO.setContractSignMny(money);
                } else {
                    materialPicketageVO.setId(enquiryPriceBillId);
                    materialPicketageVO.setContractSign(0);
                    materialPicketageVO.setContractSignMny(BigDecimal.ZERO);
                }
                materialPicketageApi.updateContractSignMny(materialPicketageVO);
            }
        }
        return null;
    }


    @Override
    public BigDecimal fetchSjzcje(Long projectId) {
        Assert.notNull(projectId, "项目id不能为空");
        return baseMapper.fetchSjzcje(projectId, null);
    }
}
