package com.ejianc.business.salary.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;


/**
 * 个税计算-个税调整
 * 
 * @author generator
 * 
 */
public class TaxModifyVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long taxHoldOrgId; // 个税承担单位id
    private String taxHoldOrgName; // 个税承担单位名称
    private String taxHoldOrgCode; // 个税承担单位编码
    private BigDecimal taxMny; // 个税金额
    private String acSetCode; // 账套编码
    private String acSet; // 账套名称
    private Long taxBillId; // 个税计算主单据id
    private Long taxBillDetailId; // 个税计算子表id

    @ReferSerialTransfer(referCode="idm-org")
    public Long getTaxHoldOrgId() {
        return taxHoldOrgId;
    }

    @ReferDeserialTransfer
    public void setTaxHoldOrgId(Long taxHoldOrgId) {
        this.taxHoldOrgId = taxHoldOrgId;
    }
    public String getTaxHoldOrgName() {
        return taxHoldOrgName;
    }

    public void setTaxHoldOrgName(String taxHoldOrgName) {
        this.taxHoldOrgName = taxHoldOrgName;
    }
    public String getTaxHoldOrgCode() {
        return taxHoldOrgCode;
    }

    public void setTaxHoldOrgCode(String taxHoldOrgCode) {
        this.taxHoldOrgCode = taxHoldOrgCode;
    }
    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }
    public String getAcSetCode() {
        return acSetCode;
    }

    public void setAcSetCode(String acSetCode) {
        this.acSetCode = acSetCode;
    }
    public String getAcSet() {
        return acSet;
    }

    public void setAcSet(String acSet) {
        this.acSet = acSet;
    }
    public Long getTaxBillId() {
        return taxBillId;
    }

    public void setTaxBillId(Long taxBillId) {
        this.taxBillId = taxBillId;
    }
    public Long getTaxBillDetailId() {
        return taxBillDetailId;
    }

    public void setTaxBillDetailId(Long taxBillDetailId) {
        this.taxBillDetailId = taxBillDetailId;
    }
    
}
