package com.ejianc.business.salary.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.salary.vo.PayableDetailVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 应发工资上传
 * 
 * @author generator
 * 
 */
public class PayableVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    private Long orgId; // 组织id
    private String orgName; // 组织
    private String orgCode; // 组织编码
    @JsonFormat(pattern = "yyyy-MM",timezone = "GMT+8")
    private Date month; // 月份
    private String acSet; // 账套
    private String acSetCode; // 账套编码
    private BigDecimal payableSumMny; // 应发工资汇总
    private BigDecimal orgSumMny; // 本单位累计金额
    private String billCode; // 单据编号
    private Integer billState; // 单据状态（审批必须字段）
    private Integer collectStatus; // 汇总状态（0-未汇总，1--已汇总,2-被驳回）
    private List<PayableDetailVO> payableDetailList = new ArrayList<>(); // 应发工资上传明细
    private String billStateName;
    private String collectStatusName;

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public String getCollectStatusName() {
        return collectStatusName;
    }

    public void setCollectStatusName(String collectStatusName) {
        this.collectStatusName = collectStatusName;
    }

    public Integer getCollectStatus() {
        return collectStatus;
    }

    public void setCollectStatus(Integer collectStatus) {
        this.collectStatus = collectStatus;
    }

    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public Date getMonth() {
        return month;
    }

    public void setMonth(Date month) {
        this.month = month;
    }

    public String getAcSet() {
        return acSet;
    }

    public void setAcSet(String acSet) {
        this.acSet = acSet;
    }
    public String getAcSetCode() {
        return acSetCode;
    }

    public void setAcSetCode(String acSetCode) {
        this.acSetCode = acSetCode;
    }
    public BigDecimal getPayableSumMny() {
        return payableSumMny;
    }

    public void setPayableSumMny(BigDecimal payableSumMny) {
        this.payableSumMny = payableSumMny;
    }
    public BigDecimal getOrgSumMny() {
        return orgSumMny;
    }

    public void setOrgSumMny(BigDecimal orgSumMny) {
        this.orgSumMny = orgSumMny;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    
     public List<PayableDetailVO> getPayableDetailList() {
        return payableDetailList;
     }

     public void setPayableDetailList(List<PayableDetailVO> payableDetailList) {
        this.payableDetailList = payableDetailList;
     }
}
