package com.ejianc.business.salary.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.salary.vo.TaxDetailVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 个税计算-主实体
 * 
 * @author generator
 * 
 */
public class TaxVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    private BigDecimal sumTaxMny; // 个税金额汇总
    private String billCode; // 单据编号
    private Integer billState; // 单据状态（审批必须字段）
    @JsonFormat(pattern = "yyyy-MM",timezone = "GMT+8")
    private Date month; // 月份
    private Long yfgzjsBillId; // 应发工资计算单据id
    private String yfgzjsBillCode; // 应发工资计算单据编码

    private String billStateName;

    private List<String> sbjnOrgNameList; // 社保缴纳单位集合
    private List<TaxDetailVO> detailList = new ArrayList<>(); // 个税计算-人员明细

    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public BigDecimal getSumTaxMny() {
        return sumTaxMny;
    }

    public void setSumTaxMny(BigDecimal sumTaxMny) {
        this.sumTaxMny = sumTaxMny;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Date getMonth() {
        return month;
    }

    public void setMonth(Date month) {
        this.month = month;
    }

    public Long getYfgzjsBillId() {
        return yfgzjsBillId;
    }

    public void setYfgzjsBillId(Long yfgzjsBillId) {
        this.yfgzjsBillId = yfgzjsBillId;
    }

    public String getYfgzjsBillCode() {
        return yfgzjsBillCode;
    }

    public void setYfgzjsBillCode(String yfgzjsBillCode) {
        this.yfgzjsBillCode = yfgzjsBillCode;
    }

    public List<TaxDetailVO> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<TaxDetailVO> detailList) {
        this.detailList = detailList;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public List<String> getSbjnOrgNameList() {
        return sbjnOrgNameList;
    }

    public void setSbjnOrgNameList(List<String> sbjnOrgNameList) {
        this.sbjnOrgNameList = sbjnOrgNameList;
    }
}
