package com.ejianc.business.salary.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.salary.vo.PayableDetailVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 应发工资上传
 * 
 * @author generator
 * 
 */
public class PayableVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    private Long orgId; // 组织id
    private String orgName; // 组织
    private String orgCode; // 组织编码
    @JsonFormat(pattern = "yyyy-MM",timezone = "GMT+8")
    private Date month; // 月份
    private String acSet; // 账套
    private String acSetCode; // 账套编码
    private BigDecimal payableSumMny; // 应发工资汇总
    private BigDecimal orgSumMny; // 本单位累计金额
    private String billCode; // 单据编号
    private Integer billState; // 单据状态（审批必须字段）
    private Integer collectStatus; // 汇总状态（0-未汇总，1--已汇总,2-被驳回）
    private List<PayableDetailVO> payableDetailList = new ArrayList<>(); // 应发工资上传明细
    private String billStateName;
    private String collectStatusName;

    private Long corpId; // 组织id
    private String corpName; // 组织
    private String corpCode; // 组织编码
    private String payableName; // 工资单名称
    //查询组织金额
    private Integer orgBillNum; // 本单位本月已制单数量
    private BigDecimal orgBillRegisterMny; // 本单位本月已登记金额
    private BigDecimal orgBillApprovalMny; // 本单位本月已审核通过金额
    private BigDecimal lastMonthMny; // 上月合计金额
    private BigDecimal difMonthMny; // 本月已制单金额对比波动
    private Integer salaryPersonNum; // 发薪人数：（取本下组织所有本月单据的子表去重人员数量）
    private Integer allSalaryPersonNum; // 发薪人数：（取本下组织所有本月单据的子表去重人员数量） + 本次发薪人数
    private Integer orgPersonNum; // 本组织总人数：（取本下组织所有人数）
    private BigDecimal orgAllBillRegisterMny; // 本单位本月已登记金额 + 本次登记金额

    private Long parentOrgId; // 上级组织Id
    private String parentOrgName; // 上级组织名称
    private String parentOrgCode; // 上级组织编码
    private Integer payableType; // 工资单类型（1正常上传2自动生成3无社保公积金）


    public Integer getPayableType() {
        return payableType;
    }

    public void setPayableType(Integer payableType) {
        this.payableType = payableType;
    }
    public Integer getAllSalaryPersonNum() {
        return allSalaryPersonNum;
    }

    public void setAllSalaryPersonNum(Integer allSalaryPersonNum) {
        this.allSalaryPersonNum = allSalaryPersonNum;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public Integer getSalaryPersonNum() {
        return salaryPersonNum;
    }

    public void setSalaryPersonNum(Integer salaryPersonNum) {
        this.salaryPersonNum = salaryPersonNum;
    }

    public Integer getOrgPersonNum() {
        return orgPersonNum;
    }

    public void setOrgPersonNum(Integer orgPersonNum) {
        this.orgPersonNum = orgPersonNum;
    }

    public BigDecimal getOrgAllBillRegisterMny() {
        return orgAllBillRegisterMny;
    }

    public void setOrgAllBillRegisterMny(BigDecimal orgAllBillRegisterMny) {
        this.orgAllBillRegisterMny = orgAllBillRegisterMny;
    }

    public Integer getOrgBillNum() {
        return orgBillNum;
    }

    public void setOrgBillNum(Integer orgBillNum) {
        this.orgBillNum = orgBillNum;
    }

    public BigDecimal getOrgBillRegisterMny() {
        return orgBillRegisterMny;
    }

    public void setOrgBillRegisterMny(BigDecimal orgBillRegisterMny) {
        this.orgBillRegisterMny = orgBillRegisterMny;
    }

    public BigDecimal getOrgBillApprovalMny() {
        return orgBillApprovalMny;
    }

    public void setOrgBillApprovalMny(BigDecimal orgBillApprovalMny) {
        this.orgBillApprovalMny = orgBillApprovalMny;
    }

    public BigDecimal getLastMonthMny() {
        return lastMonthMny;
    }

    public void setLastMonthMny(BigDecimal lastMonthMny) {
        this.lastMonthMny = lastMonthMny;
    }

    public BigDecimal getDifMonthMny() {
        return difMonthMny;
    }

    public void setDifMonthMny(BigDecimal difMonthMny) {
        this.difMonthMny = difMonthMny;
    }

    public Long getCorpId() {
        return corpId;
    }
    public void setCorpId(Long corpId) {
        this.corpId = corpId;
    }

    public String getCorpName() {
        return corpName;
    }

    public void setCorpName(String corpName) {
        this.corpName = corpName;
    }

    public String getCorpCode() {
        return corpCode;
    }

    public void setCorpCode(String corpCode) {
        this.corpCode = corpCode;
    }

    public String getPayableName() {
        return payableName;
    }

    public void setPayableName(String payableName) {
        this.payableName = payableName;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public String getCollectStatusName() {
        return collectStatusName;
    }

    public void setCollectStatusName(String collectStatusName) {
        this.collectStatusName = collectStatusName;
    }

    public Integer getCollectStatus() {
        return collectStatus;
    }

    public void setCollectStatus(Integer collectStatus) {
        this.collectStatus = collectStatus;
    }

    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public Date getMonth() {
        return month;
    }

    public void setMonth(Date month) {
        this.month = month;
    }

    public String getAcSet() {
        return acSet;
    }

    public void setAcSet(String acSet) {
        this.acSet = acSet;
    }
    public String getAcSetCode() {
        return acSetCode;
    }

    public void setAcSetCode(String acSetCode) {
        this.acSetCode = acSetCode;
    }
    public BigDecimal getPayableSumMny() {
        return payableSumMny;
    }

    public void setPayableSumMny(BigDecimal payableSumMny) {
        this.payableSumMny = payableSumMny;
    }
    public BigDecimal getOrgSumMny() {
        return orgSumMny;
    }

    public void setOrgSumMny(BigDecimal orgSumMny) {
        this.orgSumMny = orgSumMny;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    
     public List<PayableDetailVO> getPayableDetailList() {
        return payableDetailList;
     }

     public void setPayableDetailList(List<PayableDetailVO> payableDetailList) {
        this.payableDetailList = payableDetailList;
     }
}
