package com.ejianc.business.salary.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.salary.vo.SocialSecurityChangeSdetailVO;
import com.ejianc.business.salary.vo.SocialSecurityChangeAdetailVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 社保公积金调整
 * 
 * @author generator
 * 
 */
public class SocialSecurityChangeVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String createUserName; // 编制人
    private String updateUserName; // 修改者
    private String billCode; // 单据编号
    private Integer billState; // 单据状态（审批必须字段）
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date billDate; // 经办日期
    private List<SocialSecurityChangeSdetailVO> socialSecurityChangeSdetailList = new ArrayList<>(); // 社保公积金调整-社保明细
    private List<SocialSecurityChangeAdetailVO> socialSecurityChangeAdetailList = new ArrayList<>(); // 社保公积金调整-公积金明细
    private Long orgId; // 单位id
    private String orgName; // 单位名称
    private String remark; // 变更备注
    private Long companyId; // 汇总单所属公司id
    private String companyName; // 汇总单所属公司
    private Long companyOrgId; // 汇总单所属公司id

    @ReferSerialTransfer(referCode="refCompanyData")
    public Long getCompanyId() {
        return companyId;
    }
    @ReferDeserialTransfer
    public void setCompanyId(Long companyId) {
        this.companyId = companyId;
    }

    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public Long getCompanyOrgId() {
        return companyOrgId;
    }

    public void setCompanyOrgId(Long companyOrgId) {
        this.companyOrgId = companyOrgId;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Date getBillDate() {
        return billDate;
    }

    public void setBillDate(Date billDate) {
        this.billDate = billDate;
    }

    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    @ReferSerialTransfer(referCode="idm-user")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    
     public List<SocialSecurityChangeSdetailVO> getSocialSecurityChangeSdetailList() {
        return socialSecurityChangeSdetailList;
     }

     public void setSocialSecurityChangeSdetailList(List<SocialSecurityChangeSdetailVO> socialSecurityChangeSdetailList) {
        this.socialSecurityChangeSdetailList = socialSecurityChangeSdetailList;
     }
     public List<SocialSecurityChangeAdetailVO> getSocialSecurityChangeAdetailList() {
        return socialSecurityChangeAdetailList;
     }

     public void setSocialSecurityChangeAdetailList(List<SocialSecurityChangeAdetailVO> socialSecurityChangeAdetailList) {
        this.socialSecurityChangeAdetailList = socialSecurityChangeAdetailList;
     }
}
