package com.ejianc.business.salary.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.salary.bean.*;
import com.ejianc.business.salary.service.*;
import com.ejianc.framework.core.util.ComputeUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.salary.mapper.TaxModifyMapper;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 个税计算-个税调整
 * 
 * @author generator
 * 
 */
@Service("taxModifyService")
public class TaxModifyServiceImpl extends BaseServiceImpl<TaxModifyMapper, TaxModifyEntity> implements ITaxModifyService{

    @Autowired
    private ITaxService taxService;
    @Autowired
    private IJspayableSourceService jspayableSourceService;
    @Autowired
    private IAcSetRelateService acSetRelateService;
    @Autowired
    private IPayableDetailService payableDetailService;

    @Override
    public void initTaxModify(Long taxId) {
        //1.查询到对应的应发工资计算子表id
        TaxEntity taxEntity = taxService.selectById(taxId);
        List<TaxDetailEntity> detailList = taxEntity.getDetailList();

        //2.根据应发工资计算子表id查询对应的 默认的单位 账套
        List<AcSetRelateEntity> acSetList = acSetRelateService.list(new QueryWrapper<AcSetRelateEntity>().in("org_id", detailList.stream().map(TaxDetailEntity::getTaxHoldOrgId).collect(Collectors.toList())));
        Map<Long, AcSetRelateEntity> acSetMap = acSetList.stream().collect(Collectors.toMap(p -> p.getOrgId(), Function.identity()));

        //3.保存对应的个税调整数据
        List<TaxModifyEntity> taxModifySaveList = new ArrayList<>();
        for (TaxDetailEntity detail : detailList) {
            TaxModifyEntity taxModifyEntity = new TaxModifyEntity();
            taxModifyEntity.setTaxHoldOrgId(detail.getDetailOrgId());
            taxModifyEntity.setTaxHoldOrgCode(detail.getDetailOrgCode());
            taxModifyEntity.setTaxHoldOrgName(detail.getDetailOrgName());
            taxModifyEntity.setAcSet(null != acSetMap.get(detail.getDetailOrgId()) ? acSetMap.get(detail.getDetailOrgId()).getAcSet() : null);
            taxModifyEntity.setAcSetCode(null != acSetMap.get(detail.getDetailOrgId()) ? acSetMap.get(detail.getDetailOrgId()).getAcSetCode() : null);


            //设置个税金额（累计应补/退税额）
            BigDecimal totalButuiTaxMny = detail.getTotalButuiTaxMny();
            taxModifyEntity.setTaxMny(totalButuiTaxMny);
            taxModifyEntity.setScale(new BigDecimal(1));
            taxModifyEntity.setTaxBillId(taxId);
            taxModifyEntity.setTaxBillDetailId(detail.getId());

            //是否默认单位
            taxModifyEntity.setIsDefault("1");
            taxModifySaveList.add(taxModifyEntity);
        }

        super.saveOrUpdateBatch(taxModifySaveList, taxModifySaveList.size());
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public void taxModifyApportion(Long taxId) {
        //个税调整 全删全加
        super.remove(new QueryWrapper<TaxModifyEntity>().eq("taxBillId", taxId));

        //1.查询到对应的应发工资计算子表id
        TaxEntity taxEntity = taxService.selectById(taxId);
        List<TaxDetailEntity> detailList = taxEntity.getDetailList();
        List<Long> sourceDetailIdList = detailList.stream().map(TaxDetailEntity::getYfgzjsBillDetailId).collect(Collectors.toList());
        //依照来源工资计算单据子表id分组 （个税计算）
        Map<Long, TaxDetailEntity> sourIdMap = detailList.stream().collect(Collectors.toMap(p -> p.getYfgzjsBillDetailId(), Function.identity()));

        //2.根据应发工资计算子表id查询对应的 来源
        List<JspayableSourceEntity> sourceEntityList = jspayableSourceService.list(new QueryWrapper<JspayableSourceEntity>().in("jspayableDetailId", sourceDetailIdList));

        // 查应发工资上传子表的数据
        List<PayableDetailEntity> payableDetailList = payableDetailService.list(new QueryWrapper<PayableDetailEntity>().in("id", sourceEntityList.stream().map(JspayableSourceEntity::getSourceDetailId).collect(Collectors.toList())));
        Map<Long, PayableDetailEntity> payableDetailMap = payableDetailList.stream().collect(Collectors.toMap(p -> p.getId(), Function.identity()));


        //查账套
        List<AcSetRelateEntity> acSetList = acSetRelateService.list(new QueryWrapper<AcSetRelateEntity>().in("org_id", detailList.stream().map(TaxDetailEntity::getTaxHoldOrgId).collect(Collectors.toList())));
        Map<Long, AcSetRelateEntity> acSetMap = acSetList.stream().collect(Collectors.toMap(p -> p.getOrgId(), Function.identity()));

        //3.根据应发公积金调整单 保存对应的个税调整数据
        List<TaxModifyEntity> taxModifySaveList = new ArrayList<>();
        for (JspayableSourceEntity sourceEntity : sourceEntityList) {
            TaxModifyEntity taxModifyEntity = new TaxModifyEntity();
            taxModifyEntity.setTaxHoldOrgId(sourceEntity.getOrgId());
            taxModifyEntity.setTaxHoldOrgCode(sourceEntity.getOrgCode());
            taxModifyEntity.setTaxHoldOrgName(sourceEntity.getOrgName());
            taxModifyEntity.setAcSet(acSetMap.get(sourceEntity.getOrgId()).getAcSet());
            taxModifyEntity.setAcSetCode(acSetMap.get(sourceEntity.getOrgId()).getAcSetCode());

            //比例
            taxModifyEntity.setScale(ComputeUtil.safeDiv(payableDetailMap.get(sourceEntity.getSourceDetailId()).getYfSalaryMny(), sourIdMap.get(sourceEntity.getJspayableDetailId()).getYfSalaryMny()));

            //todo：这里后续如果计算有差则用先A*比例，后B*比例，总值再减A减B的方式得C值
            //设置个税金额（累计应补/退税额）
            BigDecimal totalButuiTaxMny = sourIdMap.get(sourceEntity.getJspayableDetailId()).getTotalButuiTaxMny();
            taxModifyEntity.setTaxMny(ComputeUtil.safeDiv(ComputeUtil.safeMultiply(totalButuiTaxMny, taxModifyEntity.getScale()), new BigDecimal(100)));
            taxModifyEntity.setTaxBillId(taxId);
            taxModifyEntity.setTaxBillDetailId(sourIdMap.get(sourceEntity.getJspayableDetailId()).getId());
            //是否默认单位
            taxModifyEntity.setIsDefault(sourIdMap.get(sourceEntity.getJspayableDetailId()).getDetailOrgId().toString().equals(sourceEntity.getOrgId().toString()) ? "1" : "2");
            taxModifySaveList.add(taxModifyEntity);
        }
        super.saveOrUpdateBatch(taxModifySaveList, taxModifySaveList.size());
    }

}
