package com.ejianc.business.salary.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.salary.bean.JspayableDetailEntity;
/**
 * 应发工资计算
 * 
 * @author generator
 * 
 */
 @TableName("ejc_salary_jspayable")
public class JspayableEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="payable_sum_mny")
    private BigDecimal payableSumMny; // 应发工资汇总
    @TableField(value="yfms_salary_sum_mny")
    private BigDecimal yfmsSalarySumMny; // 应发+免税
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value="month")
    private Date month; // 月份
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="jspayableDetailService",pidName = "jspayableId")
    private List<JspayableDetailEntity> jspayableDetailList = new ArrayList<>(); // 应发工资计算明细

    public BigDecimal getYfmsSalarySumMny() {
        return yfmsSalarySumMny;
    }

    public void setYfmsSalarySumMny(BigDecimal yfmsSalarySumMny) {
        this.yfmsSalarySumMny = yfmsSalarySumMny;
    }

    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public BigDecimal getPayableSumMny() {
        return payableSumMny;
    }

    public void setPayableSumMny(BigDecimal payableSumMny) {
        this.payableSumMny = payableSumMny;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Date getMonth() {
        return month;
    }

    public void setMonth(Date month) {
        this.month = month;
    }
    

    public List<JspayableDetailEntity> getJspayableDetailList() {
        return jspayableDetailList;
    }

    public void setJspayableDetailList(List<JspayableDetailEntity> jspayableDetailList) {
        this.jspayableDetailList = jspayableDetailList;
    }
}
