package com.ejianc.business.salary.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.ejianc.business.salary.bean.JspayableAdjustEntity;
import com.ejianc.business.salary.bean.JspayableSourceEntity;
import com.ejianc.business.salary.bean.RosterEntity;
import com.ejianc.business.salary.service.IJspayableAdjustService;
import com.ejianc.business.salary.service.IJspayableSourceService;
import com.ejianc.business.salary.service.IRosterService;
import com.ejianc.business.salary.util.DetailIndexExcelReader;
import com.ejianc.business.salary.vo.*;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import org.apache.commons.collections.ArrayStack;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.salary.bean.JspayableEntity;
import com.ejianc.business.salary.service.IJspayableService;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

/**
 * 应发工资计算
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("jspayable")
public class JspayableController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "YFGZJS_CODE";//此处需要根据实际修改

    @Autowired
    private IJspayableService service;

    @Autowired
    private IJspayableSourceService jspayableSourceService;

    @Autowired
    private IJspayableAdjustService jspayableAdjustService;

    @Autowired
    private IRosterService rosterService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JspayableVO> saveOrUpdate(@RequestBody JspayableVO saveOrUpdateVO) {
    	JspayableEntity entity = BeanMapper.map(saveOrUpdateVO, JspayableEntity.class);

        LambdaQueryWrapper<JspayableEntity> lambdaQueryWrapper1 = new LambdaQueryWrapper<>();
        lambdaQueryWrapper1.eq(JspayableEntity::getMonth,saveOrUpdateVO.getMonth());
        if(null!=entity.getId()){
            lambdaQueryWrapper1.ne(JspayableEntity::getId, entity.getId());
        }
        List<JspayableEntity> list = service.list(lambdaQueryWrapper1);
        if(CollectionUtils.isNotEmpty(list)){
            throw new BusinessException("该月份已存在应发工资计算单，不允许重复添加!");
        }

    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	JspayableVO vo = BeanMapper.map(entity, JspayableVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JspayableVO> queryDetail(Long id) {
    	JspayableEntity entity = service.selectById(id);
    	JspayableVO vo = BeanMapper.map(entity, JspayableVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }



    /**
     * @Description querySumDetail 汇总/更新本月工资
     * @param yf
     */
    @RequestMapping(value = "/querySumDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<JspayableDetailVO>> querySumDetail(String yf) {
        Date month = new Date();
        DateFormat dateFormat = new SimpleDateFormat("yyyy-MM");
        try {
            month = dateFormat.parse(yf);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        List<JspayableDetailVO> res = new ArrayList<>();
        List<JspayableSourceVO> sourceList = service.getDetailSource(month);
        if(CollectionUtils.isNotEmpty(sourceList)){
            Set<String> idCards = new HashSet<>();
            sourceList.forEach(e->{
                idCards.add(e.getIdCard());
            });
            //第一步 查出的来源数据，放到source表  ---先删后增
            LambdaQueryWrapper<JspayableSourceEntity> lambdaQueryWrapper1 = new LambdaQueryWrapper<>();
            lambdaQueryWrapper1.eq(JspayableSourceEntity::getPeriod,month);
            lambdaQueryWrapper1.in(JspayableSourceEntity::getIdCard, idCards);
            jspayableSourceService.remove(lambdaQueryWrapper1);
            List<JspayableSourceEntity> jspayableSourceEntityList = BeanMapper.mapList(sourceList,JspayableSourceEntity.class);
            jspayableSourceEntityList.forEach(e->{
               e.setId(null);
            });
            jspayableSourceService.saveBatch(jspayableSourceEntityList);


            res = service.getDetailSum(month);
            //第二步  查出人员的 社保数据，放到adjust表  ---先删后增
            List<RosterAttendanceVO> attendanceVOList = service.queryAttendanceDetail(month,idCards.stream().collect(Collectors.toList()));
            Map<String,RosterAttendanceVO> attendanceMap = new HashMap<>();
            attendanceMap = attendanceVOList.stream().collect(Collectors.toMap(p -> p.getIdCard(), Function.identity()));

            List<RosterSbVO> sbVOList = service.querySbDetail(idCards.stream().collect(Collectors.toList()));
            Map<String,RosterSbVO> sbMap = new HashMap<>();
            sbMap = sbVOList.stream().collect(Collectors.toMap(p -> p.getIdCard(), Function.identity()));
            Map<String,RosterSbVO> gjjMap = new HashMap<>();
            List<RosterSbVO> gjjVOList = service.queryGjjDetail(idCards.stream().collect(Collectors.toList()));
            gjjMap= gjjVOList.stream().collect(Collectors.toMap(p -> p.getIdCard(), Function.identity()));
            List<JspayableAdjustEntity> adjustEntityList = new ArrayList<>();
            if(CollectionUtils.isNotEmpty(res)){
               for(JspayableDetailVO detailVO:res){
                   JspayableAdjustEntity entity = new JspayableAdjustEntity();
                   detailVO.setRowState("add");
                   entity.setSbcdOrgId(detailVO.getSbcdOrgId());
                   entity.setSbcdOrgCode(detailVO.getSbcdOrgCode());
                   entity.setSbcdOrgName(detailVO.getSbcdOrgName());
                   entity.setIdCard(detailVO.getIdCard());
                   entity.setPeriod(month);
                   entity.setScale(new BigDecimal(1));
                   entity.setIsDefault("1");//默认单位
                   if(attendanceMap.containsKey(detailVO.getIdCard())){
                       detailVO.setNeedAttendanceDays(attendanceMap.get(detailVO.getIdCard()).getShouldDay());
                       detailVO.setActualAttendanceDays(attendanceMap.get(detailVO.getIdCard()).getActualDay());
                   }
                   if(sbMap.containsKey(detailVO.getIdCard())){
                       detailVO.setPersonEndowmentMny(sbMap.get(detailVO.getIdCard()).getPersonAnnuityMoney());
                       detailVO.setPersonMedicalMny(sbMap.get(detailVO.getIdCard()).getPersonMedicalMoney());
                       detailVO.setPersonUnemploymentMny(sbMap.get(detailVO.getIdCard()).getPersonUnemploymentMoney());
                       detailVO.setCompanyBirthMny(sbMap.get(detailVO.getIdCard()).getCompanyChildbirthMoney());
                       detailVO.setCompanyEndowmentMny(sbMap.get(detailVO.getIdCard()).getCompanyAnnuityMoney());
                       detailVO.setCompanyInjureMny(sbMap.get(detailVO.getIdCard()).getCompanyInjuryMoney());
                       detailVO.setCompanyMedicalMny(sbMap.get(detailVO.getIdCard()).getCompanyMedicalMoney());
                       detailVO.setCompanyUnemploymentMny(sbMap.get(detailVO.getIdCard()).getCompanyUnemploymentMoney());

                       entity.setPersonEndowmentMny(detailVO.getPersonEndowmentMny());
                       entity.setPersonMedicalMny(detailVO.getPersonMedicalMny());
                       entity.setPersonUnemploymentMny(detailVO.getPersonUnemploymentMny());
                       entity.setCompanyBirthMny(detailVO.getCompanyBirthMny());
                       entity.setCompanyEndowmentMny(detailVO.getCompanyEndowmentMny());
                       entity.setCompanyInjureMny(detailVO.getCompanyInjureMny());
                       entity.setCompanyMedicalMny(detailVO.getCompanyMedicalMny());
                       entity.setCompanyUnemploymentMny(detailVO.getCompanyUnemploymentMny());
                   }else if(gjjMap.containsKey(detailVO.getIdCard())){
                       detailVO.setPersonHouseMny(gjjMap.get(detailVO.getIdCard()).getPersonMoney());
                       detailVO.setCompanyHouseMny(gjjMap.get(detailVO.getIdCard()).getCompanyMoney());
                       entity.setPersonHouseMny(detailVO.getPersonHouseMny());
                       entity.setCompanyHouseMny(detailVO.getCompanyHouseMny());
                   }
                   adjustEntityList.add(entity);
               }
                LambdaQueryWrapper<JspayableAdjustEntity> lambdaQueryWrapper2 = new LambdaQueryWrapper<>();
                lambdaQueryWrapper2.eq(JspayableAdjustEntity::getPeriod,month);
                lambdaQueryWrapper2.in(JspayableAdjustEntity::getIdCard, idCards);
                jspayableAdjustService.remove(lambdaQueryWrapper2);
                jspayableAdjustService.saveBatch(adjustEntityList);
            }

        }
        return CommonResponse.success("查询详情数据成功！",res);
    }

    /**
     * @Description querySourceDetail 查看薪资来源
     * @param
     */
    @RequestMapping(value = "/querySourceDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<SourceDetailVO>> querySourceDetail(String idCard,String period) {
        Date month = new Date();
        DateFormat dateFormat = new SimpleDateFormat("yyyy-MM");
        try {
            month = dateFormat.parse(period);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return CommonResponse.success("查询详情数据成功！",service.querySourceDetail(idCard,month));
    }


    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<JspayableVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (JspayableVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(JspayableVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<JspayableVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<JspayableEntity> page = service.queryPage(param,false);
        IPage<JspayableVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), JspayableVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<JspayableEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Jspayable-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refJspayableData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<JspayableVO>> refJspayableData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<JspayableEntity> page = service.queryPage(param,false);
        IPage<JspayableVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), JspayableVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadInfo")
    @ResponseBody
    public void downloadMaterial(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "JspayableDetail-import.xlsx", "应发工资计算-明细模板");
    }
    /**
     * excel导入
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/excelImportInfo", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportMaterial(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<JspayableDetailVO> successList = new ArrayList<>();
        List<JspayableDetailVO> errorList = new ArrayList<>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        }
        else {
            List<List<String>> result = DetailIndexExcelReader.readExcel(mf);
            if (result != null && result.size() > 0) {
                List<String> idCardList = new ArrayList<>();
                for (int i = 1; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    idCardList.add(datas.get(1).trim());
                }



                //获取人员花名册档案数据
                Map<String,RosterEntity> map = new HashMap<>();

                LambdaQueryWrapper<RosterEntity> lambdaQueryWrapper1 = new LambdaQueryWrapper<>();
                lambdaQueryWrapper1.eq(RosterEntity::getHrState, 1);
                lambdaQueryWrapper1.in(RosterEntity::getIdCard,idCardList);
                lambdaQueryWrapper1.isNotNull(RosterEntity::getIdCard);
                List<RosterEntity> rosterEntityList= rosterService.list(lambdaQueryWrapper1);
                map = rosterEntityList.stream().collect(Collectors.toMap(p -> p.getIdCard(), Function.identity()));
                logger.info("人员map: {}",JSONObject.toJSONString(map));
                //给每行赋值
                for (int i = 1; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    JspayableDetailVO detailVO = new JspayableDetailVO();
                    detailVO.setId(com.ejianc.support.idworker.util.IdWorker.getId());
                    try {
                        String idCard = datas.get(1).trim();
                        detailVO.setIdCard(idCard);
                        if (ObjectUtils.isEmpty(map.get(idCard))){
                            throw new Exception("没有该人员信息！");
                        }

                        detailVO.setDetailEmployeeId(map.get(idCard).getUserId());
                        detailVO.setDetailEmployeeName(datas.get(0));
                        detailVO.setDetailEmployeeCode(map.get(idCard).getUserCode());
                    }
                    catch (Exception e) {
                        detailVO.setErrorMsg("没有该人员信息！");
                        errorList.add(detailVO);
                        continue;
                    }

                    try {
                        String criticalIllnessMny = datas.get(2);
                        detailVO.setCriticalIllnessMny(StringUtils.isNotBlank(criticalIllnessMny)?new BigDecimal(criticalIllnessMny):null);
                    }
                    catch (Exception e) {
                        detailVO.setErrorMsg("大病医保错误！");
                        errorList.add(detailVO);
                        continue;
                    }
                    detailVO.setRowState("add");
                    successList.add(detailVO);
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }
}
