package com.ejianc.business.salary.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.ejianc.business.desktop.api.IIdmUserApi;
import com.ejianc.business.desktop.vo.idmUser.SalaryUserVO;
import com.ejianc.business.hr.api.IBaseUserApi;
import com.ejianc.business.hr.vo.salarySystem.SalaryUserDataVO;
import com.ejianc.business.salary.bean.RosterJobEntity;
import com.ejianc.business.salary.bean.RosterRecordEntity;
import com.ejianc.business.salary.service.*;
import com.ejianc.business.salary.util.DetailIndexExcelReaderZzyj;
import com.ejianc.business.salary.vo.SocialSecurityChangeAdetailVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IBankApi;
import com.ejianc.foundation.support.vo.BankVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.salary.bean.RosterEntity;
import com.ejianc.business.salary.vo.RosterVO;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

/**
 * 人员花名册
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("roster")
public class RosterController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IRosterService service;

    @Autowired
    private IRosterJobService jobService;

    @Autowired
    private IRosterTransferService transferService;

    @Autowired
    private IRosterSocialSecurityService socialSecurityService;

    @Autowired
    private IRosterAccumulationFundService accumulationFundService;

    @Autowired
    private IRosterAttendanceService attendanceService;


    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IRosterRecordService recordService;
    @Autowired
    private IIdmUserApi idmUserApi;

    @Autowired
    private IBaseUserApi baseUserApi;

    @Autowired
    private IBankApi bankApi;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<RosterVO> saveOrUpdate(@RequestBody RosterVO saveOrUpdateVO) {
    	RosterEntity entity = BeanMapper.map(saveOrUpdateVO, RosterEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	RosterVO vo = BeanMapper.map(entity, RosterVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description 修改银行账户信息
     */
    @RequestMapping(value = "/updateBankInfo", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> updateBankInfo(@RequestBody RosterVO saveOrUpdateVO) {
        RosterEntity entity = BeanMapper.map(saveOrUpdateVO, RosterEntity.class);
        RosterEntity rosterEntity = service.selectById(entity.getId());
        rosterEntity.setBankId(entity.getBankId());
        rosterEntity.setBankCode(entity.getBankCode());
        rosterEntity.setBankName(entity.getBankName());
        rosterEntity.setBankAccount(entity.getBankAccount());
        rosterEntity.setBankAddress(entity.getBankAddress());
        service.saveOrUpdate(rosterEntity, false);
        return CommonResponse.success("修改银行账户相关信息成功！");
    }


    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<RosterVO> queryDetail(Long id) {
    	RosterEntity entity = service.selectById(id);

        QueryParam param = new QueryParam();
        param.getParams().put("idCard", new Parameter(QueryParam.EQ,entity.getIdCard() ));

        //兼职
        entity.setRosterJobList(jobService.queryList(param));
        //社保
        entity.setRosterSocialSecurityList(socialSecurityService.queryList(param));
        //公积金
        entity.setRosterAccumulationFundList(accumulationFundService.queryList(param));
        //考勤
        entity.setRosterAttendanceList(attendanceService.queryList(param));
        //异动
        entity.setRosterTransferList(transferService.queryList(param));
        //工资发放

        //证书


        RosterVO vo = BeanMapper.map(entity, RosterVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<RosterVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (RosterVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(RosterVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<RosterVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("userCode");
        fuzzyFields.add("userName");
        fuzzyFields.add("orgName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 人员状态-启用 */
        param.getParams().put("hrState", new Parameter(QueryParam.EQ, 1));


        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
//        UserContext userContextCache =sessionManager.getUserContext();
//        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
//        String authOrgIds = userContextCache.getAuthOrgIds();
//        List<OrgVO> orgVOList = null;
//        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
//            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
//        }else {//pc端查询
//            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
//        }
//        //普通组织 id
//        List<Long> commonOrgIds = new ArrayList<>();
//        //项目部 id
//        List<Long> departmentIds = new ArrayList<>();
//        orgVOList.stream().forEach(org -> {
//            if(5 == org.getOrgType()) {
//                //项目部
//                departmentIds.add(org.getId());
//            } else {
//                //普通组织
//                commonOrgIds.add(org.getId());
//            }
//        });
//        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
//            /** 要求主表有orgId字段，保存单据所属组织 */
//            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
//        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
//            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
//            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
//        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<RosterEntity> page = service.queryPage(param,false);
        IPage<RosterVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), RosterVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<RosterEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Roster-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refRosterData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<RosterVO>> refRosterData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);

        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("userCode");
        fuzzyFields.add("userName");
        fuzzyFields.add("orgName");

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<RosterEntity> page = service.queryPage(param,false);
        IPage<RosterVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), RosterVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }


    /**
     * PM人员数据同步
     * @param request
     * @return
     */

    @RequestMapping(value = "/pmUserSync", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<JSONObject>> pmUserSync(HttpServletRequest request) {
        Calendar calendar=Calendar.getInstance();
        calendar.setTime(new Date());
        SimpleDateFormat simpleDateFormat1=new SimpleDateFormat("yyyyMMdd");
        String today = simpleDateFormat1.format(calendar.getTime());
        //拿到前一天的时间
        calendar.add(Calendar.DAY_OF_MONTH,-1);
        SimpleDateFormat simpleDateFormat=new SimpleDateFormat("yyyy-MM-dd");
        String format = simpleDateFormat.format(calendar.getTime());

        CommonResponse<List<SalaryUserVO>> listCommonResponse = idmUserApi.syncUserDataByTime(format);
        if (listCommonResponse.getCode() == 0){
            List<SalaryUserVO> data = listCommonResponse.getData();
            if (CollectionUtils.isNotEmpty(data)){
                int i = 1;
                for (SalaryUserVO datum : data) {
                    i++;
                    QueryParam param = new QueryParam();
                    param.getParams().put("idCard", new Parameter(QueryParam.EQ, datum.getIdCard()));
                    List<RosterEntity> rosterEntities = service.queryList(param);
                    if (rosterEntities != null && rosterEntities.size()>0){
                        //修改
                        logger.info("数据解析开发---执行修改---,{}",i);
                        RosterEntity rosterEntity = rosterEntities.get(0);
                        rosterEntity.setUserId(datum.getId());
                        rosterEntity.setUserName(datum.getUserName());
                        rosterEntity.setUserCode(datum.getUserCode());
                        rosterEntity.setMobilePhone(datum.getUserMobile());
                        rosterEntity.setEmployeeCode(datum.getEmployeeCode());
                        rosterEntity.setOrgId(datum.getOrgId());
                        rosterEntity.setOrgCode(datum.getOrgCode());
                        rosterEntity.setOrgName(datum.getOrgName());
                        rosterEntity.setDepartmentId(datum.getDeptId());
                        rosterEntity.setDepartmentCode(datum.getDeptCode());
                        rosterEntity.setDepartmentName(datum.getDeptName());
                        rosterEntity.setSyncDay(Long.parseLong(today));//同步时间
                        rosterEntity.setHrState(datum.getUserState());//人员状态 0停用 1启用
                        service.saveOrUpdate(rosterEntity);
                    }else {
                        logger.info("数据解析开发---执行新增---,{}",i);
                        //新增
                        RosterEntity rosterEntity = new RosterEntity();
                        rosterEntity.setIdCard(datum.getIdCard());
                        rosterEntity.setUserId(datum.getId());
                        rosterEntity.setUserName(datum.getUserName());
                        rosterEntity.setUserCode(datum.getUserCode());
                        rosterEntity.setMobilePhone(datum.getUserMobile());
                        rosterEntity.setEmployeeCode(datum.getEmployeeCode());
                        rosterEntity.setOrgId(datum.getOrgId());
                        rosterEntity.setOrgCode(datum.getOrgCode());
                        rosterEntity.setOrgName(datum.getOrgName());
                        rosterEntity.setDepartmentId(datum.getDeptId());
                        rosterEntity.setDepartmentCode(datum.getDeptCode());
                        rosterEntity.setDepartmentName(datum.getDeptName());
                        rosterEntity.setSyncDay(Long.parseLong(today));
                        rosterEntity.setHrState(datum.getUserState());//人员状态 0停用 1启用
                        service.saveOrUpdate(rosterEntity);
                    }
                }
            }
        }else {
            return CommonResponse.error("执行失败！");
        }

        return CommonResponse.success("执行成功！");
    }


    /**
     * 人力人员数据同步
     * @param request
     * @return
     */

    @RequestMapping(value = "/hrUserSync", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<JSONObject>> hrUserSync(HttpServletRequest request) {
        CommonResponse<List<SalaryUserDataVO>> listCommonResponse = baseUserApi.queryAllUserSalary(new QueryParam());
        if (listCommonResponse.getCode() == 0){
            List<SalaryUserDataVO> data = listCommonResponse.getData();
            if (CollectionUtils.isNotEmpty(data)){
                int i = 1;
                for (SalaryUserDataVO datum : data) {
                    i++;
                    QueryParam param = new QueryParam();
                    param.getParams().put("idCard", new Parameter(QueryParam.EQ, datum.getCard()));
                    List<RosterEntity> rosterEntities = service.queryList(param);
                    if (rosterEntities != null && rosterEntities.size()>0){
                        //修改
                        logger.info("数据解析开发---执行修改---,{}",i);
                        RosterEntity rosterEntity = rosterEntities.get(0);
                        if (rosterEntity.getJobLevelName() != null && !rosterEntity.getJobLevelName().equals(datum.getJobLevelName())){
                            //岗级不同 需要将历史数据存入历史表中
                            RosterRecordEntity map = BeanMapper.map(rosterEntity, RosterRecordEntity.class);
                            map.setId(null);
                            recordService.saveOrUpdate(map);
                        }
                        rosterEntity.setPostName(datum.getPostName());
                        rosterEntity.setJobLevelName(datum.getJobLevelName());
                        rosterEntity.setSexName(datum.getSexName());
                        rosterEntity.setUserTypeName(datum.getUserTypeName());
                        rosterEntity.setResidencyTypeName(datum.getResidencyTypeName());
                        rosterEntity.setEducationName(datum.getEducationName());
                        rosterEntity.setTitleName(datum.getTitleName());
                        rosterEntity.setSocialDepartmentCode(datum.getSocialDepartmentCode());
                        rosterEntity.setSocialDepartmentName(datum.getSocialDepartmentName());
                        rosterEntity.setWorkYear(datum.getWorkYear()+"");
                        rosterEntity.setSourceType(datum.getSourceType());
                        service.saveOrUpdate(rosterEntity);
                    }else {
                        logger.error("数据解析开发---人员不存在---,{}",datum.getCard());

                    }
                }
            }
        }else {
            return CommonResponse.error("执行失败！");
        }

        return CommonResponse.success("执行成功！");
    }


    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadInfo")
    @ResponseBody
    public void downloadInfo(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "RosterBankInfo-import.xlsx", "银行账户调整导入模板");
    }
    /**
     * excel导入
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/excelImportInfo", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportInfo(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<RosterVO> successList = new ArrayList<>();
        List<RosterVO> errorList = new ArrayList<>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        }
        else {
            List<List<String>> result = DetailIndexExcelReaderZzyj.readExcel(mf);
            if (result != null && result.size() > 0) {
                List<String> idCardList = new ArrayList<>();
                for (int i = 1; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    idCardList.add(datas.get(1).trim());
                }

                //获取人员花名册档案数据
                Map<String, RosterEntity> map = new HashMap<>();
                LambdaQueryWrapper<RosterEntity> lambdaQueryWrapper1 = new LambdaQueryWrapper<>();
                lambdaQueryWrapper1.eq(RosterEntity::getHrState, 1);
                lambdaQueryWrapper1.in(RosterEntity::getIdCard,idCardList);
                lambdaQueryWrapper1.isNotNull(RosterEntity::getIdCard);
                List<RosterEntity> rosterEntityList= service.list(lambdaQueryWrapper1);
                map = rosterEntityList.stream().collect(Collectors.toMap(p -> p.getIdCard(), Function.identity()));
                logger.info("人员map: {}",JSONObject.toJSONString(map));
                //给每行赋值
                for (int i = 1; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    RosterVO detailVO = new RosterVO();
                    detailVO.setId(com.ejianc.support.idworker.util.IdWorker.getId());
                    RosterEntity rosterEntity = null;
                    try {
                        //身份证号
                        String idCard = datas.get(1).trim();
                        detailVO.setIdCard(idCard);
                        if (ObjectUtils.isEmpty(map.get(idCard))){
                            throw new Exception("没有该人员信息！");
                        }

                         rosterEntity = map.get(idCard);
                        String userName = datas.get(0).trim();
                        if (userName != null && userName.equals(rosterEntity.getUserName())){
                            detailVO.setUserName(userName);
                            detailVO.setUserId(rosterEntity.getUserId());
                            detailVO.setUserCode(rosterEntity.getUserCode());

                            rosterEntity.setUserName(userName);
                            rosterEntity.setUserId(rosterEntity.getUserId());
                            rosterEntity.setUserCode(rosterEntity.getUserCode());
                            rosterEntity.setIdCard(idCard);
                        }else {
                            throw new Exception("人员身份证号、姓名不匹配！");
                        }

                    }
                    catch (Exception e) {
                        detailVO.setErrorMsg("人员名称、身份证号错误！");
                        errorList.add(detailVO);
                        continue;
                    }

                    //开户行名称
                    try {
                        String bankName = datas.get(2);
                        if(StringUtils.isNotBlank(bankName)) {
                            detailVO.setBankName(bankName);
                            rosterEntity.setBankName(bankName);
                        }else {
                            throw new Exception("开户行名称不能为空！");
                        }
                    } catch (Exception e) {
                        detailVO.setErrorMsg("开户行名称错误！");
                        errorList.add(detailVO);
                        continue;
                    }
                    //联行号
                    try {
                        String bankCode = datas.get(3);
                        if(StringUtils.isNotBlank(bankCode)) {
                            CommonResponse<List<BankVO>> listCommonResponse = bankApi.queryListByCode(bankCode);
                            if (listCommonResponse != null && listCommonResponse.getCode() == 0){
                                List<BankVO> data = listCommonResponse.getData();
                                if (CollectionUtils.isNotEmpty(data)){
                                    BankVO bankVO = data.get(0);
                                    detailVO.setBankId(bankVO.getId());
                                    detailVO.setBankName(bankVO.getName());
                                    detailVO.setBankCode(bankVO.getCode());
                                    detailVO.setBankAddress(bankVO.getAddress());


                                    rosterEntity.setBankId(bankVO.getId());
                                    rosterEntity.setBankName(bankVO.getName());
                                    rosterEntity.setBankCode(bankVO.getCode());
                                    rosterEntity.setBankAddress(bankVO.getAddress());
                                }else {
                                    throw new Exception("联行号输入错误！");
                                }
                            }else {
                                throw new Exception("查询银行信息异常！");
                            }
                        }else {
                            throw new Exception("联行号不能为空！");
                        }
                    } catch (Exception e) {
                        detailVO.setErrorMsg("联行号错误！");
                        errorList.add(detailVO);
                        continue;
                    }
                    //银行账户
                    try {
                        String bankAccount = datas.get(4);
                        if(StringUtils.isNotBlank(bankAccount)) {
                            detailVO.setBankAccount(bankAccount);
                            rosterEntity.setBankAccount(bankAccount);
                        }else {
                            throw new Exception("银行账户不能为空！");
                        }
                    } catch (Exception e) {
                        detailVO.setErrorMsg("银行账户错误！");
                        errorList.add(detailVO);
                        continue;
                    }



                    detailVO.setBankAddress( datas.get(5));
                    rosterEntity.setBankAddress( datas.get(5));
                    service.saveOrUpdate(rosterEntity);

                    detailVO.setRowState("add");
                    successList.add(detailVO);
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());


        return CommonResponse.success(json);
    }

}
