package com.ejianc.business.salary.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.salary.bean.*;
import com.ejianc.business.salary.service.IPayrollService;
import com.ejianc.business.salary.service.ITaxService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

@Service("tax") 
public class TaxBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private ITaxService taxService;
	@Autowired
	private IPayrollService payrollService;
	
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		TaxEntity taxEntity = taxService.selectById(billId);
//		单据生效之后把个税金额（累计应补/退税额）推送到工资单，同时更新下应发免税、应发计税
		Map<Long, TaxDetailEntity> taxDetailMap = taxEntity.getDetailList().stream().collect(Collectors.toMap(p -> p.getId(), Function.identity()));
		PayrollEntity payrollEntity = payrollService.getOne(new QueryWrapper<PayrollEntity>().eq("yfgzjs_bill_id", taxEntity.getYfgzjsBillId()));
		for (PayrollPersonEntity payrollPersonEntity : payrollEntity.getPayrollPersonList()) {
			if (taxDetailMap.containsKey(payrollPersonEntity.getTaxBillDetailId())){
				payrollPersonEntity.setTotalButuiTaxMny(taxDetailMap.get(payrollPersonEntity.getTaxBillDetailId()).getTotalButuiTaxMny());
				payrollPersonEntity.setYfmsMny(taxDetailMap.get(payrollPersonEntity.getTaxBillDetailId()).getYfmsMny());
				payrollPersonEntity.setYfmsSalaryMny(taxDetailMap.get(payrollPersonEntity.getTaxBillDetailId()).getYfmsSalaryMny());
			}
		}
		// 按单位查看得子表数据怎么出？

		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		TaxEntity taxEntity = taxService.selectById(billId);
		PayrollEntity payrollEntity = payrollService.getOne(new QueryWrapper<PayrollEntity>().eq("yfgzjs_bill_id", taxEntity.getYfgzjsBillId()));
		if (payrollEntity.getBillState() == 1 || payrollEntity.getBillState() == 3 || payrollEntity.getBillState() == 2 || payrollEntity.getBillState() == 5){
			return CommonResponse.error("工资单审批中或已生效，不能撤回！");
		}
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
