package com.ejianc.business.salary.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.salary.bean.TaxDetailEntity;
/**
 * 个税计算-主实体
 * 
 * @author generator
 * 
 */
 @TableName("ejc_salary_tax")
public class TaxEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="sum_tax_mny")
    private BigDecimal sumTaxMny; // 个税金额汇总
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value="month")
    private Date month; // 月份
    @TableField(value="yfgzjs_bill_id")
    private Long yfgzjsBillId; // 应发工资计算单据id
    @TableField(value="yfgzjs_bill_code")
    private String yfgzjsBillCode; // 应发工资计算单据编码
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="taxDetailService",pidName = "taxId")
    private List<TaxDetailEntity> detailList = new ArrayList<>(); // 个税计算-人员明细
    

    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public BigDecimal getSumTaxMny() {
        return sumTaxMny;
    }

    public void setSumTaxMny(BigDecimal sumTaxMny) {
        this.sumTaxMny = sumTaxMny;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Date getMonth() {
        return month;
    }

    public void setMonth(Date month) {
        this.month = month;
    }

    public Long getYfgzjsBillId() {
        return yfgzjsBillId;
    }

    public void setYfgzjsBillId(Long yfgzjsBillId) {
        this.yfgzjsBillId = yfgzjsBillId;
    }

    public String getYfgzjsBillCode() {
        return yfgzjsBillCode;
    }

    public void setYfgzjsBillCode(String yfgzjsBillCode) {
        this.yfgzjsBillCode = yfgzjsBillCode;
    }

    public List<TaxDetailEntity> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<TaxDetailEntity> detailList) {
        this.detailList = detailList;
    }
}
