package com.ejianc.business.salary.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.salary.vo.JsAdjustVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.salary.bean.JspayableAdjustEntity;
import com.ejianc.business.salary.service.IJspayableAdjustService;
import com.ejianc.business.salary.vo.JspayableAdjustVO;

/**
 * 应发公积金调整
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("jspayableAdjust")
public class JspayableAdjustController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IJspayableAdjustService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JsAdjustVO> saveOrUpdate(@RequestBody JsAdjustVO saveOrUpdateVO) {
        List<JspayableAdjustVO> jspayableAdjustVOS = saveOrUpdateVO.getJspayableAdjustList();
        if(CollectionUtils.isNotEmpty(jspayableAdjustVOS)){
            jspayableAdjustVOS.forEach(e->{
                service.saveOrUpdate(BeanMapper.map(e, JspayableAdjustEntity.class),false);
            });
        }else{
            throw new BusinessException("子表不能为空!");
        }
        String idCard = jspayableAdjustVOS.get(0).getIdCard();
        Date period = jspayableAdjustVOS.get(0).getPeriod();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM");
        String dateString = formatter.format(period);
    	return queryDetail(idCard,dateString);
    }

    /**
     * @Description queryDetail 查询详情
     * @param
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JsAdjustVO> queryDetail(String idCard,String period) {
        Date month = new Date();
        DateFormat dateFormat = new SimpleDateFormat("yyyy-MM");
        try {
            month = dateFormat.parse(period);
        } catch (ParseException e) {
            e.printStackTrace();
        }

        JsAdjustVO resVO = new JsAdjustVO();
        LambdaQueryWrapper<JspayableAdjustEntity> lambdaQueryWrapper2 = new LambdaQueryWrapper<>();
        lambdaQueryWrapper2.eq(JspayableAdjustEntity::getPeriod,month);
        lambdaQueryWrapper2.eq(JspayableAdjustEntity::getIdCard, idCard);
        List<JspayableAdjustEntity> list = service.list(lambdaQueryWrapper2);
        if(CollectionUtils.isNotEmpty(list)){
            resVO.setJspayableAdjustList(BeanMapper.mapList(list, JspayableAdjustVO.class));

            //汇总主表信息
            BigDecimal personEndowmentMny = BigDecimal.ZERO; // 个人养老金额
            BigDecimal personMedicalMny = BigDecimal.ZERO; // 个人医疗金额
            BigDecimal personUnemploymentMny = BigDecimal.ZERO; // 个人失业金额
            BigDecimal personHouseMny = BigDecimal.ZERO; // 个人公积金
            BigDecimal companyEndowmentMny = BigDecimal.ZERO; // 公司养老金额
            BigDecimal companyMedicalMny = BigDecimal.ZERO; // 公司医疗金额
            BigDecimal companyUnemploymentMny = BigDecimal.ZERO; // 公司失业金额
            BigDecimal companyBirthMny = BigDecimal.ZERO; // 公司生育金额
            BigDecimal companyInjureMny = BigDecimal.ZERO; // 公司工伤金额
            BigDecimal companyHouseMny = BigDecimal.ZERO; // 公司公积金
            for(JspayableAdjustEntity e:list){
                personEndowmentMny = ComputeUtil.safeAdd(personEndowmentMny,e.getPersonEndowmentMny());
                personMedicalMny =  ComputeUtil.safeAdd(personMedicalMny,e.getPersonMedicalMny());
                personUnemploymentMny =  ComputeUtil.safeAdd(personUnemploymentMny,e.getPersonUnemploymentMny());
                personHouseMny =  ComputeUtil.safeAdd(personHouseMny,e.getPersonHouseMny());
                companyEndowmentMny =  ComputeUtil.safeAdd(companyEndowmentMny,e.getCompanyEndowmentMny());
                companyMedicalMny =  ComputeUtil.safeAdd(companyMedicalMny,e.getCompanyMedicalMny());
                companyUnemploymentMny =  ComputeUtil.safeAdd(companyUnemploymentMny,e.getCompanyUnemploymentMny());
                companyBirthMny =  ComputeUtil.safeAdd(companyBirthMny,e.getCompanyBirthMny());
                companyInjureMny =  ComputeUtil.safeAdd(companyInjureMny,e.getCompanyInjureMny());
                companyHouseMny =  ComputeUtil.safeAdd(companyHouseMny,e.getCompanyHouseMny());
            }
            resVO.setPersonEndowmentMny(personEndowmentMny);
            resVO.setPersonMedicalMny(personMedicalMny);
            resVO.setPersonUnemploymentMny(personUnemploymentMny);
            resVO.setPersonHouseMny(personHouseMny);
            resVO.setCompanyEndowmentMny(companyEndowmentMny);
            resVO.setCompanyMedicalMny(companyMedicalMny);
            resVO.setCompanyUnemploymentMny(companyUnemploymentMny);
            resVO.setCompanyBirthMny(companyBirthMny);
            resVO.setCompanyInjureMny(companyInjureMny);
            resVO.setCompanyHouseMny(companyHouseMny);
        }
        return CommonResponse.success("查询详情数据成功！",resVO);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<JspayableAdjustVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (JspayableAdjustVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(JspayableAdjustVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<JspayableAdjustVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<JspayableAdjustEntity> page = service.queryPage(param,false);
        IPage<JspayableAdjustVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), JspayableAdjustVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<JspayableAdjustEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("JspayableAdjust-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refJspayableAdjustData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<JspayableAdjustVO>> refJspayableAdjustData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<JspayableAdjustEntity> page = service.queryPage(param,false);
        IPage<JspayableAdjustVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), JspayableAdjustVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }


    /**
     * @Description insuranceAdjustApportion 分摊社保公积金（点击分摊社保公积金时调用）
     * @Param id
     */
    @RequestMapping(value = "/insuranceAdjustApportion", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> insuranceAdjustApportion(Long jspayableId) {
        service.insuranceAdjustApportion(jspayableId);
        return CommonResponse.success("社保公积金分摊成功！");
    }
}
