package com.ejianc.business.salary.service.impl;

import com.ejianc.business.salary.vo.*;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.salary.mapper.JspayableMapper;
import com.ejianc.business.salary.bean.JspayableEntity;
import com.ejianc.business.salary.service.IJspayableService;

import java.util.Date;
import java.util.List;

/**
 * 应发工资计算
 * 
 * @author generator
 * 
 */
@Service("jspayableService")
public class JspayableServiceImpl extends BaseServiceImpl<JspayableMapper, JspayableEntity> implements IJspayableService{

    @Override
    public List<JspayableDetailVO> getDetailSum(Date month) {
        return baseMapper.getDetailSum(month);
    }

    @Override
    public List<JspayableSourceVO> getDetailSource(Date month) {
        return baseMapper.getDetailSource(month);
    }

    @Override
    public List<SourceDetailVO> querySourceDetail(String idCard, Date period) {
        return baseMapper.querySourceDetail(idCard,period);
    }

    @Override
    public List<RosterAttendanceVO> queryAttendanceDetail(Date month, List<String> idCards) {
        return baseMapper.queryAttendanceDetail(month, idCards);
    }

    @Override
    public List<RosterSbVO> querySbDetail(List<String> idCards) {
        return baseMapper.querySbDetail(idCards);
    }

    @Override
    public List<RosterSbVO> queryGjjDetail(List<String> idCards) {
        return baseMapper.queryGjjDetail(idCards);
    }
}
