package com.ejianc.business.salary.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.ejianc.business.salary.bean.*;
import com.ejianc.business.salary.service.IRosterAccumulationFundService;
import com.ejianc.business.salary.service.IRosterSocialSecurityService;
import com.ejianc.business.salary.service.ISocialSecurityChangeService;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.List;

@Service("socialSecurityChange") 
public class SocialSecurityChangeBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private ISocialSecurityChangeService service;

	@Autowired
	private IRosterSocialSecurityService socialSecurityService;

	@Autowired
	private IRosterAccumulationFundService accumulationFundService;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.error("此单据不允许撤回！");
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		//推送花名册-社保、公积金子表
		SocialSecurityChangeEntity socialSecurityChangeEntity = service.selectById(billId);
		if (socialSecurityChangeEntity != null){
			//社保
			List<SocialSecurityChangeSdetailEntity> socialSecurityChangeSdetailList =
					socialSecurityChangeEntity.getSocialSecurityChangeSdetailList();
			if (CollectionUtils.isNotEmpty(socialSecurityChangeSdetailList)){
				List<RosterSocialSecurityEntity> rosterSocialSecurityEntities = BeanMapper.mapList(socialSecurityChangeSdetailList, RosterSocialSecurityEntity.class);
				socialSecurityService.updateSocialSecurity(rosterSocialSecurityEntities);
			}

			//公积金
			List<SocialSecurityChangeAdetailEntity> socialSecurityChangeAdetailList = socialSecurityChangeEntity.getSocialSecurityChangeAdetailList();
			if (CollectionUtils.isNotEmpty(socialSecurityChangeAdetailList)){
				List<RosterAccumulationFundEntity> rosterAccumulationFundEntities = BeanMapper.mapList(socialSecurityChangeAdetailList, RosterAccumulationFundEntity.class);
				accumulationFundService.updateAccumulationFund(rosterAccumulationFundEntities);
			}
		}

		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.error("此单据不允许弃审！");
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
