package com.ejianc.business.salary.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.salary.bean.*;
import com.ejianc.business.salary.service.*;
import com.ejianc.business.salary.vo.PayrollVO;
import com.ejianc.business.salary.vo.TaxDetailVO;
import com.ejianc.business.salary.vo.TaxVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

@Service("jspayable") 
public class JspayableBpmServiceImpl implements ICommonBusinessService {
	private Logger logger = LoggerFactory.getLogger(this.getClass());
	private static final String TAX_BILL_CODE = "TAX";//此处需要根据实际修改
	private static final String PAYROLL_BILL_CODE = "PAYROLL_CODE";//此处需要根据实际修改
	@Autowired
	private IJspayableService jspayableService;
	@Autowired
	private ITaxService taxService;
	@Autowired
	private IPayrollService payrollService;
	@Autowired
	private IBillCodeApi billCodeApi;
	@Autowired
	private ITaxModifyService taxModifyService;


    @Autowired
    private IJspayableSourceService jspayableSourceService;
    @Autowired
    private IAcSetRelateService acSetRelateService;
    @Autowired
    private IPayableDetailService payableDetailService;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//生成个税计算单
		JspayableEntity jspayableEntity = jspayableService.selectById(billId);
		TaxEntity taxEntity = new TaxEntity();
		taxEntity.setBillState(0);
		taxEntity.setId(IdWorker.getId());
		taxEntity.setEmployeeId(jspayableEntity.getEmployeeId());
		taxEntity.setEmployeeName(jspayableEntity.getEmployeeName());
		taxEntity.setYfgzjsBillId(jspayableEntity.getId());
		taxEntity.setYfgzjsBillCode(jspayableEntity.getBillCode());
		taxEntity.setMonth(jspayableEntity.getMonth());
		//编码，看后期是否需要
		BillCodeParam billCodeParam = BillCodeParam.build(TAX_BILL_CODE, InvocationInfoProxy.getTenantid(), BeanMapper.map(taxEntity, TaxVO.class));
		CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
		if(billCode.isSuccess()) {
			taxEntity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
		}else{
			throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
		}

		List<TaxDetailEntity> taxDetailList = new ArrayList<>();
		for (JspayableDetailEntity detail : jspayableEntity.getJspayableDetailList()) {
			TaxDetailEntity taxDetailEntity = BeanMapper.map(detail, TaxDetailEntity.class);
			taxDetailEntity.setId(IdWorker.getId());
            taxDetailEntity.setTaxId(taxEntity.getId());
			taxDetailEntity.setSybxMny(detail.getCriticalIllnessMny());
			taxDetailEntity.setIsAdjust("2");
			taxDetailEntity.setYfgzjsBillDetailId(detail.getId());
			taxDetailEntity.setYfgzjsBillId(billId);
			//设置个税缴纳单位（来源应发工资计算中默认 单位）
			taxDetailEntity.setTaxHoldOrgName(detail.getDetailOrgName());
			taxDetailEntity.setTaxHoldOrgId(detail.getDetailOrgId());
			taxDetailEntity.setTaxHoldOrgCode(detail.getDetailOrgCode());
			taxDetailList.add(taxDetailEntity);
		}
		taxEntity.setDetailList(taxDetailList);
		logger.info("生成个税计算单数据：{}", JSONObject.toJSONString(taxEntity));
		taxService.saveOrUpdate(taxEntity, false);

		//初始化个税调整
		taxModifyService.initTaxModify(taxEntity.getId());

		//生成工资单
		PayrollEntity payrollEntity = new PayrollEntity();
		payrollEntity.setBillState(0);
		payrollEntity.setId(IdWorker.getId());
		payrollEntity.setEmployeeId(jspayableEntity.getEmployeeId());
		payrollEntity.setEmployeeName(jspayableEntity.getEmployeeName());
		payrollEntity.setYfgzjsBillId(jspayableEntity.getId());
		payrollEntity.setYfgzjsBillCode(jspayableEntity.getBillCode());
		payrollEntity.setTaxBillId(taxEntity.getId());
		payrollEntity.setMonth(jspayableEntity.getMonth());
		//编码，看后期是否需要
		BillCodeParam payrollBillCodeParam = BillCodeParam.build(PAYROLL_BILL_CODE, InvocationInfoProxy.getTenantid(), BeanMapper.map(payrollEntity, PayrollVO.class));
		CommonResponse<String> payrollBillCode = billCodeApi.generateBillCode(payrollBillCodeParam);
		if(payrollBillCode.isSuccess()) {
			payrollEntity.setBillCode(payrollBillCode.getData());//此处需要根据实际修改 删除本行或者上一行
		}else{
			throw new BusinessException("网络异常， 工资单编码生成失败， 请稍后再试");
		}

		List<PayrollPersonEntity> personDetailList = new ArrayList<>();
		for (JspayableDetailEntity detail : jspayableEntity.getJspayableDetailList()) {
			PayrollPersonEntity personDetailEntity = BeanMapper.map(detail, PayrollPersonEntity.class);

            personDetailEntity.setId(IdWorker.getId());
			personDetailEntity.setSybxMny(detail.getCriticalIllnessMny());
			//设置工资发放单位
			personDetailEntity.setGzffOrgId(detail.getDetailOrgId());
			personDetailEntity.setGzffOrgCode(detail.getDetailOrgCode());
			personDetailEntity.setGzffOrgName(detail.getDetailOrgName());

			personDetailEntity.setYfgzjsBillDetailId(detail.getId());
			personDetailEntity.setYfgzjsBillId(billId);
			personDetailEntity.setTaxBillId(taxEntity.getId());
			personDetailEntity.setPayrollId(payrollEntity.getId());

			// 实发=应发-个税-养老-失业-医疗-公积金-大病医保+应发免税
			personDetailEntity.setActualMny(ComputeUtil.safeAdd(ComputeUtil.safeSub(personDetailEntity.getYfSalaryMny(), personDetailEntity.getPersonEndowmentMny(), personDetailEntity.getPersonUnemploymentMny(), personDetailEntity.getPersonMedicalMny(), personDetailEntity.getPersonHouseMny(), personDetailEntity.getCertificateMny()), personDetailEntity.getYfmsMny()));
			personDetailEntity.setAlreadyMny(BigDecimal.ZERO);
			personDetailEntity.setLeftMny(personDetailEntity.getActualMny());

			personDetailList.add(personDetailEntity);
		}
		payrollEntity.setPayrollPersonList(personDetailList);

		List<JspayableSourceEntity> sourceEntityList = jspayableSourceService.list(new QueryWrapper<JspayableSourceEntity>().in("id_card", jspayableEntity.getJspayableDetailList().stream().map(JspayableDetailEntity::getIdCard).collect(Collectors.toList())).eq("month", jspayableEntity.getMonth()));

        // 查应发工资上传子表的数据
        List<PayableDetailEntity> payableDetailList = payableDetailService.list(new QueryWrapper<PayableDetailEntity>().in("id", sourceEntityList.stream().map(JspayableSourceEntity::getSourceDetailId).collect(Collectors.toList())));
        // 按照组织分组
        Map<Long, List<PayableDetailEntity>> payableDetailMap = payableDetailList.stream().collect(Collectors.groupingBy(PayableDetailEntity::getDetailOrgId));

        // 应发工资计算子表按照组织分组
		Map<Long, List<JspayableDetailEntity>> jsPayableDetailMap = jspayableEntity.getJspayableDetailList().stream().collect(Collectors.groupingBy(JspayableDetailEntity::getDetailOrgId));

        List<PayrollUnitEntity> unitDetailList = new ArrayList<>();
		for (Long orgId : payableDetailMap.keySet()) {
			List<PayableDetailEntity> detailList = payableDetailMap.get(orgId);
		    PayrollUnitEntity payrollUnitEntity = new PayrollUnitEntity();
            payrollUnitEntity.setId(IdWorker.getId());
            payrollUnitEntity.setPayrollId(payrollEntity.getId());
            payrollUnitEntity.setTaxBillId(taxEntity.getId());
            payrollUnitEntity.setYfgzjsBillId(billId);

			payrollUnitEntity.setGzffOrgId(detailList.get(0).getGzffOrgId());
			payrollUnitEntity.setGzffOrgCode(detailList.get(0).getGzffOrgCode());
			payrollUnitEntity.setGzffOrgName(detailList.get(0).getGzffOrgName());
			payrollUnitEntity.setUnWriteOffMny(detailList.stream().filter(p -> p.getUnWriteOffMny() != null).map(PayableDetailEntity::getUnWriteOffMny).reduce(BigDecimal.ZERO, BigDecimal::add));
			payrollUnitEntity.setWriteOffMny(detailList.stream().filter(p -> p.getWriteOffMny() != null).map(PayableDetailEntity::getWriteOffMny).reduce(BigDecimal.ZERO, BigDecimal::add));
			payrollUnitEntity.setYfjsMny(detailList.stream().filter(p -> p.getYfjsMny() != null).map(PayableDetailEntity::getYfjsMny).reduce(BigDecimal.ZERO, BigDecimal::add));
			payrollUnitEntity.setYfmsMny(detailList.stream().filter(p -> p.getYfmsMny() != null).map(PayableDetailEntity::getYfmsMny).reduce(BigDecimal.ZERO, BigDecimal::add));
			payrollUnitEntity.setJobMny(detailList.stream().filter(p -> p.getJobMny() != null).map(PayableDetailEntity::getJobMny).reduce(BigDecimal.ZERO, BigDecimal::add));
			payrollUnitEntity.setPerformanceMny(detailList.stream().filter(p -> p.getPerformanceMny() != null).map(PayableDetailEntity::getPerformanceMny).reduce(BigDecimal.ZERO, BigDecimal::add));
			payrollUnitEntity.setWorkYearMny(detailList.stream().filter(p -> p.getWorkYearMny() != null).map(PayableDetailEntity::getWorkYearMny).reduce(BigDecimal.ZERO, BigDecimal::add));
			payrollUnitEntity.setWorkTypeMny(detailList.stream().filter(p -> p.getWorkTypeMny() != null).map(PayableDetailEntity::getWorkTypeMny).reduce(BigDecimal.ZERO, BigDecimal::add));
			payrollUnitEntity.setCertificateMny(detailList.stream().filter(p -> p.getCertificateMny() != null).map(PayableDetailEntity::getCertificateMny).reduce(BigDecimal.ZERO, BigDecimal::add));
			payrollUnitEntity.setTravelMny(detailList.stream().filter(p -> p.getTravelMny() != null).map(PayableDetailEntity::getTravelMny).reduce(BigDecimal.ZERO, BigDecimal::add));
			payrollUnitEntity.setTrafficMny(detailList.stream().filter(p -> p.getTrafficMny() != null).map(PayableDetailEntity::getTrafficMny).reduce(BigDecimal.ZERO, BigDecimal::add));
			payrollUnitEntity.setMealMny(detailList.stream().filter(p -> p.getMealMny() != null).map(PayableDetailEntity::getMealMny).reduce(BigDecimal.ZERO, BigDecimal::add));
			payrollUnitEntity.setBenefitMny(detailList.stream().filter(p -> p.getBenefitMny() != null).map(PayableDetailEntity::getBenefitMny).reduce(BigDecimal.ZERO, BigDecimal::add));
			payrollUnitEntity.setHolidayMny(detailList.stream().filter(p -> p.getHolidayMny() != null).map(PayableDetailEntity::getHolidayMny).reduce(BigDecimal.ZERO, BigDecimal::add));
			payrollUnitEntity.setYearEndMny(detailList.stream().filter(p -> p.getYearEndMny() != null).map(PayableDetailEntity::getYearEndMny).reduce(BigDecimal.ZERO, BigDecimal::add));
			payrollUnitEntity.setOvertimeMny(detailList.stream().filter(p -> p.getOvertimeMny() != null).map(PayableDetailEntity::getOvertimeMny).reduce(BigDecimal.ZERO, BigDecimal::add));
			payrollUnitEntity.setAddMny(detailList.stream().filter(p -> p.getAddMny() != null).map(PayableDetailEntity::getAddMny).reduce(BigDecimal.ZERO, BigDecimal::add));
			payrollUnitEntity.setButtonMny(detailList.stream().filter(p -> p.getButtonMny() != null).map(PayableDetailEntity::getButtonMny).reduce(BigDecimal.ZERO, BigDecimal::add));
			payrollUnitEntity.setSalaryMny(detailList.stream().filter(p -> p.getSalaryMny() != null).map(PayableDetailEntity::getSalaryMny).reduce(BigDecimal.ZERO, BigDecimal::add));
			payrollUnitEntity.setYfSalaryMny(detailList.stream().filter(p -> p.getYfSalaryMny() != null).map(PayableDetailEntity::getYfSalaryMny).reduce(BigDecimal.ZERO, BigDecimal::add));
			payrollUnitEntity.setYfmsSalaryMny(detailList.stream().filter(p -> p.getYfmsSalaryMny() != null).map(PayableDetailEntity::getYfmsSalaryMny).reduce(BigDecimal.ZERO, BigDecimal::add));

			if (jsPayableDetailMap.containsKey(orgId)){
				List<JspayableDetailEntity> jsPayableDetailList = jsPayableDetailMap.get(orgId);
				payrollUnitEntity.setCriticalIllnessMny(jsPayableDetailList.stream().filter(p -> p.getCriticalIllnessMny() != null).map(JspayableDetailEntity::getCriticalIllnessMny).reduce(BigDecimal.ZERO, BigDecimal::add));
				payrollUnitEntity.setPersonEndowmentMny(jsPayableDetailList.stream().filter(p -> p.getPersonEndowmentMny() != null).map(JspayableDetailEntity::getPersonEndowmentMny).reduce(BigDecimal.ZERO, BigDecimal::add));
				payrollUnitEntity.setPersonMedicalMny(jsPayableDetailList.stream().filter(p -> p.getPersonMedicalMny() != null).map(JspayableDetailEntity::getPersonMedicalMny).reduce(BigDecimal.ZERO, BigDecimal::add));
				payrollUnitEntity.setPersonUnemploymentMny(jsPayableDetailList.stream().filter(p -> p.getPersonUnemploymentMny() != null).map(JspayableDetailEntity::getPersonUnemploymentMny).reduce(BigDecimal.ZERO, BigDecimal::add));
				payrollUnitEntity.setPersonHouseMny(jsPayableDetailList.stream().filter(p -> p.getPersonHouseMny() != null).map(JspayableDetailEntity::getPersonHouseMny).reduce(BigDecimal.ZERO, BigDecimal::add));
				//个税金额、专项扣除 个税计算单生效后回写 工资单提交前校验
			}

			// 实发=应发-个税-社保公积金-大病医保+应发免税
			payrollUnitEntity.setActualMny(ComputeUtil.safeAdd(ComputeUtil.safeSub(payrollUnitEntity.getYfSalaryMny(), payrollUnitEntity.getPersonHouseMny(), payrollUnitEntity.getCertificateMny()), payrollUnitEntity.getYfmsMny()));
			payrollUnitEntity.setAlreadyMny(BigDecimal.ZERO);
			payrollUnitEntity.setLeftMny(payrollUnitEntity.getActualMny());


            unitDetailList.add(payrollUnitEntity);
		}
		payrollEntity.setPayrollUnitList(unitDetailList);
		if (CollectionUtils.isNotEmpty(personDetailList)){
			payrollEntity.setPayableSumMny(personDetailList.stream().filter(p -> p.getYfSalaryMny() != null).map(PayrollPersonEntity::getYfSalaryMny).reduce(BigDecimal.ZERO, BigDecimal::add));
			payrollEntity.setActualSumMny(personDetailList.stream().filter(p -> p.getActualMny() != null).map(PayrollPersonEntity::getActualMny).reduce(BigDecimal.ZERO, BigDecimal::add));
			payrollEntity.setAlreadySumMny(BigDecimal.ZERO);
			payrollEntity.setLeftSumMny(payrollEntity.getActualSumMny());
		}
		logger.info("生成工资单数据：{}", JSONObject.toJSONString(payrollEntity));
		payrollService.saveOrUpdate(payrollEntity, false);


		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		JspayableEntity jspayableEntity = jspayableService.selectById(billId);
		TaxEntity taxEntity = taxService.getOne(new QueryWrapper<TaxEntity>().eq("yfgzjs_bill_id", jspayableEntity.getId()));
		if (taxEntity.getBillState() == 1 || taxEntity.getBillState() == 3 || taxEntity.getBillState() == 2 || taxEntity.getBillState() == 5){
			return CommonResponse.error("个税计算审批中或已生效，不能撤回！");
		}

		PayrollEntity payrollEntity = payrollService.getOne(new QueryWrapper<PayrollEntity>().eq("yfgzjs_bill_id", jspayableEntity.getId()));
		if (payrollEntity.getBillState() == 1 || payrollEntity.getBillState() == 3 || payrollEntity.getBillState() == 2 || payrollEntity.getBillState() == 5){
			return CommonResponse.error("工资单审批中或已生效，不能撤回！");
		}
		taxService.removeById(taxEntity.getId());
		taxModifyService.remove(new QueryWrapper<TaxModifyEntity>().eq("tax_bill_id", taxEntity.getId()));
		payrollService.removeById(payrollEntity.getId());

		return CommonResponse.success();
	}

}
