package com.ejianc.business.salary.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.salary.bean.*;
import com.ejianc.business.salary.service.IPayrollService;
import com.ejianc.business.salary.service.ITaxService;
import com.ejianc.framework.core.util.ComputeUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

@Service("tax") 
public class TaxBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private ITaxService taxService;
	@Autowired
	private IPayrollService payrollService;
	
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		TaxEntity taxEntity = taxService.selectById(billId);
//		单据生效之后把个税金额（累计应补/退税额）推送到工资单，同时更新下应发免税、应发计税
		Map<Long, TaxDetailEntity> taxDetailMap = taxEntity.getDetailList().stream().collect(Collectors.toMap(p -> p.getYfgzjsBillDetailId(), Function.identity()));
		PayrollEntity payrollEntity = payrollService.getOne(new QueryWrapper<PayrollEntity>().eq("yfgzjs_bill_id", taxEntity.getYfgzjsBillId()));
		payrollEntity = payrollService.selectById(payrollEntity.getId());
		List<PayrollPersonEntity> payrollPersonList = payrollEntity.getPayrollPersonList();
		for (PayrollPersonEntity payrollPersonEntity : payrollPersonList) {
			if (taxDetailMap.containsKey(payrollPersonEntity.getYfgzjsBillDetailId())){
				payrollPersonEntity.setTotalButuiTaxMny(taxDetailMap.get(payrollPersonEntity.getYfgzjsBillDetailId()).getTotalButuiTaxMny());
				payrollPersonEntity.setYfmsMny(taxDetailMap.get(payrollPersonEntity.getYfgzjsBillDetailId()).getYfmsMny());
				payrollPersonEntity.setYfmsSalaryMny(taxDetailMap.get(payrollPersonEntity.getYfgzjsBillDetailId()).getYfmsSalaryMny());
				payrollPersonEntity.setTotalZxkcMny(taxDetailMap.get(payrollPersonEntity.getYfgzjsBillDetailId()).getTotalZxkcMny());

				// 实发=应发-个税-养老-失业-医疗-公积金-大病医保+应发免税
				payrollPersonEntity.setActualMny(ComputeUtil.safeAdd(ComputeUtil.safeSub(payrollPersonEntity.getYfSalaryMny(), payrollPersonEntity.getPersonEndowmentMny(), payrollPersonEntity.getPersonUnemploymentMny(), payrollPersonEntity.getPersonMedicalMny(), payrollPersonEntity.getPersonHouseMny(), payrollPersonEntity.getCertificateMny()), payrollPersonEntity.getYfmsMny()));
				payrollPersonEntity.setLeftMny(payrollPersonEntity.getActualMny());
			}
		}
		payrollEntity.setActualSumMny(payrollPersonList.stream().filter(p -> p.getActualMny() != null).map(PayrollPersonEntity::getActualMny).reduce(BigDecimal.ZERO, BigDecimal::add));
		payrollEntity.setLeftSumMny(payrollEntity.getActualSumMny());

		payrollService.saveOrUpdate(payrollEntity, false);

		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		TaxEntity taxEntity = taxService.selectById(billId);
		PayrollEntity payrollEntity = payrollService.getOne(new QueryWrapper<PayrollEntity>().eq("yfgzjs_bill_id", taxEntity.getYfgzjsBillId()));
		if (payrollEntity.getBillState() == 1 || payrollEntity.getBillState() == 3 || payrollEntity.getBillState() == 2 || payrollEntity.getBillState() == 5){
			return CommonResponse.error("工资单审批中或已生效，不能撤回！");
		}
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
