package com.ejianc.business.salary.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.ejianc.business.salary.bean.JspayableAdjustEntity;
import com.ejianc.business.salary.bean.TaxDetailEntity;
import com.ejianc.business.salary.bean.TaxModifyEntity;
import com.ejianc.business.salary.service.IJspayableAdjustService;
import com.ejianc.business.salary.service.ITaxModifyService;
import com.ejianc.business.salary.vo.TaxDetailImportVO;
import com.ejianc.business.salary.vo.TaxDetailVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.poi.ss.formula.functions.T;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.salary.mapper.TaxMapper;
import com.ejianc.business.salary.bean.TaxEntity;
import com.ejianc.business.salary.service.ITaxService;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 个税计算-主实体
 * 
 * @author generator
 * 
 */
@Service("taxService")
public class TaxServiceImpl extends BaseServiceImpl<TaxMapper, TaxEntity> implements ITaxService{
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }

        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            List<TaxDetailImportVO> successList = new ArrayList<>();
            List<TaxDetailImportVO> errorList = new ArrayList<>();

            if (result != null && result.size() > 0) {
                if (result.get(0).size() != 18) {
                    throw new BusinessException("请按照导入模板导入数据");
                }
                if (result.size()>=1000){
                    throw new BusinessException("文件数据不能超过1000行，超过请分批次多次导入");
                }
                Long taxId = Long.valueOf(request.getParameter("taxId"));
                logger.info("taxId: {}",JSONObject.toJSONString(taxId));
                TaxEntity taxEntity = super.selectById(taxId);
                Map<String, TaxDetailEntity> personMap = taxEntity.getDetailList().stream().collect(Collectors.toMap(p -> p.getIdCard(), Function.identity()));
                logger.info("人员map: {}",JSONObject.toJSONString(personMap));

                for (int i = 1; i < result.size(); i++) {
                    StringBuilder errorMessage = new StringBuilder();
                    List<String> datas = result.get(i);
                    TaxDetailImportVO importVO = new TaxDetailImportVO();


                    //人员姓名
                    if (StringUtils.isBlank(datas.get(0))) {
                        errorMessage.append("[人员姓名为必填项]");
                    } else {
                        if (datas.get(0).length() > 50){
                            importVO.setErrorMessage("填写人员姓名长度为1~50字");
                        }else {
                            importVO.setDetailEmployeeName(datas.get(0));
                        }
                    }

                    //证件号码
                    if (StringUtils.isBlank(datas.get(1))) {
                        errorMessage.append("[证件号码为必填项]");
                    } else {
                        if (datas.get(1).length() > 20){
                            importVO.setErrorMessage("填写证件号码长度为1~20");
                        }else {
                            importVO.setIdCard(datas.get(1));
                            if (ObjectUtils.isEmpty(personMap.get(datas.get(1)))){
                                importVO.setErrorMessage("没有该身份证号的人员信息");
                            }else {
                                if (!importVO.getDetailEmployeeName().equals((personMap.get(datas.get(1))).getDetailEmployeeName())){
                                    importVO.setErrorMessage("人员和身份证信息不匹配");
                                }
                            }
                        }
                    }


                    //累计应缴税额
                    if (StringUtils.isNotBlank(datas.get(2))) {
                        try {
                            importVO.setTotalNeedTaxMny(new BigDecimal(datas.get(2)));
                        } catch (Exception e) {
                            errorMessage.append("[累计应缴税额必须为数字]");
                        }
                    }
                    //累计已缴税额
                    if (StringUtils.isNotBlank(datas.get(3))) {
                        try {
                            importVO.setTotalAlreadyTaxMny(new BigDecimal(datas.get(3)));
                        } catch (Exception e) {
                            errorMessage.append("[累计已缴税额必须为数字]");
                        }
                    }

                    //累计应补/退税额
                    if (StringUtils.isNotBlank(datas.get(4))) {
                        try {
                            importVO.setTotalButuiTaxMny(new BigDecimal(datas.get(4)));
                        } catch (Exception e) {
                            errorMessage.append("[累计应补/退税额必须为数字]");
                        }
                    }

                    //累计专项扣除
                    if (StringUtils.isNotBlank(datas.get(5))) {
                        try {
                            importVO.setTotalZxkcMny(new BigDecimal(datas.get(5)));
                        } catch (Exception e) {
                            errorMessage.append("[累计专项扣除必须为数字]");
                        }
                    }

                    //累计子女教育
                    if (StringUtils.isNotBlank(datas.get(6))) {
                        try {
                            importVO.setTotalZnjyMny(new BigDecimal(datas.get(6)));
                        } catch (Exception e) {
                            errorMessage.append("[累计子女教育必须为数字]");
                        }
                    }

                    //累计继续教育
                    if (StringUtils.isNotBlank(datas.get(7))) {
                        try {
                            importVO.setTotalJxjyMny(new BigDecimal(datas.get(7)));
                        } catch (Exception e) {
                            errorMessage.append("[累计继续教育必须为数字]");
                        }
                    }

                    //累计住房贷款利息
                    if (StringUtils.isNotBlank(datas.get(8))) {
                        try {
                            importVO.setTotalZfdkMny(new BigDecimal(datas.get(8)));
                        } catch (Exception e) {
                            errorMessage.append("[累计住房贷款利息必须为数字]");
                        }
                    }

                    //累计住房租金
                    if (StringUtils.isNotBlank(datas.get(9))) {
                        try {
                            importVO.setTotalZfzjMny(new BigDecimal(datas.get(9)));
                        } catch (Exception e) {
                            errorMessage.append("[累计住房租金必须为数字]");
                        }
                    }

                    //累计赡养老人
                    if (StringUtils.isNotBlank(datas.get(10))) {
                        try {
                            importVO.setTotalSylrMny(new BigDecimal(datas.get(10)));
                        } catch (Exception e) {
                            errorMessage.append("[累计赡养老人必须为数字]");
                        }
                    }

                    //累计3岁以下婴幼儿照护
                    if (StringUtils.isNotBlank(datas.get(11))) {
                        try {
                            importVO.setTotalYezhMny(new BigDecimal(datas.get(11)));
                        } catch (Exception e) {
                            errorMessage.append("[累计3岁以下婴幼儿照护必须为数字]");
                        }
                    }

                    //累计养老金
                    if (StringUtils.isNotBlank(datas.get(12))) {
                        try {
                            importVO.setTotalYljMny(new BigDecimal(datas.get(12)));
                        } catch (Exception e) {
                            errorMessage.append("[累计养老金必须为数字]");
                        }
                    }

                    //企业(职业)年金
                    if (StringUtils.isNotBlank(datas.get(13))) {
                        try {
                            importVO.setQynjMny(new BigDecimal(datas.get(13)));
                        } catch (Exception e) {
                            errorMessage.append("[企业(职业)年金必须为数字]");
                        }
                    }

                    //税延养老保险
                    if (StringUtils.isNotBlank(datas.get(14))) {
                        try {
                            importVO.setSyylMny(new BigDecimal(datas.get(14)));
                        } catch (Exception e) {
                            errorMessage.append("[税延养老保险必须为数字]");
                        }
                    }

                    //其他
                    if (StringUtils.isNotBlank(datas.get(15))) {
                        try {
                            importVO.setOtherMny(new BigDecimal(datas.get(15)));
                        } catch (Exception e) {
                            errorMessage.append("[其他必须为数字]");
                        }
                    }

                    //准予扣除的捐赠额
                    if (StringUtils.isNotBlank(datas.get(16))) {
                        try {
                            importVO.setZykcMny(new BigDecimal(datas.get(16)));
                        } catch (Exception e) {
                            errorMessage.append("[准予扣除的捐赠额必须为数字]");
                        }
                    }

                    //减免税额
                    if (StringUtils.isNotBlank(datas.get(16))) {
                        try {
                            importVO.setJmseMny(new BigDecimal(datas.get(16)));
                        } catch (Exception e) {
                            errorMessage.append("[减免税额必须为数字]");
                        }
                    }


                    importVO.setId(IdWorker.getId());


                    if (StringUtils.isBlank(errorMessage)) {
                        successList.add(importVO);
                    }else {
                        importVO.setErrorMessage(String.valueOf(errorMessage));
                        errorList.add(importVO);
                    }
                }
            }
            JSONObject json = new JSONObject();
            json.put("successList", successList);
            json.put("errorList", errorList);
            return CommonResponse.success(json);
        }
    }


}
