/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.salary.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.salary.bean.AcSetRelateEntity;
import com.ejianc.business.salary.bean.JspayableSourceEntity;
import com.ejianc.business.salary.bean.PayableDetailEntity;
import com.ejianc.business.salary.bean.TaxDetailEntity;
import com.ejianc.business.salary.bean.TaxEntity;
import com.ejianc.business.salary.bean.TaxModifyEntity;
import com.ejianc.business.salary.mapper.TaxModifyMapper;
import com.ejianc.business.salary.service.IAcSetRelateService;
import com.ejianc.business.salary.service.IJspayableSourceService;
import com.ejianc.business.salary.service.IPayableDetailService;
import com.ejianc.business.salary.service.ITaxModifyService;
import com.ejianc.business.salary.service.ITaxService;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="taxModifyService")
public class TaxModifyServiceImpl
extends BaseServiceImpl<TaxModifyMapper, TaxModifyEntity>
implements ITaxModifyService {
    @Autowired
    private ITaxService taxService;
    @Autowired
    private IJspayableSourceService jspayableSourceService;
    @Autowired
    private IAcSetRelateService acSetRelateService;
    @Autowired
    private IPayableDetailService payableDetailService;

    @Override
    public void initTaxModify(Long taxId) {
        TaxEntity taxEntity = (TaxEntity)((Object)this.taxService.selectById(taxId));
        List detailList = taxEntity.getDetailList().stream().filter(e -> StringUtils.isNotBlank((CharSequence)e.getYfgzjsBillDetailSourceType()) && "1".equals(e.getYfgzjsBillDetailSourceType())).collect(Collectors.toList());
        List acSetList = this.acSetRelateService.list((Wrapper)new QueryWrapper().in((Object)"org_id", (Collection)detailList.stream().map(TaxDetailEntity::getTaxHoldOrgId).collect(Collectors.toList())));
        Map acSetMap = acSetList.stream().collect(Collectors.toMap(p -> p.getOrgId(), Function.identity()));
        ArrayList<TaxModifyEntity> taxModifySaveList = new ArrayList<TaxModifyEntity>();
        for (TaxDetailEntity detail : detailList) {
            TaxModifyEntity taxModifyEntity = new TaxModifyEntity();
            taxModifyEntity.setTaxHoldOrgId(detail.getDetailOrgId());
            taxModifyEntity.setTaxHoldOrgCode(detail.getDetailOrgCode());
            taxModifyEntity.setTaxHoldOrgName(detail.getDetailOrgName());
            taxModifyEntity.setAcSet(null != acSetMap.get(detail.getDetailOrgId()) ? ((AcSetRelateEntity)((Object)acSetMap.get(detail.getDetailOrgId()))).getAcSet() : null);
            taxModifyEntity.setAcSetCode(null != acSetMap.get(detail.getDetailOrgId()) ? ((AcSetRelateEntity)((Object)acSetMap.get(detail.getDetailOrgId()))).getAcSetCode() : null);
            BigDecimal totalButuiTaxMny = detail.getTotalButuiTaxMny();
            taxModifyEntity.setTaxMny(totalButuiTaxMny);
            taxModifyEntity.setScale(new BigDecimal(1));
            taxModifyEntity.setTaxBillId(taxId);
            taxModifyEntity.setTaxBillDetailId(detail.getId());
            taxModifyEntity.setIsDefault("1");
            taxModifySaveList.add(taxModifyEntity);
        }
        super.saveOrUpdateBatch(taxModifySaveList, taxModifySaveList.size());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void taxModifyApportion(Long taxId) {
        super.remove((Wrapper)new QueryWrapper().eq((Object)"tax_bill_id", (Object)taxId));
        TaxEntity taxEntity = (TaxEntity)((Object)this.taxService.selectById(taxId));
        List detailList = taxEntity.getDetailList().stream().filter(e -> StringUtils.isNotBlank((CharSequence)e.getYfgzjsBillDetailSourceType()) && "1".equals(e.getYfgzjsBillDetailSourceType())).collect(Collectors.toList());
        List idCardList = detailList.stream().map(TaxDetailEntity::getIdCard).collect(Collectors.toList());
        List sourceEntityList = this.jspayableSourceService.list((Wrapper)((QueryWrapper)new QueryWrapper().in((Object)"id_card", idCardList)).eq((Object)"month", (Object)taxEntity.getMonth()));
        List payableDetailList = this.payableDetailService.list((Wrapper)new QueryWrapper().in((Object)"id", (Collection)sourceEntityList.stream().map(JspayableSourceEntity::getSourceDetailId).collect(Collectors.toList())));
        Map<String, List<PayableDetailEntity>> payableDetailMap = payableDetailList.stream().collect(Collectors.groupingBy(PayableDetailEntity::getIdCard));
        List acSetList = this.acSetRelateService.list((Wrapper)new QueryWrapper().in((Object)"org_id", (Collection)payableDetailList.stream().map(PayableDetailEntity::getGzffOrgId).collect(Collectors.toList())));
        Map acSetMap = acSetList.stream().collect(Collectors.toMap(p -> p.getOrgId(), Function.identity()));
        ArrayList taxModifySaveList = new ArrayList();
        for (TaxDetailEntity taxDetailEntity : detailList) {
            List<PayableDetailEntity> payableDetailEntityList = payableDetailMap.get(taxDetailEntity.getIdCard());
            if (!CollectionUtils.isNotEmpty(payableDetailEntityList)) continue;
            ArrayList<TaxModifyEntity> taxModifyList = new ArrayList<TaxModifyEntity>();
            BigDecimal totalButuiTaxMny = taxDetailEntity.getTotalButuiTaxMny();
            BigDecimal totalYfSalaryMny = payableDetailEntityList.stream().filter(p -> p.getYfSalaryMny() != null).map(PayableDetailEntity::getYfSalaryMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            int count = 0;
            for (PayableDetailEntity entity : payableDetailEntityList) {
                TaxModifyEntity taxModifyEntity = new TaxModifyEntity();
                taxModifyEntity.setTaxHoldOrgId(entity.getGzffOrgId());
                taxModifyEntity.setTaxHoldOrgCode(entity.getGzffOrgCode());
                taxModifyEntity.setTaxHoldOrgName(entity.getGzffOrgName());
                taxModifyEntity.setAcSet(acSetMap.containsKey(entity.getGzffOrgId()) ? ((AcSetRelateEntity)((Object)acSetMap.get(entity.getGzffOrgId()))).getAcSet() : null);
                taxModifyEntity.setAcSetCode(acSetMap.containsKey(entity.getGzffOrgId()) ? ((AcSetRelateEntity)((Object)acSetMap.get(entity.getGzffOrgId()))).getAcSetCode() : null);
                BigDecimal scale = ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)entity.getYfSalaryMny(), (BigDecimal)totalYfSalaryMny), (BigDecimal)new BigDecimal(100));
                taxModifyEntity.setScale(scale);
                if (payableDetailEntityList.size() == 1 || payableDetailEntityList.size() != ++count) {
                    taxModifyEntity.setTaxMny(ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)totalButuiTaxMny, (BigDecimal)taxModifyEntity.getScale()), (BigDecimal)new BigDecimal(100)));
                } else {
                    taxModifyEntity.setTaxMny(ComputeUtil.safeSub((BigDecimal)totalButuiTaxMny, (BigDecimal)taxModifyList.stream().filter(p -> p.getTaxMny() != null).map(TaxModifyEntity::getTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add)));
                }
                taxModifyEntity.setTaxBillId(taxId);
                taxModifyEntity.setTaxBillDetailId(taxDetailEntity.getId());
                taxModifyEntity.setIsDefault(entity.getDetailOrgId().toString().equals(taxDetailEntity.getDetailOrgId().toString()) ? "1" : "2");
                taxModifyList.add(taxModifyEntity);
            }
            taxModifySaveList.addAll(taxModifyList);
        }
        super.saveOrUpdateBatch(taxModifySaveList, taxModifySaveList.size());
    }
}

