package com.ejianc.business.salary.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.salary.bean.PayableDetailEntity;
/**
 * 应发工资上传
 * 
 * @author generator
 * 
 */
 @TableName("ejc_salary_payable")
public class PayableEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="org_id")
    private Long orgId; // 组织id
    @TableField(value="org_name")
    private String orgName; // 组织
    @TableField(value="org_code")
    private String orgCode; // 组织编码
    @TableField(value="month")
    private Date month; // 月份
    @TableField(value="ac_set")
    private String acSet; // 账套
    @TableField(value="ac_set_code")
    private String acSetCode; // 账套编码
    @TableField(value="payable_sum_mny")
    private BigDecimal payableSumMny; // 应发工资汇总
    @TableField(value="org_sum_mny")
    private BigDecimal orgSumMny; // 本单位累计金额
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value="collect_status")
    private Integer collectStatus; // 汇总状态（0-未汇总，1--已汇总,2-被驳回）

    @TableField(value="corp_id")
    private Long corpId; // 组织id
    @TableField(value="corp_name")
    private String corpName; // 组织
    @TableField(value="corp_code")
    private String corpCode; // 组织编码

    @TableField(value="payable_name")
    private String payableName; // 工资单名称

    
    @TableField(exist=false)
    @SubEntity(serviceName="payableDetailService",pidName = "payableId")
    private List<PayableDetailEntity> payableDetailList = new ArrayList<>(); // 应发工资上传明细

    public Long getCorpId() {
        return corpId;
    }

    public void setCorpId(Long corpId) {
        this.corpId = corpId;
    }

    public String getCorpName() {
        return corpName;
    }

    public void setCorpName(String corpName) {
        this.corpName = corpName;
    }

    public String getCorpCode() {
        return corpCode;
    }

    public void setCorpCode(String corpCode) {
        this.corpCode = corpCode;
    }

    public String getPayableName() {
        return payableName;
    }

    public void setPayableName(String payableName) {
        this.payableName = payableName;
    }

    public Integer getCollectStatus() {
        return collectStatus;
    }

    public void setCollectStatus(Integer collectStatus) {
        this.collectStatus = collectStatus;
    }

    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public Date getMonth() {
        return month;
    }

    public void setMonth(Date month) {
        this.month = month;
    }

    public String getAcSet() {
        return acSet;
    }

    public void setAcSet(String acSet) {
        this.acSet = acSet;
    }
    public String getAcSetCode() {
        return acSetCode;
    }

    public void setAcSetCode(String acSetCode) {
        this.acSetCode = acSetCode;
    }
    public BigDecimal getPayableSumMny() {
        return payableSumMny;
    }

    public void setPayableSumMny(BigDecimal payableSumMny) {
        this.payableSumMny = payableSumMny;
    }
    public BigDecimal getOrgSumMny() {
        return orgSumMny;
    }

    public void setOrgSumMny(BigDecimal orgSumMny) {
        this.orgSumMny = orgSumMny;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    

    public List<PayableDetailEntity> getPayableDetailList() {
        return payableDetailList;
    }

    public void setPayableDetailList(List<PayableDetailEntity> payableDetailList) {
        this.payableDetailList = payableDetailList;
    }
}
