package com.ejianc.business.salary.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.salary.bean.PayrollPersonEntity;
import com.ejianc.business.salary.bean.PayrollUnitEntity;
/**
 * 工资单-主实体
 * 
 * @author generator
 * 
 */
 @TableName("ejc_salary_payroll")
public class PayrollEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="payable_sum_mny")
    private BigDecimal payableSumMny; // 累计应发工资
    @TableField(value="actual_sum_mny")
    private BigDecimal actualSumMny; // 累计实发工资
    @TableField(value="already_sum_mny")
    private BigDecimal alreadySumMny; // 累计已发工资
    @TableField(value="left_sum_mny")
    private BigDecimal leftSumMny; // 累计剩余可发工资
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value="month")
    private Date month; // 月份
    @TableField(value="yfgzjs_bill_id")
    private Long yfgzjsBillId; // 应发工资计算单据id
    @TableField(value="yfgzjs_bill_code")
    private String yfgzjsBillCode; // 应发工资计算单据编码
    @TableField(value="tax_bill_id")
    private Long taxBillId; // 个税计算单据id

    
    @TableField(exist=false)
    @SubEntity(serviceName="payrollPersonService", pidName = "payrollId")//此处有pid="xxx"，默认值pid="pid"
    private List<PayrollPersonEntity> payrollPersonList = new ArrayList<>(); // 工资单-人员明细
    @TableField(exist=false)
    @SubEntity(serviceName="payrollUnitService", pidName = "payrollId")//此处有pid="xxx"，默认值pid="pid"
    private List<PayrollUnitEntity> payrollUnitList = new ArrayList<>(); // 工资单-单位明细
    

    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public BigDecimal getPayableSumMny() {
        return payableSumMny;
    }

    public void setPayableSumMny(BigDecimal payableSumMny) {
        this.payableSumMny = payableSumMny;
    }
    public BigDecimal getActualSumMny() {
        return actualSumMny;
    }

    public void setActualSumMny(BigDecimal actualSumMny) {
        this.actualSumMny = actualSumMny;
    }
    public BigDecimal getAlreadySumMny() {
        return alreadySumMny;
    }

    public void setAlreadySumMny(BigDecimal alreadySumMny) {
        this.alreadySumMny = alreadySumMny;
    }
    public BigDecimal getLeftSumMny() {
        return leftSumMny;
    }

    public void setLeftSumMny(BigDecimal leftSumMny) {
        this.leftSumMny = leftSumMny;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Date getMonth() {
        return month;
    }

    public void setMonth(Date month) {
        this.month = month;
    }
    public Long getYfgzjsBillId() {
        return yfgzjsBillId;
    }

    public void setYfgzjsBillId(Long yfgzjsBillId) {
        this.yfgzjsBillId = yfgzjsBillId;
    }
    public String getYfgzjsBillCode() {
        return yfgzjsBillCode;
    }

    public void setYfgzjsBillCode(String yfgzjsBillCode) {
        this.yfgzjsBillCode = yfgzjsBillCode;
    }
    
    public List<PayrollPersonEntity> getPayrollPersonList() {
        return payrollPersonList;
    }

    public void setPayrollPersonList(List<PayrollPersonEntity> payrollPersonList) {
        this.payrollPersonList = payrollPersonList;
    }
    public List<PayrollUnitEntity> getPayrollUnitList() {
        return payrollUnitList;
    }

    public void setPayrollUnitList(List<PayrollUnitEntity> payrollUnitList) {
        this.payrollUnitList = payrollUnitList;
    }

    public Long getTaxBillId() {
        return taxBillId;
    }

    public void setTaxBillId(Long taxBillId) {
        this.taxBillId = taxBillId;
    }
}
