package com.ejianc.business.salary.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 工资单-人员明细
 * 
 * @author generator
 * 
 */
 @TableName("ejc_salary_payroll_person")
public class PayrollPersonEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="payroll_id")
    private Long payrollId; // 主表id
    @TableField(value="detail_employee_id")
    private Long detailEmployeeId; // 员工主键
    @TableField(value="detail_employee_name")
    private String detailEmployeeName; // 员工名称
    @TableField(value="detail_employee_code")
    private String detailEmployeeCode; // 员工编码
    @TableField(value="id_card")
    private String idCard; // 证件号码
    @TableField(value="job_type")
    private String jobType; // 岗位性质
    @TableField(value="detail_org_id")
    private Long detailOrgId; // 单位id
    @TableField(value="detail_org_name")
    private String detailOrgName; // 单位名称
    @TableField(value="detail_org_code")
    private String detailOrgCode; // 单位编码
    @TableField(value="job")
    private String job; // 岗位
    @TableField(value="dept")
    private String dept; // 部门
    @TableField(value="job_level")
    private String jobLevel; // 岗级
    @TableField(value="sbjn_org_name")
    private String sbjnOrgName; // 社保缴纳单位名称
    @TableField(value="sbjn_org_code")
    private String sbjnOrgCode; // 社保缴纳单位编码
    @TableField(value="is_move")
    private String isMove; // 本月是否发生调动：1是,2-否

    //这仨字段这里应该没用
    @TableField(value="sbcd_org_id")
    private Long sbcdOrgId; // 社保承担单位id
    @TableField(value="sbcd_org_name")
    private String sbcdOrgName; // 社保承担单位名称
    @TableField(value="sbcd_org_code")
    private String sbcdOrgCode; // 社保承担单位编码
    @TableField(value="need_attendance_days")
    private BigDecimal needAttendanceDays; // 应出勤天数
    @TableField(value="actual_attendance_days")
    private BigDecimal actualAttendanceDays; // 实际出勤天数

    @TableField(value="sbcd_bill_id")
    private Long sbcdBillId; // 社保承担主单据id
    @TableField(value="gzff_org_id")
    private Long gzffOrgId; // 工资发放单位id
    @TableField(value="gzff_org_name")
    private String gzffOrgName; // 工资发放单位名称
    @TableField(value="gzff_org_code")
    private String gzffOrgCode; // 工资发放单位编码
    @TableField(value="un_write_off_mny")
    private BigDecimal unWriteOffMny; // 截止当前未核销金额
    @TableField(value="write_off_mny")
    private BigDecimal writeOffMny; // 本次核销金额
    @TableField(value="yfjs_mny")
    private BigDecimal yfjsMny; // 应发计税
    @TableField(value="yfms_mny")
    private BigDecimal yfmsMny; // 应发免税
    @TableField(value="job_mny")
    private BigDecimal jobMny; // 岗位工资
    @TableField(value="performance_mny")
    private BigDecimal performanceMny; // 绩效工资
    @TableField(value="work_year_mny")
    private BigDecimal workYearMny; // 司龄补贴
    @TableField(value="work_type_mny")
    private BigDecimal workTypeMny; // 职称补贴
    @TableField(value="certificate_mny")
    private BigDecimal certificateMny; // 证书补贴
    @TableField(value="travel_mny")
    private BigDecimal travelMny; // 派驻补贴
    @TableField(value="traffic_mny")
    private BigDecimal trafficMny; // 交通补贴
    @TableField(value="meal_mny")
    private BigDecimal mealMny; // 餐补
    @TableField(value="benefit_mny")
    private BigDecimal benefitMny; // 福利费
    @TableField(value="holiday_mny")
    private BigDecimal holidayMny; // 过节费
    @TableField(value="year_end_mny")
    private BigDecimal yearEndMny; // 年终奖
    @TableField(value="overtime_mny")
    private BigDecimal overtimeMny; // 加班费
    @TableField(value="add_mny")
    private BigDecimal addMny; // 补款
    @TableField(value="button_mny")
    private BigDecimal buttonMny; // 扣款
    @TableField(value="salary_mny")
    private BigDecimal salaryMny; // 工资合计
    @TableField(value="yf_salary_mny")
    private BigDecimal yfSalaryMny; // 应发工资
    @TableField(value="yfms_salary_mny")
    private BigDecimal yfmsSalaryMny; // 应发+免税
    @TableField(value="person_endowment_mny")
    private BigDecimal personEndowmentMny; // 个人养老金额
    @TableField(value="person_medical_mny")
    private BigDecimal personMedicalMny; // 个人医疗金额
    @TableField(value="person_unemployment_mny")
    private BigDecimal personUnemploymentMny; // 个人失业金额
    @TableField(value="person_house_mny")
    private BigDecimal personHouseMny; // 个人公积金
    @TableField(value="sybx_mny")
    private BigDecimal sybxMny; // 商业健康保险（大病医保）
    @TableField(value="total_butui_tax_mny")
    private BigDecimal totalButuiTaxMny; // 个税金额（累计应补/退税额）
    @TableField(value="total_zxkc_mny")
    private BigDecimal totalZxkcMny; // 累计专项扣除
    @TableField(value="actual_mny")
    private BigDecimal actualMny; // 实发工资
    @TableField(value="already_mny")
    private BigDecimal alreadyMny; // 已发工资
    @TableField(value="left_mny")
    private BigDecimal leftMny; // 剩余可发放工资
    @TableField(value="yfgzjs_bill_id")
    private Long yfgzjsBillId; // 来源应发工资计算主表id
    @TableField(value="yfgzjs_bill_detail_id")
    private Long yfgzjsBillDetailId; // 来源应发工资计算子表id
    @TableField(value="tax_bill_id")
    private Long taxBillId; // 个税计算主单据id
    @TableField(value="tax_bill_detail_id")
    private Long taxBillDetailId; // 个税计算子表id
    @TableField(value="memo")
    private String memo; // 备注


    public BigDecimal getNeedAttendanceDays() {
        return needAttendanceDays;
    }

    public void setNeedAttendanceDays(BigDecimal needAttendanceDays) {
        this.needAttendanceDays = needAttendanceDays;
    }

    public BigDecimal getActualAttendanceDays() {
        return actualAttendanceDays;
    }

    public void setActualAttendanceDays(BigDecimal actualAttendanceDays) {
        this.actualAttendanceDays = actualAttendanceDays;
    }

    public Long getPayrollId() {
        return payrollId;
    }

    public void setPayrollId(Long payrollId) {
        this.payrollId = payrollId;
    }
    public Long getDetailEmployeeId() {
        return detailEmployeeId;
    }

    public void setDetailEmployeeId(Long detailEmployeeId) {
        this.detailEmployeeId = detailEmployeeId;
    }
    public String getDetailEmployeeName() {
        return detailEmployeeName;
    }

    public void setDetailEmployeeName(String detailEmployeeName) {
        this.detailEmployeeName = detailEmployeeName;
    }
    public String getDetailEmployeeCode() {
        return detailEmployeeCode;
    }

    public void setDetailEmployeeCode(String detailEmployeeCode) {
        this.detailEmployeeCode = detailEmployeeCode;
    }
    public String getIdCard() {
        return idCard;
    }

    public void setIdCard(String idCard) {
        this.idCard = idCard;
    }
    public String getJobType() {
        return jobType;
    }

    public void setJobType(String jobType) {
        this.jobType = jobType;
    }
    public Long getDetailOrgId() {
        return detailOrgId;
    }

    public void setDetailOrgId(Long detailOrgId) {
        this.detailOrgId = detailOrgId;
    }
    public String getDetailOrgName() {
        return detailOrgName;
    }

    public void setDetailOrgName(String detailOrgName) {
        this.detailOrgName = detailOrgName;
    }
    public String getDetailOrgCode() {
        return detailOrgCode;
    }

    public void setDetailOrgCode(String detailOrgCode) {
        this.detailOrgCode = detailOrgCode;
    }
    public String getJob() {
        return job;
    }

    public void setJob(String job) {
        this.job = job;
    }
    public String getDept() {
        return dept;
    }

    public void setDept(String dept) {
        this.dept = dept;
    }
    public String getJobLevel() {
        return jobLevel;
    }

    public void setJobLevel(String jobLevel) {
        this.jobLevel = jobLevel;
    }
    public String getSbjnOrgName() {
        return sbjnOrgName;
    }

    public void setSbjnOrgName(String sbjnOrgName) {
        this.sbjnOrgName = sbjnOrgName;
    }
    public String getSbjnOrgCode() {
        return sbjnOrgCode;
    }

    public void setSbjnOrgCode(String sbjnOrgCode) {
        this.sbjnOrgCode = sbjnOrgCode;
    }
    public String getIsMove() {
        return isMove;
    }

    public void setIsMove(String isMove) {
        this.isMove = isMove;
    }
    public Long getSbcdOrgId() {
        return sbcdOrgId;
    }

    public void setSbcdOrgId(Long sbcdOrgId) {
        this.sbcdOrgId = sbcdOrgId;
    }
    public String getSbcdOrgName() {
        return sbcdOrgName;
    }

    public void setSbcdOrgName(String sbcdOrgName) {
        this.sbcdOrgName = sbcdOrgName;
    }
    public String getSbcdOrgCode() {
        return sbcdOrgCode;
    }

    public void setSbcdOrgCode(String sbcdOrgCode) {
        this.sbcdOrgCode = sbcdOrgCode;
    }
    public Long getGzffOrgId() {
        return gzffOrgId;
    }

    public void setGzffOrgId(Long gzffOrgId) {
        this.gzffOrgId = gzffOrgId;
    }
    public String getGzffOrgName() {
        return gzffOrgName;
    }

    public void setGzffOrgName(String gzffOrgName) {
        this.gzffOrgName = gzffOrgName;
    }
    public String getGzffOrgCode() {
        return gzffOrgCode;
    }

    public void setGzffOrgCode(String gzffOrgCode) {
        this.gzffOrgCode = gzffOrgCode;
    }
    public BigDecimal getUnWriteOffMny() {
        return unWriteOffMny;
    }

    public void setUnWriteOffMny(BigDecimal unWriteOffMny) {
        this.unWriteOffMny = unWriteOffMny;
    }
    public BigDecimal getWriteOffMny() {
        return writeOffMny;
    }

    public void setWriteOffMny(BigDecimal writeOffMny) {
        this.writeOffMny = writeOffMny;
    }
    public BigDecimal getYfjsMny() {
        return yfjsMny;
    }

    public void setYfjsMny(BigDecimal yfjsMny) {
        this.yfjsMny = yfjsMny;
    }
    public BigDecimal getYfmsMny() {
        return yfmsMny;
    }

    public void setYfmsMny(BigDecimal yfmsMny) {
        this.yfmsMny = yfmsMny;
    }
    public BigDecimal getJobMny() {
        return jobMny;
    }

    public void setJobMny(BigDecimal jobMny) {
        this.jobMny = jobMny;
    }
    public BigDecimal getPerformanceMny() {
        return performanceMny;
    }

    public void setPerformanceMny(BigDecimal performanceMny) {
        this.performanceMny = performanceMny;
    }
    public BigDecimal getWorkYearMny() {
        return workYearMny;
    }

    public void setWorkYearMny(BigDecimal workYearMny) {
        this.workYearMny = workYearMny;
    }
    public BigDecimal getWorkTypeMny() {
        return workTypeMny;
    }

    public void setWorkTypeMny(BigDecimal workTypeMny) {
        this.workTypeMny = workTypeMny;
    }
    public BigDecimal getCertificateMny() {
        return certificateMny;
    }

    public void setCertificateMny(BigDecimal certificateMny) {
        this.certificateMny = certificateMny;
    }
    public BigDecimal getTravelMny() {
        return travelMny;
    }

    public void setTravelMny(BigDecimal travelMny) {
        this.travelMny = travelMny;
    }
    public BigDecimal getTrafficMny() {
        return trafficMny;
    }

    public void setTrafficMny(BigDecimal trafficMny) {
        this.trafficMny = trafficMny;
    }
    public BigDecimal getMealMny() {
        return mealMny;
    }

    public void setMealMny(BigDecimal mealMny) {
        this.mealMny = mealMny;
    }
    public BigDecimal getBenefitMny() {
        return benefitMny;
    }

    public void setBenefitMny(BigDecimal benefitMny) {
        this.benefitMny = benefitMny;
    }
    public BigDecimal getHolidayMny() {
        return holidayMny;
    }

    public void setHolidayMny(BigDecimal holidayMny) {
        this.holidayMny = holidayMny;
    }
    public BigDecimal getYearEndMny() {
        return yearEndMny;
    }

    public void setYearEndMny(BigDecimal yearEndMny) {
        this.yearEndMny = yearEndMny;
    }
    public BigDecimal getOvertimeMny() {
        return overtimeMny;
    }

    public void setOvertimeMny(BigDecimal overtimeMny) {
        this.overtimeMny = overtimeMny;
    }
    public BigDecimal getAddMny() {
        return addMny;
    }

    public void setAddMny(BigDecimal addMny) {
        this.addMny = addMny;
    }
    public BigDecimal getButtonMny() {
        return buttonMny;
    }

    public void setButtonMny(BigDecimal buttonMny) {
        this.buttonMny = buttonMny;
    }
    public BigDecimal getSalaryMny() {
        return salaryMny;
    }

    public void setSalaryMny(BigDecimal salaryMny) {
        this.salaryMny = salaryMny;
    }
    public BigDecimal getYfSalaryMny() {
        return yfSalaryMny;
    }

    public void setYfSalaryMny(BigDecimal yfSalaryMny) {
        this.yfSalaryMny = yfSalaryMny;
    }
    public BigDecimal getYfmsSalaryMny() {
        return yfmsSalaryMny;
    }

    public void setYfmsSalaryMny(BigDecimal yfmsSalaryMny) {
        this.yfmsSalaryMny = yfmsSalaryMny;
    }
    public BigDecimal getPersonEndowmentMny() {
        return personEndowmentMny;
    }

    public void setPersonEndowmentMny(BigDecimal personEndowmentMny) {
        this.personEndowmentMny = personEndowmentMny;
    }
    public BigDecimal getPersonMedicalMny() {
        return personMedicalMny;
    }

    public void setPersonMedicalMny(BigDecimal personMedicalMny) {
        this.personMedicalMny = personMedicalMny;
    }
    public BigDecimal getPersonUnemploymentMny() {
        return personUnemploymentMny;
    }

    public void setPersonUnemploymentMny(BigDecimal personUnemploymentMny) {
        this.personUnemploymentMny = personUnemploymentMny;
    }
    public BigDecimal getPersonHouseMny() {
        return personHouseMny;
    }

    public void setPersonHouseMny(BigDecimal personHouseMny) {
        this.personHouseMny = personHouseMny;
    }
    public BigDecimal getSybxMny() {
        return sybxMny;
    }

    public void setSybxMny(BigDecimal sybxMny) {
        this.sybxMny = sybxMny;
    }
    public BigDecimal getTotalButuiTaxMny() {
        return totalButuiTaxMny;
    }

    public void setTotalButuiTaxMny(BigDecimal totalButuiTaxMny) {
        this.totalButuiTaxMny = totalButuiTaxMny;
    }
    public BigDecimal getTotalZxkcMny() {
        return totalZxkcMny;
    }

    public void setTotalZxkcMny(BigDecimal totalZxkcMny) {
        this.totalZxkcMny = totalZxkcMny;
    }
    public BigDecimal getActualMny() {
        return actualMny;
    }

    public void setActualMny(BigDecimal actualMny) {
        this.actualMny = actualMny;
    }
    public BigDecimal getAlreadyMny() {
        return alreadyMny;
    }

    public void setAlreadyMny(BigDecimal alreadyMny) {
        this.alreadyMny = alreadyMny;
    }
    public BigDecimal getLeftMny() {
        return leftMny;
    }

    public void setLeftMny(BigDecimal leftMny) {
        this.leftMny = leftMny;
    }
    public Long getYfgzjsBillId() {
        return yfgzjsBillId;
    }

    public void setYfgzjsBillId(Long yfgzjsBillId) {
        this.yfgzjsBillId = yfgzjsBillId;
    }
    public Long getYfgzjsBillDetailId() {
        return yfgzjsBillDetailId;
    }

    public void setYfgzjsBillDetailId(Long yfgzjsBillDetailId) {
        this.yfgzjsBillDetailId = yfgzjsBillDetailId;
    }
    public Long getTaxBillId() {
        return taxBillId;
    }

    public void setTaxBillId(Long taxBillId) {
        this.taxBillId = taxBillId;
    }
    public Long getTaxBillDetailId() {
        return taxBillDetailId;
    }

    public void setTaxBillDetailId(Long taxBillDetailId) {
        this.taxBillDetailId = taxBillDetailId;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Long getSbcdBillId() {
        return sbcdBillId;
    }

    public void setSbcdBillId(Long sbcdBillId) {
        this.sbcdBillId = sbcdBillId;
    }
}
