package com.ejianc.business.salary.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 个税计算-人员明细
 * 
 * @author generator
 * 
 */
 @TableName("ejc_salary_tax_detail")
public class TaxDetailEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="tax_id")
    private Long taxId; // 主表id
    @TableField(value="detail_employee_id")
    private Long detailEmployeeId; // 员工主键
    @TableField(value="detail_employee_name")
    private String detailEmployeeName; // 员工名称
    @TableField(value="detail_employee_code")
    private String detailEmployeeCode; // 员工编码
    @TableField(value="id_card")
    private String idCard; // 证件号码
    @TableField(value="detail_org_id")
    private Long detailOrgId; // 单位id
    @TableField(value="detail_org_name")
    private String detailOrgName; // 单位名称
    @TableField(value="detail_org_code")
    private String detailOrgCode; // 单位编码
    @TableField(value="job_type")
    private String jobType; // 岗位性质
    @TableField(value="job")
    private String job; // 岗位
    @TableField(value="dept")
    private String dept; // 部门
    @TableField(value="job_level")
    private String jobLevel; // 岗级
    @TableField(value="sbjn_org_name")
    private String sbjnOrgName; // 社保缴纳单位名称
    @TableField(value="sbjn_org_code")
    private String sbjnOrgCode; // 社保缴纳单位编码
    @TableField(value="yfjs_mny")
    private BigDecimal yfjsMny; // 应发计税
    @TableField(value="yfms_mny")
    private BigDecimal yfmsMny; // 应发免税
    @TableField(value="yf_salary_mny")
    private BigDecimal yfSalaryMny; // 应发工资
    @TableField(value="yfms_salary_mny")
    private BigDecimal yfmsSalaryMny; // 本期收入（应发+免税）
    @TableField(value="person_endowment_mny")
    private BigDecimal personEndowmentMny; // 个人养老金额
    @TableField(value="person_medical_mny")
    private BigDecimal personMedicalMny; // 个人医疗金额
    @TableField(value="person_unemployment_mny")
    private BigDecimal personUnemploymentMny; // 个人失业金额
    @TableField(value="person_house_mny")
    private BigDecimal personHouseMny; // 个人公积金
    @TableField(value="total_need_tax_mny")
    private BigDecimal totalNeedTaxMny; // 累计应缴税额
    @TableField(value="total_already_tax_mny")
    private BigDecimal totalAlreadyTaxMny; // 累计已缴税额
    @TableField(value="total_butui_tax_mny")
    private BigDecimal totalButuiTaxMny; // 累计应补/退税额（个税金额）
    @TableField(value="tax_modify_bill_id")
    private Long taxModifyBillId; // 个税调整主单据id
    @TableField(value="tax_hold_org_id")
    private Long taxHoldOrgId; // 个税承担单位id
    @TableField(value="tax_hold_org_name")
    private String taxHoldOrgName; // 个税承担单位名称
    @TableField(value="tax_hold_org_code")
    private String taxHoldOrgCode; // 个税承担单位编码
    @TableField(value="total_zxkc_mny")
    private BigDecimal totalZxkcMny; // 累计专项扣除
    @TableField(value="total_znjy_mny")
    private BigDecimal totalZnjyMny; // 累计子女教育
    @TableField(value="total_jxjy_mny")
    private BigDecimal totalJxjyMny; // 累计继续教育
    @TableField(value="total_zfdk_mny")
    private BigDecimal totalZfdkMny; // 累计住房贷款利息
    @TableField(value="total_zfzj_mny")
    private BigDecimal totalZfzjMny; // 累计住房租金
    @TableField(value="total_sylr_mny")
    private BigDecimal totalSylrMny; // 累计赡养老人
    @TableField(value="total_yezh_mny")
    private BigDecimal totalYezhMny; // 累计3岁以下婴幼儿照护
    @TableField(value="total_ylj_mny")
    private BigDecimal totalYljMny; // 累计养老金
    @TableField(value="qynj_mny")
    private BigDecimal qynjMny; // 企业(职业)年金
    @TableField(value="sybx_mny")
    private BigDecimal sybxMny; // 商业健康保险（大病医保）
    @TableField(value="syyl_mny")
    private BigDecimal syylMny; // 税延养老保险
    @TableField(value="other_mny")
    private BigDecimal otherMny; // 其他
    @TableField(value="zykc_mny")
    private BigDecimal zykcMny; // 准予扣除的捐赠额
    @TableField(value="jmse_mny")
    private BigDecimal jmseMny; // 减免税额
    @TableField(value="is_adjust")
    private String isAdjust; // 调整项 是否调整 1是,2-否
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="yfgzjs_bill_id")
    private Long yfgzjsBillId; // 来源应发工资计算主表id
    @TableField(value="yfgzjs_bill_detail_id")
    private Long yfgzjsBillDetailId; // 来源应发工资计算子表id
    @TableField(value="yfgzjs_bill_detail_source_type")
    private String yfgzjsBillDetailSourceType; // 来源应发工资计算子表来源类型 1-汇总 2-新增


    public Long getTaxId() {
        return taxId;
    }

    public void setTaxId(Long taxId) {
        this.taxId = taxId;
    }
    public Long getDetailEmployeeId() {
        return detailEmployeeId;
    }

    public void setDetailEmployeeId(Long detailEmployeeId) {
        this.detailEmployeeId = detailEmployeeId;
    }
    public String getDetailEmployeeName() {
        return detailEmployeeName;
    }

    public void setDetailEmployeeName(String detailEmployeeName) {
        this.detailEmployeeName = detailEmployeeName;
    }
    public String getDetailEmployeeCode() {
        return detailEmployeeCode;
    }

    public void setDetailEmployeeCode(String detailEmployeeCode) {
        this.detailEmployeeCode = detailEmployeeCode;
    }
    public String getIdCard() {
        return idCard;
    }

    public void setIdCard(String idCard) {
        this.idCard = idCard;
    }
    public Long getDetailOrgId() {
        return detailOrgId;
    }

    public void setDetailOrgId(Long detailOrgId) {
        this.detailOrgId = detailOrgId;
    }
    public String getDetailOrgName() {
        return detailOrgName;
    }

    public void setDetailOrgName(String detailOrgName) {
        this.detailOrgName = detailOrgName;
    }
    public String getDetailOrgCode() {
        return detailOrgCode;
    }

    public void setDetailOrgCode(String detailOrgCode) {
        this.detailOrgCode = detailOrgCode;
    }
    public String getJobType() {
        return jobType;
    }

    public void setJobType(String jobType) {
        this.jobType = jobType;
    }
    public String getJob() {
        return job;
    }

    public void setJob(String job) {
        this.job = job;
    }
    public String getDept() {
        return dept;
    }

    public void setDept(String dept) {
        this.dept = dept;
    }
    public String getJobLevel() {
        return jobLevel;
    }

    public void setJobLevel(String jobLevel) {
        this.jobLevel = jobLevel;
    }
    public String getSbjnOrgName() {
        return sbjnOrgName;
    }

    public void setSbjnOrgName(String sbjnOrgName) {
        this.sbjnOrgName = sbjnOrgName;
    }
    public String getSbjnOrgCode() {
        return sbjnOrgCode;
    }

    public void setSbjnOrgCode(String sbjnOrgCode) {
        this.sbjnOrgCode = sbjnOrgCode;
    }
    public BigDecimal getYfjsMny() {
        return yfjsMny;
    }

    public void setYfjsMny(BigDecimal yfjsMny) {
        this.yfjsMny = yfjsMny;
    }
    public BigDecimal getYfmsMny() {
        return yfmsMny;
    }

    public void setYfmsMny(BigDecimal yfmsMny) {
        this.yfmsMny = yfmsMny;
    }
    public BigDecimal getYfSalaryMny() {
        return yfSalaryMny;
    }

    public void setYfSalaryMny(BigDecimal yfSalaryMny) {
        this.yfSalaryMny = yfSalaryMny;
    }
    public BigDecimal getYfmsSalaryMny() {
        return yfmsSalaryMny;
    }

    public void setYfmsSalaryMny(BigDecimal yfmsSalaryMny) {
        this.yfmsSalaryMny = yfmsSalaryMny;
    }
    public BigDecimal getPersonEndowmentMny() {
        return personEndowmentMny;
    }

    public void setPersonEndowmentMny(BigDecimal personEndowmentMny) {
        this.personEndowmentMny = personEndowmentMny;
    }
    public BigDecimal getPersonMedicalMny() {
        return personMedicalMny;
    }

    public void setPersonMedicalMny(BigDecimal personMedicalMny) {
        this.personMedicalMny = personMedicalMny;
    }
    public BigDecimal getPersonUnemploymentMny() {
        return personUnemploymentMny;
    }

    public void setPersonUnemploymentMny(BigDecimal personUnemploymentMny) {
        this.personUnemploymentMny = personUnemploymentMny;
    }
    public BigDecimal getPersonHouseMny() {
        return personHouseMny;
    }

    public void setPersonHouseMny(BigDecimal personHouseMny) {
        this.personHouseMny = personHouseMny;
    }
    public BigDecimal getTotalNeedTaxMny() {
        return totalNeedTaxMny;
    }

    public void setTotalNeedTaxMny(BigDecimal totalNeedTaxMny) {
        this.totalNeedTaxMny = totalNeedTaxMny;
    }
    public BigDecimal getTotalAlreadyTaxMny() {
        return totalAlreadyTaxMny;
    }

    public void setTotalAlreadyTaxMny(BigDecimal totalAlreadyTaxMny) {
        this.totalAlreadyTaxMny = totalAlreadyTaxMny;
    }
    public BigDecimal getTotalButuiTaxMny() {
        return totalButuiTaxMny;
    }

    public void setTotalButuiTaxMny(BigDecimal totalButuiTaxMny) {
        this.totalButuiTaxMny = totalButuiTaxMny;
    }
    public Long getTaxModifyBillId() {
        return taxModifyBillId;
    }

    public void setTaxModifyBillId(Long taxModifyBillId) {
        this.taxModifyBillId = taxModifyBillId;
    }

    public Long getTaxHoldOrgId() {
        return taxHoldOrgId;
    }

    public void setTaxHoldOrgId(Long taxHoldOrgId) {
        this.taxHoldOrgId = taxHoldOrgId;
    }

    public String getTaxHoldOrgName() {
        return taxHoldOrgName;
    }

    public void setTaxHoldOrgName(String taxHoldOrgName) {
        this.taxHoldOrgName = taxHoldOrgName;
    }

    public String getTaxHoldOrgCode() {
        return taxHoldOrgCode;
    }

    public void setTaxHoldOrgCode(String taxHoldOrgCode) {
        this.taxHoldOrgCode = taxHoldOrgCode;
    }

    public BigDecimal getTotalZxkcMny() {
        return totalZxkcMny;
    }

    public void setTotalZxkcMny(BigDecimal totalZxkcMny) {
        this.totalZxkcMny = totalZxkcMny;
    }
    public BigDecimal getTotalZnjyMny() {
        return totalZnjyMny;
    }

    public void setTotalZnjyMny(BigDecimal totalZnjyMny) {
        this.totalZnjyMny = totalZnjyMny;
    }
    public BigDecimal getTotalJxjyMny() {
        return totalJxjyMny;
    }

    public void setTotalJxjyMny(BigDecimal totalJxjyMny) {
        this.totalJxjyMny = totalJxjyMny;
    }
    public BigDecimal getTotalZfdkMny() {
        return totalZfdkMny;
    }

    public void setTotalZfdkMny(BigDecimal totalZfdkMny) {
        this.totalZfdkMny = totalZfdkMny;
    }
    public BigDecimal getTotalZfzjMny() {
        return totalZfzjMny;
    }

    public void setTotalZfzjMny(BigDecimal totalZfzjMny) {
        this.totalZfzjMny = totalZfzjMny;
    }
    public BigDecimal getTotalSylrMny() {
        return totalSylrMny;
    }

    public void setTotalSylrMny(BigDecimal totalSylrMny) {
        this.totalSylrMny = totalSylrMny;
    }
    public BigDecimal getTotalYezhMny() {
        return totalYezhMny;
    }

    public void setTotalYezhMny(BigDecimal totalYezhMny) {
        this.totalYezhMny = totalYezhMny;
    }
    public BigDecimal getTotalYljMny() {
        return totalYljMny;
    }

    public void setTotalYljMny(BigDecimal totalYljMny) {
        this.totalYljMny = totalYljMny;
    }
    public BigDecimal getQynjMny() {
        return qynjMny;
    }

    public void setQynjMny(BigDecimal qynjMny) {
        this.qynjMny = qynjMny;
    }
    public BigDecimal getSybxMny() {
        return sybxMny;
    }

    public void setSybxMny(BigDecimal sybxMny) {
        this.sybxMny = sybxMny;
    }
    public BigDecimal getSyylMny() {
        return syylMny;
    }

    public void setSyylMny(BigDecimal syylMny) {
        this.syylMny = syylMny;
    }
    public BigDecimal getOtherMny() {
        return otherMny;
    }

    public void setOtherMny(BigDecimal otherMny) {
        this.otherMny = otherMny;
    }
    public BigDecimal getZykcMny() {
        return zykcMny;
    }

    public void setZykcMny(BigDecimal zykcMny) {
        this.zykcMny = zykcMny;
    }
    public BigDecimal getJmseMny() {
        return jmseMny;
    }

    public void setJmseMny(BigDecimal jmseMny) {
        this.jmseMny = jmseMny;
    }
    public String getIsAdjust() {
        return isAdjust;
    }

    public void setIsAdjust(String isAdjust) {
        this.isAdjust = isAdjust;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Long getYfgzjsBillId() {
        return yfgzjsBillId;
    }

    public void setYfgzjsBillId(Long yfgzjsBillId) {
        this.yfgzjsBillId = yfgzjsBillId;
    }

    public Long getYfgzjsBillDetailId() {
        return yfgzjsBillDetailId;
    }

    public void setYfgzjsBillDetailId(Long yfgzjsBillDetailId) {
        this.yfgzjsBillDetailId = yfgzjsBillDetailId;
    }

    public String getYfgzjsBillDetailSourceType() {
        return yfgzjsBillDetailSourceType;
    }

    public void setYfgzjsBillDetailSourceType(String yfgzjsBillDetailSourceType) {
        this.yfgzjsBillDetailSourceType = yfgzjsBillDetailSourceType;
    }
}
