package com.ejianc.business.salary.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.ejianc.business.salary.bean.PayableDetailEntity;
import com.ejianc.business.salary.bean.RosterEntity;
import com.ejianc.business.salary.service.IRosterService;
import com.ejianc.business.salary.util.DetailIndexExcelReader;
import com.ejianc.business.salary.vo.PayableDetailVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.*;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.salary.bean.PayableEntity;
import com.ejianc.business.salary.service.IPayableService;
import com.ejianc.business.salary.vo.PayableVO;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

/**
 * 应发工资上传
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("payable")
public class PayableController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "YFGZSC_CODE";//此处需要根据实际修改

    @Autowired
    private IPayableService service;

    @Autowired
    private IRosterService rosterService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PayableVO> saveOrUpdate(@RequestBody PayableVO saveOrUpdateVO) {
    	PayableEntity entity = BeanMapper.map(saveOrUpdateVO, PayableEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

//        LambdaQueryWrapper<PayableEntity> lambdaQueryWrapper1 = new LambdaQueryWrapper<>();
//        lambdaQueryWrapper1.eq(PayableEntity::getOrgId, saveOrUpdateVO.getOrgId());
//        lambdaQueryWrapper1.eq(PayableEntity::getMonth,saveOrUpdateVO.getMonth());
//        if(null!=entity.getId()){
//            lambdaQueryWrapper1.ne(PayableEntity::getId,saveOrUpdateVO.getId());
//        }
//        List<PayableEntity> payableEntityList= service.list(lambdaQueryWrapper1);
//        if(CollectionUtils.isNotEmpty(payableEntityList)){
//            throw new BusinessException("已存在 同组织，同月份单据，不允许新增");
//        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");

        String month = sdf.format(saveOrUpdateVO.getMonth());
        entity.setPayableName(month+"-"+saveOrUpdateVO.getCorpName()+"-"+saveOrUpdateVO.getOrgName());
    	service.saveOrUpdate(entity, false);
    	PayableVO vo = BeanMapper.map(entity, PayableVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PayableVO> queryDetail(Long id) {
    	PayableEntity entity = service.selectById(id);
    	PayableVO vo = BeanMapper.map(entity, PayableVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/getDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Boolean> getDetail(Long id) {
        PayableEntity entity = service.selectById(id);
        //判断主表组织单位是否项目部
//        如何定义本单位：
//        1）如果是项目部，查询项目部上级经理部的本下 本月 累计应发金额（任何状态）
//        2）如果非项目部，查询组织本下本月所有账套下累计应发金额（任何状态）
        List<Long> orgIds = new ArrayList<>();
        CommonResponse<OrgVO> orgVo = iOrgApi.getOneById(entity.getOrgId());
        if(5==orgVo.getData().getOrgType()){
            //项目部
            Long parendId = iOrgApi.getOneById(orgVo.getData().getParentId()).getData().getId();
            orgIds = iOrgApi.findChildrenByParentId(parendId).getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        }else{
            orgIds = iOrgApi.findChildrenByParentId(entity.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        }
        Map<String,BigDecimal> orgMnyMap = new HashMap<>();
        List<PayableDetailVO> orgMnyList = service.getDetailByOrg(entity.getMonth(),orgIds);
        orgMnyMap = orgMnyList.stream().collect(Collectors.toMap(PayableDetailVO::getIdCard, PayableDetailVO::getYfSalaryMny,(key1 , key2)-> key2 ));

        Map<String,BigDecimal> mnyMap = new HashMap<>();
        List<PayableDetailVO> mnyList = service.getDetail(entity.getMonth());
        mnyMap = mnyList.stream().collect(Collectors.toMap(PayableDetailVO::getIdCard, PayableDetailVO::getYfSalaryMny,(key1 , key2)-> key2 ));


        for(PayableDetailEntity detailVO:entity.getPayableDetailList()){
            if(orgMnyMap.containsKey(detailVO.getIdCard())){
                detailVO.setOrgSalaryMny(orgMnyMap.get(detailVO.getIdCard()));
            }
            if(mnyMap.containsKey(detailVO.getIdCard())){
                detailVO.setOrgsSalaryMny(mnyMap.get(detailVO.getIdCard()));
            }
        }
        service.saveOrUpdate(entity,false);
        PayableVO vo = BeanMapper.map(entity, PayableVO.class);
        return CommonResponse.success("操作成功！",true);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PayableVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (PayableVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(PayableVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PayableVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("acSet");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("corpName");
        fuzzyFields.add("payableName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<PayableEntity> page = service.queryPage(param,false);
        IPage<PayableVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), PayableVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("acSet");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("corpName");
        fuzzyFields.add("payableName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<PayableEntity> list = service.queryList(param);
        List<PayableVO> resList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(list)){
            resList = BeanMapper.mapList(list,PayableVO.class);
            resList.forEach(e->{
                e.setBillStateName(BillStateEnum.getEnumByStateCode(e.getBillState()).getDescription());
                if(2==e.getCollectStatus()){
                    e.setCollectStatusName("被驳回");
                }else if(1==e.getCollectStatus()){
                    e.setCollectStatusName("已汇总");
                }else{
                    e.setCollectStatusName("未汇总");
                }
            });
        }
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", resList);
        ExcelExport.getInstance().export("Payable-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refPayableData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<PayableVO>> refPayableData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<PayableEntity> page = service.queryPage(param,false);
        IPage<PayableVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), PayableVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadInfo")
    @ResponseBody
    public void downloadMaterial(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "PayableDetail-import.xlsx", "应发工资上传-明细模板");
    }
    /**
     * excel导入
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/excelImportInfo", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportMaterial(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<PayableDetailVO> successList = new ArrayList<>();
        List<PayableDetailVO> errorList = new ArrayList<>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        }
        else {
            List<List<String>> result = DetailIndexExcelReader.readExcel(mf);
            if (result != null && result.size() > 0) {
                List<String> idCardList = new ArrayList<>();
                for (int i = 1; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    idCardList.add(datas.get(1).trim());
                }



                //获取人员花名册档案数据
                Map<String,RosterEntity> map = new HashMap<>();

                LambdaQueryWrapper<RosterEntity> lambdaQueryWrapper1 = new LambdaQueryWrapper<>();
                lambdaQueryWrapper1.eq(RosterEntity::getHrState, 1);
                lambdaQueryWrapper1.in(RosterEntity::getIdCard,idCardList);
                lambdaQueryWrapper1.isNotNull(RosterEntity::getIdCard);
                List<RosterEntity> rosterEntityList= rosterService.list(lambdaQueryWrapper1);
                map = rosterEntityList.stream().collect(Collectors.toMap(p -> p.getIdCard(), Function.identity()));
                logger.info("人员map: {}",JSONObject.toJSONString(map));
                //给每行赋值
                for (int i = 1; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    PayableDetailVO detailVO = new PayableDetailVO();
                    detailVO.setId(com.ejianc.support.idworker.util.IdWorker.getId());
                    try {
                        String idCard = datas.get(1).trim();
                        detailVO.setIdCard(idCard);
                        if (ObjectUtils.isEmpty(map.get(idCard))){
                            throw new Exception("没有该人员信息！");
                        }

                        detailVO.setDetailEmployeeId(map.get(idCard).getUserId());
                        detailVO.setDetailEmployeeName(datas.get(0));
                        detailVO.setDetailEmployeeCode(map.get(idCard).getUserCode());
                        detailVO.setJobType(datas.get(2));
                        detailVO.setDetailOrgId(map.get(idCard).getOrgId());
                        detailVO.setDetailOrgCode(map.get(idCard).getOrgCode());
                        detailVO.setDetailOrgName(map.get(idCard).getOrgName());
                        detailVO.setJob(map.get(idCard).getPostName());
                        detailVO.setDept(map.get(idCard).getDepartmentName());
                        detailVO.setJobLevel(map.get(idCard).getJobLevelName());
                        detailVO.setSbjnOrgName(map.get(idCard).getSocialDepartmentName());
                        detailVO.setSbjnOrgCode(map.get(idCard).getSocialDepartmentCode());
                        detailVO.setIsMove("2");//1-是 2-否
                        detailVO.setSbcdOrgId(map.get(idCard).getOrgId());
                        detailVO.setSbcdOrgCode(map.get(idCard).getOrgCode());
                        detailVO.setSbcdOrgName(map.get(idCard).getOrgName());
                        detailVO.setDetailCollectStatus(0);//未汇总
                    }
                    catch (Exception e) {
                        detailVO.setErrorMsg("没有该人员信息！");
                        errorList.add(detailVO);
                        continue;
                    }

                    try {
                        String unWriteOffMny = datas.get(17);
                        detailVO.setUnWriteOffMny(StringUtils.isNotBlank(unWriteOffMny)?new BigDecimal(unWriteOffMny):null);
                    }
                    catch (Exception e) {
                        detailVO.setErrorMsg("截止当前未核销金额错误！");
                        errorList.add(detailVO);
                        continue;
                    }

                    try {
                        String writeOffMny = datas.get(18);
                        detailVO.setWriteOffMny(StringUtils.isNotBlank(writeOffMny)?new BigDecimal(writeOffMny):null);
                    }
                    catch (Exception e) {
                        detailVO.setErrorMsg("本次核销金额错误！");
                        errorList.add(detailVO);
                        continue;
                    }

                    try {
                        String yfjsMny = datas.get(19);
                        detailVO.setYfjsMny(StringUtils.isNotBlank(yfjsMny)?new BigDecimal(yfjsMny):null);
                    }
                    catch (Exception e) {
                        detailVO.setErrorMsg("应发计税错误！");
                        errorList.add(detailVO);
                        continue;
                    }

                    try {
                        String yfmsMny = datas.get(20);
                        detailVO.setYfmsMny(StringUtils.isNotBlank(yfmsMny)?new BigDecimal(yfmsMny):null);
                        detailVO.setTaxYfmsMny(detailVO.getYfmsMny());
                    }
                    catch (Exception e) {
                        detailVO.setErrorMsg("应发免税错误！");
                        errorList.add(detailVO);
                        continue;
                    }

                    try {
                        String jobMny = datas.get(3);
                        detailVO.setJobMny(StringUtils.isNotBlank(jobMny)?new BigDecimal(jobMny):null);
                    }
                    catch (Exception e) {
                        detailVO.setErrorMsg("岗位工资错误！");
                        errorList.add(detailVO);
                        continue;
                    }

                    try {
                        String performanceMny = datas.get(4);
                        detailVO.setPerformanceMny(StringUtils.isNotBlank(performanceMny)?new BigDecimal(performanceMny):null);
                    }
                    catch (Exception e) {
                        detailVO.setErrorMsg("绩效工资错误！");
                        errorList.add(detailVO);
                        continue;
                    }

                    try {
                        String workYearMny = datas.get(5);
                        detailVO.setWorkYearMny(StringUtils.isNotBlank(workYearMny)?new BigDecimal(workYearMny):null);
                    }
                    catch (Exception e) {
                        detailVO.setErrorMsg("司龄补贴错误！");
                        errorList.add(detailVO);
                        continue;
                    }

                    try {
                        String workTypeMny = datas.get(6);
                        detailVO.setWorkTypeMny(StringUtils.isNotBlank(workTypeMny)?new BigDecimal(workTypeMny):null);
                    }
                    catch (Exception e) {
                        detailVO.setErrorMsg("职称补贴错误！");
                        errorList.add(detailVO);
                        continue;
                    }

                    try {
                        String certificateMny = datas.get(7);
                        detailVO.setCertificateMny(StringUtils.isNotBlank(certificateMny)?new BigDecimal(certificateMny):null);
                    }
                    catch (Exception e) {
                        detailVO.setErrorMsg("证书补贴错误！");
                        errorList.add(detailVO);
                        continue;
                    }

                    try {
                        String travelMny = datas.get(8);
                        detailVO.setTravelMny(StringUtils.isNotBlank(travelMny)?new BigDecimal(travelMny):null);
                    }
                    catch (Exception e) {
                        detailVO.setErrorMsg("派驻补贴错误！");
                        errorList.add(detailVO);
                        continue;
                    }

                    try {
                        String trafficMny = datas.get(9);
                        detailVO.setTrafficMny(StringUtils.isNotBlank(trafficMny)?new BigDecimal(trafficMny):null);
                    }
                    catch (Exception e) {
                        detailVO.setErrorMsg("交通补贴错误！");
                        errorList.add(detailVO);
                        continue;
                    }

                    try {
                        String mealMny = datas.get(10);
                        detailVO.setMealMny(StringUtils.isNotBlank(mealMny)?new BigDecimal(mealMny):null);
                    }
                    catch (Exception e) {
                        detailVO.setErrorMsg("餐补错误！");
                        errorList.add(detailVO);
                        continue;
                    }

                    try {
                        String benefitMny = datas.get(11);
                        detailVO.setBenefitMny(StringUtils.isNotBlank(benefitMny)?new BigDecimal(benefitMny):null);
                    }
                    catch (Exception e) {
                        detailVO.setErrorMsg("福利费错误！");
                        errorList.add(detailVO);
                        continue;
                    }

                    try {
                        String holidayMny = datas.get(12);
                        detailVO.setHolidayMny(StringUtils.isNotBlank(holidayMny)?new BigDecimal(holidayMny):null);
                    }
                    catch (Exception e) {
                        detailVO.setErrorMsg("过节费错误！");
                        errorList.add(detailVO);
                        continue;
                    }

                    try {
                        String yearEndMny = datas.get(13);
                        detailVO.setYearEndMny(StringUtils.isNotBlank(yearEndMny)?new BigDecimal(yearEndMny):null);
                    }
                    catch (Exception e) {
                        detailVO.setErrorMsg("年终奖错误！");
                        errorList.add(detailVO);
                        continue;
                    }

                    try {
                        String overtimeMny = datas.get(14);
                        detailVO.setOvertimeMny(StringUtils.isNotBlank(overtimeMny)?new BigDecimal(overtimeMny):null);
                    }
                    catch (Exception e) {
                        detailVO.setErrorMsg("加班费错误！");
                        errorList.add(detailVO);
                        continue;
                    }

                    try {
                        String addMny = datas.get(15);
                        detailVO.setAddMny(StringUtils.isNotBlank(addMny)?new BigDecimal(addMny):null);
                    }
                    catch (Exception e) {
                        detailVO.setErrorMsg("补款错误！");
                        errorList.add(detailVO);
                        continue;
                    }

                    try {
                        String buttonMny = datas.get(16);
                        detailVO.setButtonMny(StringUtils.isNotBlank(buttonMny)?new BigDecimal(buttonMny):null);
                    }
                    catch (Exception e) {
                        detailVO.setErrorMsg("扣款错误！");
                        errorList.add(detailVO);
                        continue;
                    }

                    try {
                        String salaryMny = datas.get(21);
                        detailVO.setSalaryMny(StringUtils.isNotBlank(salaryMny)?new BigDecimal(salaryMny):null);
                    }
                    catch (Exception e) {
                        detailVO.setErrorMsg("工资合计错误！");
                        errorList.add(detailVO);
                        continue;
                    }
                    try {
                        String yfSalaryMny = datas.get(22);
                        detailVO.setYfSalaryMny(StringUtils.isNotBlank(yfSalaryMny)?new BigDecimal(yfSalaryMny):null);
                    }
                    catch (Exception e) {
                        detailVO.setErrorMsg("应发工资错误！");
                        errorList.add(detailVO);
                        continue;
                    }
                    detailVO.setYfmsSalaryMny(ComputeUtil.safeAdd(detailVO.getYfmsMny(),detailVO.getYfSalaryMny()));//应发+免税
                    detailVO.setRowState("add");
                    successList.add(detailVO);
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }
}
