package com.ejianc.business.salary.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.ejianc.business.salary.bean.RosterEntity;
import com.ejianc.business.salary.service.IRosterService;
import com.ejianc.business.salary.util.DetailIndexExcelReader;
import com.ejianc.business.salary.util.DetailIndexExcelReaderZzyj;
import com.ejianc.business.salary.vo.PayableDetailVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.salary.bean.SocialSecurityChangeSdetailEntity;
import com.ejianc.business.salary.service.ISocialSecurityChangeSdetailService;
import com.ejianc.business.salary.vo.SocialSecurityChangeSdetailVO;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

/**
 * 社保公积金调整-社保明细
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("socialSecurityChangeSdetail")
public class SocialSecurityChangeSdetailController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private ISocialSecurityChangeSdetailService service;

    @Autowired
    private IRosterService rosterService;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SocialSecurityChangeSdetailVO> saveOrUpdate(@RequestBody SocialSecurityChangeSdetailVO saveOrUpdateVO) {
    	SocialSecurityChangeSdetailEntity entity = BeanMapper.map(saveOrUpdateVO, SocialSecurityChangeSdetailEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	SocialSecurityChangeSdetailVO vo = BeanMapper.map(entity, SocialSecurityChangeSdetailVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SocialSecurityChangeSdetailVO> queryDetail(Long id) {
    	SocialSecurityChangeSdetailEntity entity = service.selectById(id);
    	SocialSecurityChangeSdetailVO vo = BeanMapper.map(entity, SocialSecurityChangeSdetailVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SocialSecurityChangeSdetailVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (SocialSecurityChangeSdetailVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(SocialSecurityChangeSdetailVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SocialSecurityChangeSdetailVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<SocialSecurityChangeSdetailEntity> page = service.queryPage(param,false);
        IPage<SocialSecurityChangeSdetailVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), SocialSecurityChangeSdetailVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<SocialSecurityChangeSdetailEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("SocialSecurityChangeSdetail-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refSocialSecurityChangeSdetailData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SocialSecurityChangeSdetailVO>> refSocialSecurityChangeSdetailData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<SocialSecurityChangeSdetailEntity> page = service.queryPage(param,false);
        IPage<SocialSecurityChangeSdetailVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SocialSecurityChangeSdetailVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }


    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadInfo")
    @ResponseBody
    public void downloadMaterial(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "SocialSecurityChangeSdetail-import.xlsx", "社保调整导入模板");
    }
    /**
     * excel导入
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/excelImportInfo", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportMaterial(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<SocialSecurityChangeSdetailVO> successList = new ArrayList<>();
        List<SocialSecurityChangeSdetailVO> errorList = new ArrayList<>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        }
        else {
            List<List<String>> result = DetailIndexExcelReaderZzyj.readExcel(mf);
            if (result != null && result.size() > 0) {
                List<String> idCardList = new ArrayList<>();
                for (int i = 1; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    idCardList.add(datas.get(1).trim());
                }

                //获取人员花名册档案数据
                Map<String, RosterEntity> map = new HashMap<>();
                LambdaQueryWrapper<RosterEntity> lambdaQueryWrapper1 = new LambdaQueryWrapper<>();
                lambdaQueryWrapper1.eq(RosterEntity::getHrState, 1);
                lambdaQueryWrapper1.in(RosterEntity::getIdCard,idCardList);
                lambdaQueryWrapper1.isNotNull(RosterEntity::getIdCard);
                List<RosterEntity> rosterEntityList= rosterService.list(lambdaQueryWrapper1);
                map = rosterEntityList.stream().collect(Collectors.toMap(p -> p.getIdCard(), Function.identity()));
                logger.info("人员map: {}",JSONObject.toJSONString(map));
                //给每行赋值
                for (int i = 1; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    SocialSecurityChangeSdetailVO detailVO = new SocialSecurityChangeSdetailVO();
                    detailVO.setId(com.ejianc.support.idworker.util.IdWorker.getId());
                    try {
                        //身份证号
                        String idCard = datas.get(1).trim();
                        detailVO.setIdCard(idCard);
                        if (ObjectUtils.isEmpty(map.get(idCard))){
                            throw new Exception("没有该人员信息！");
                        }

                        RosterEntity rosterEntity = map.get(idCard);
                        String userName = datas.get(0).trim();
                        if (userName != null && userName.equals(rosterEntity.getUserName())){
                            detailVO.setUserName(userName);
                            detailVO.setUserId(rosterEntity.getUserId());
                            detailVO.setUserCode(rosterEntity.getUserCode());
                        }else {
                            throw new Exception("人员身份证号、姓名不匹配！");
                        }

                    }
                    catch (Exception e) {
                        detailVO.setErrorMsg("人员名称、身份证号错误！");
                        errorList.add(detailVO);
                        continue;
                    }

                    //缴费基数
                    try {
                        String paymentBase = datas.get(2);
                        if(StringUtils.isNotBlank(paymentBase)) {
                            detailVO.setPaymentBase(new BigDecimal(paymentBase));
                        }else {
                            throw new Exception("缴费基数金额不能为空！");
                        }
                    } catch (Exception e) {
                        detailVO.setErrorMsg("缴费基数金额错误！");
                        errorList.add(detailVO);
                        continue;
                    }

                    //个人养老金
                    try {
                        String personAnnuityMoney = datas.get(3);
                        if(StringUtils.isNotBlank(personAnnuityMoney)) {
                            detailVO.setPersonAnnuityMoney(new BigDecimal(personAnnuityMoney));
                            detailVO.setPersonAnnuityMoneyPercent( detailVO.getPersonAnnuityMoney().divide(detailVO.getPaymentBase(),BigDecimal.ROUND_CEILING).multiply(new BigDecimal(100)).setScale(2, RoundingMode.HALF_UP));
                        }else {
                            throw new Exception("个人养老金金额不能为空！");
                        }
                    } catch (Exception e) {
                        detailVO.setErrorMsg("个人养老金金额错误！");
                        errorList.add(detailVO);
                        continue;
                    }

                    //公司养老金
                    try {
                        String companyAnnuityMoney = datas.get(4);
                        if(StringUtils.isNotBlank(companyAnnuityMoney)) {
                            detailVO.setCompanyAnnuityMoney(new BigDecimal(companyAnnuityMoney));
                            detailVO.setCompanyAnnuityMoneyPercent( detailVO.getCompanyAnnuityMoney().divide(detailVO.getPaymentBase(),BigDecimal.ROUND_CEILING).multiply(new BigDecimal(100)).setScale(2, RoundingMode.HALF_UP));
                        }else {
                            throw new Exception("公司养老金金额不能为空！");
                        }
                    } catch (Exception e) {
                        detailVO.setErrorMsg("公司养老金金额错误！");
                        errorList.add(detailVO);
                        continue;
                    }

                    //个人医疗
                    try {
                        String personMedicalMoney = datas.get(5);
                        if(StringUtils.isNotBlank(personMedicalMoney)) {
                            detailVO.setPersonMedicalMoney(new BigDecimal(personMedicalMoney));
                            detailVO.setPersonMedicalMoneyPercent( detailVO.getPersonMedicalMoney().divide(detailVO.getPaymentBase(),BigDecimal.ROUND_CEILING).multiply(new BigDecimal(100)).setScale(2, RoundingMode.HALF_UP));
                        }else {
                            throw new Exception("个人医疗金额不能为空！");
                        }
                    } catch (Exception e) {
                        detailVO.setErrorMsg("个人医疗金额错误！");
                        errorList.add(detailVO);
                        continue;
                    }

                    //公司医疗
                    try {
                        String companyMedicalMoney = datas.get(6);
                        if(StringUtils.isNotBlank(companyMedicalMoney)) {
                            detailVO.setCompanyMedicalMoney(new BigDecimal(companyMedicalMoney));
                            detailVO.setCompanyMedicalMoneyPercent( detailVO.getCompanyMedicalMoney().divide(detailVO.getPaymentBase(),BigDecimal.ROUND_CEILING).multiply(new BigDecimal(100)).setScale(2, RoundingMode.HALF_UP));
                        }else {
                            throw new Exception("公司医疗金额不能为空！");
                        }
                    } catch (Exception e) {
                        detailVO.setErrorMsg("公司医疗金额错误！");
                        errorList.add(detailVO);
                        continue;
                    }

                    //个人失业
                    try {
                        String personUnemploymentMoney = datas.get(7);
                        if(StringUtils.isNotBlank(personUnemploymentMoney)) {
                            detailVO.setPersonUnemploymentMoney(new BigDecimal(personUnemploymentMoney));
                            detailVO.setPersonUnemploymentMoneyPercent( detailVO.getPersonUnemploymentMoney().divide(detailVO.getPaymentBase(),BigDecimal.ROUND_CEILING).multiply(new BigDecimal(100)).setScale(2, RoundingMode.HALF_UP));
                        }else {
                            throw new Exception("个人失业金额不能为空！");
                        }
                    } catch (Exception e) {
                        detailVO.setErrorMsg("个人失业金额错误！");
                        errorList.add(detailVO);
                        continue;
                    }

                    //公司失业
                    try {
                        String companyUnemploymentMoney = datas.get(8);
                        if(StringUtils.isNotBlank(companyUnemploymentMoney)) {
                            detailVO.setCompanyUnemploymentMoney(new BigDecimal(companyUnemploymentMoney));
                            detailVO.setCompanyUnemploymentMoneyPercent( detailVO.getCompanyUnemploymentMoney().divide(detailVO.getPaymentBase(),BigDecimal.ROUND_CEILING).multiply(new BigDecimal(100)).setScale(2, RoundingMode.HALF_UP));
                        }else {
                            throw new Exception("公司失业金额不能为空！");
                        }
                    } catch (Exception e) {
                        detailVO.setErrorMsg("公司失业金额错误！");
                        errorList.add(detailVO);
                        continue;
                    }

                    //公司生育
                    try {
                        String companyChildbirthMoney = datas.get(9);
                        if(StringUtils.isNotBlank(companyChildbirthMoney)) {
                            detailVO.setCompanyChildbirthMoney(new BigDecimal(companyChildbirthMoney));
                            detailVO.setCompanyChildbirthMoneyPercent( detailVO.getCompanyChildbirthMoney().divide(detailVO.getPaymentBase(),BigDecimal.ROUND_CEILING).multiply(new BigDecimal(100)).setScale(2, RoundingMode.HALF_UP));
                        }else {
                            throw new Exception("公司生育金额不能为空！");
                        }
                    } catch (Exception e) {
                        detailVO.setErrorMsg("公司生育金额错误！");
                        errorList.add(detailVO);
                        continue;
                    }

                    //公司工伤
                    try {
                        String companyInjuryMoney = datas.get(10);
                        if(StringUtils.isNotBlank(companyInjuryMoney)) {
                            detailVO.setCompanyInjuryMoney(new BigDecimal(companyInjuryMoney));
                            detailVO.setCompanyInjuryMoneyPercent( detailVO.getCompanyInjuryMoney().divide(detailVO.getPaymentBase(),BigDecimal.ROUND_CEILING).multiply(new BigDecimal(100)).setScale(2, RoundingMode.HALF_UP));
                        }else {
                            throw new Exception("个人养老金金额不能为空！");
                        }
                    } catch (Exception e) {
                        detailVO.setErrorMsg("个人养老金金额错误！");
                        errorList.add(detailVO);
                        continue;
                    }


                    detailVO.setChangeReason( datas.get(11));
                    detailVO.setRowState("add");
                    successList.add(detailVO);
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }

}
