package com.ejianc.business.salary.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.profinance.api.ISalaryApi;
import com.ejianc.business.salary.bean.*;
import com.ejianc.business.salary.service.*;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.salary.mapper.JspayableAdjustMapper;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 应发公积金调整
 * 
 * @author generator
 * 
 */
@Service("jspayableAdjustService")
public class JspayableAdjustServiceImpl extends BaseServiceImpl<JspayableAdjustMapper, JspayableAdjustEntity> implements IJspayableAdjustService{
    @Autowired
    private IJspayableService jspayableService;
    @Autowired
    private IJspayableSourceService sourceService;
    @Autowired
    private IPayableDetailService payableDetailService;
    @Autowired
    private IJspayableDetailService jspayableDetailService;
    @Autowired
    private IAcSetRelateService acSetRelateService;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void insuranceAdjustApportion(Long jspayableId) {
        JspayableEntity jspayableEntity = jspayableService.selectById(jspayableId);
        List<JspayableDetailEntity> detailList = jspayableEntity.getJspayableDetailList();
        List<String> jsDetailIdCardList = detailList.stream().filter(e -> StringUtils.isNotBlank(e.getSourceType()) && "1".equals(e.getSourceType())).map(JspayableDetailEntity::getIdCard).collect(Collectors.toList());

        //分摊社保公积金 全删全加
        super.remove(new QueryWrapper<JspayableAdjustEntity>().in("id_card", jsDetailIdCardList).eq("period", jspayableEntity.getMonth()));

        //1.查询到对应的来源数据
        List<String> idCardList = detailList.stream().map(JspayableDetailEntity::getIdCard).collect(Collectors.toList());
        List<JspayableSourceEntity> sourceList = sourceService.list(new QueryWrapper<JspayableSourceEntity>().in("id_card", idCardList).eq("period", jspayableEntity.getMonth()));
        List<Long> sourceDetailId = sourceList.stream().map(JspayableSourceEntity::getSourceDetailId).collect(Collectors.toList());
        List<PayableDetailEntity> payableDetailList = payableDetailService.list(new QueryWrapper<PayableDetailEntity>().in("id", sourceDetailId));

        //查询对应的 账套
        List<AcSetRelateEntity> acSetList = acSetRelateService.list(new QueryWrapper<AcSetRelateEntity>().in("org_id", payableDetailList.stream().map(PayableDetailEntity::getSbcdOrgId).distinct().collect(Collectors.toList())));
        Map<Long, AcSetRelateEntity> acSetMap = acSetList.stream().collect(Collectors.toMap(p -> p.getOrgId(), Function.identity()));

        Map<String, List<JspayableSourceEntity>> sourceMap = sourceList.stream().collect(Collectors.groupingBy(JspayableSourceEntity::getIdCard));
        Map<String, List<PayableDetailEntity>> payableDetailMap = payableDetailList.stream().collect(Collectors.groupingBy(PayableDetailEntity::getIdCard));

        List<JspayableAdjustEntity> allAdjustEntityList = new ArrayList<>();
        for (JspayableDetailEntity jspayableDetailEntity : detailList) {
            String sbcdOrgName = "";
            List<PayableDetailEntity> payableDetailEntityList = payableDetailMap.get(jspayableDetailEntity.getIdCard());
            if (CollectionUtils.isNotEmpty(payableDetailEntityList)){
                List<JspayableAdjustEntity> adjustEntityList = new ArrayList<>();
                //总应发工资
                BigDecimal totalYfSalaryMny = payableDetailEntityList.stream().filter(p -> p.getYfSalaryMny() != null).map(PayableDetailEntity::getYfSalaryMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                int count = 0;
                for (PayableDetailEntity entity : payableDetailEntityList) {
                    JspayableAdjustEntity jspayableAdjustEntity = new JspayableAdjustEntity();
                    jspayableAdjustEntity.setId(IdWorker.getId());
                    jspayableAdjustEntity.setJspayableDetailId(jspayableDetailEntity.getId());
                    jspayableAdjustEntity.setSbcdOrgId(entity.getGzffOrgId());
                    jspayableAdjustEntity.setSbcdOrgCode(entity.getGzffOrgCode());
                    jspayableAdjustEntity.setSbcdOrgName(entity.getGzffOrgName());
                    jspayableAdjustEntity.setAcSet(acSetMap.containsKey(entity.getSbcdOrgId()) ? acSetMap.get(entity.getSbcdOrgId()).getAcSet() : null);
                    jspayableAdjustEntity.setAcSetCode(acSetMap.containsKey(entity.getSbcdOrgId()) ? acSetMap.get(entity.getSbcdOrgId()).getAcSetCode() : null);
                    jspayableAdjustEntity.setIdCard(entity.getIdCard());
                    jspayableAdjustEntity.setPeriod(sourceMap.get(jspayableDetailEntity.getIdCard()).get(0).getPeriod());
                    jspayableAdjustEntity.setIsDefault(entity.getSbcdOrgId().toString().equals(jspayableDetailEntity.getDetailOrgId().toString()) ? "1" : "2");

                    BigDecimal scale = ComputeUtil.safeDiv(entity.getYfSalaryMny(), totalYfSalaryMny, new BigDecimal(100));
                    jspayableAdjustEntity.setScale(scale);


                    sbcdOrgName = sbcdOrgName + entity.getGzffOrgName();
                    if (payableDetailEntityList.size() == 1 || payableDetailEntityList.size() != ++count){
                        if (payableDetailEntityList.size() != 1){
                            sbcdOrgName += "，";
                        }
                        jspayableAdjustEntity.setPersonEndowmentMny(ComputeUtil.safeMultiply(jspayableDetailEntity.getPersonEndowmentMny(), scale, new BigDecimal(100)));
                        jspayableAdjustEntity.setPersonMedicalMny(ComputeUtil.safeMultiply(jspayableDetailEntity.getPersonMedicalMny(), scale, new BigDecimal(100)));
                        jspayableAdjustEntity.setPersonUnemploymentMny(ComputeUtil.safeMultiply(jspayableDetailEntity.getPersonUnemploymentMny(), scale, new BigDecimal(100)));
                        jspayableAdjustEntity.setPersonHouseMny(ComputeUtil.safeMultiply(jspayableDetailEntity.getPersonHouseMny(), scale, new BigDecimal(100)));
                        jspayableAdjustEntity.setCompanyEndowmentMny(ComputeUtil.safeMultiply(jspayableDetailEntity.getCompanyEndowmentMny(), scale, new BigDecimal(100)));
                        jspayableAdjustEntity.setCompanyMedicalMny(ComputeUtil.safeMultiply(jspayableDetailEntity.getCompanyMedicalMny(), scale, new BigDecimal(100)));
                        jspayableAdjustEntity.setCompanyUnemploymentMny(ComputeUtil.safeMultiply(jspayableDetailEntity.getCompanyUnemploymentMny(), scale, new BigDecimal(100)));
                        jspayableAdjustEntity.setCompanyBirthMny(ComputeUtil.safeMultiply(jspayableDetailEntity.getCompanyBirthMny(), scale, new BigDecimal(100)));
                        jspayableAdjustEntity.setCompanyInjureMny(ComputeUtil.safeMultiply(jspayableDetailEntity.getCompanyInjureMny(), scale, new BigDecimal(100)));
                        jspayableAdjustEntity.setCompanyHouseMny(ComputeUtil.safeMultiply(jspayableDetailEntity.getCompanyHouseMny(), scale, new BigDecimal(100)));
                    }else {
                        //最后一次循环，减去之前的金额
                        jspayableAdjustEntity.setPersonEndowmentMny(ComputeUtil.safeSub(jspayableDetailEntity.getPersonEndowmentMny(), adjustEntityList.stream().filter(p -> p.getPersonEndowmentMny() != null).map(JspayableAdjustEntity::getPersonEndowmentMny).reduce(BigDecimal.ZERO, BigDecimal::add)));
                        jspayableAdjustEntity.setPersonMedicalMny(ComputeUtil.safeSub(jspayableDetailEntity.getPersonMedicalMny(), adjustEntityList.stream().filter(p -> p.getPersonMedicalMny() != null).map(JspayableAdjustEntity::getPersonMedicalMny).reduce(BigDecimal.ZERO, BigDecimal::add)));
                        jspayableAdjustEntity.setPersonUnemploymentMny(ComputeUtil.safeSub(jspayableDetailEntity.getPersonUnemploymentMny(), adjustEntityList.stream().filter(p -> p.getPersonUnemploymentMny() != null).map(JspayableAdjustEntity::getPersonUnemploymentMny).reduce(BigDecimal.ZERO, BigDecimal::add)));
                        jspayableAdjustEntity.setPersonHouseMny(ComputeUtil.safeSub(jspayableDetailEntity.getPersonHouseMny(), adjustEntityList.stream().filter(p -> p.getPersonHouseMny() != null).map(JspayableAdjustEntity::getPersonHouseMny).reduce(BigDecimal.ZERO, BigDecimal::add)));
                        jspayableAdjustEntity.setCompanyEndowmentMny(ComputeUtil.safeSub(jspayableDetailEntity.getCompanyEndowmentMny(), adjustEntityList.stream().filter(p -> p.getCompanyEndowmentMny() != null).map(JspayableAdjustEntity::getCompanyEndowmentMny).reduce(BigDecimal.ZERO, BigDecimal::add)));
                        jspayableAdjustEntity.setCompanyMedicalMny(ComputeUtil.safeSub(jspayableDetailEntity.getCompanyMedicalMny(), adjustEntityList.stream().filter(p -> p.getCompanyMedicalMny() != null).map(JspayableAdjustEntity::getCompanyMedicalMny).reduce(BigDecimal.ZERO, BigDecimal::add)));
                        jspayableAdjustEntity.setCompanyUnemploymentMny(ComputeUtil.safeSub(jspayableDetailEntity.getCompanyUnemploymentMny(), adjustEntityList.stream().filter(p -> p.getCompanyUnemploymentMny() != null).map(JspayableAdjustEntity::getCompanyUnemploymentMny).reduce(BigDecimal.ZERO, BigDecimal::add)));
                        jspayableAdjustEntity.setCompanyBirthMny(ComputeUtil.safeSub(jspayableDetailEntity.getCompanyBirthMny(), adjustEntityList.stream().filter(p -> p.getCompanyBirthMny() != null).map(JspayableAdjustEntity::getCompanyBirthMny).reduce(BigDecimal.ZERO, BigDecimal::add)));
                        jspayableAdjustEntity.setCompanyInjureMny(ComputeUtil.safeSub(jspayableDetailEntity.getCompanyInjureMny(), adjustEntityList.stream().filter(p -> p.getCompanyInjureMny() != null).map(JspayableAdjustEntity::getCompanyInjureMny).reduce(BigDecimal.ZERO, BigDecimal::add)));
                        jspayableAdjustEntity.setCompanyHouseMny(ComputeUtil.safeSub(jspayableDetailEntity.getCompanyHouseMny(), adjustEntityList.stream().filter(p -> p.getCompanyHouseMny() != null).map(JspayableAdjustEntity::getCompanyHouseMny).reduce(BigDecimal.ZERO, BigDecimal::add)));
                    }
                    adjustEntityList.add(jspayableAdjustEntity);
                }
                allAdjustEntityList.addAll(adjustEntityList);
            }
            jspayableDetailEntity.setSbcdOrgName(sbcdOrgName);
        }

        super.saveOrUpdateBatch(allAdjustEntityList, allAdjustEntityList.size());
        jspayableDetailService.saveOrUpdateBatch(detailList, detailList.size());
    }
}
