package com.ejianc.business.salary.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.salary.bean.*;
import com.ejianc.business.salary.service.*;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.salary.mapper.TaxModifyMapper;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 个税计算-个税调整
 * 
 * @author generator
 * 
 */
@Service("taxModifyService")
public class TaxModifyServiceImpl extends BaseServiceImpl<TaxModifyMapper, TaxModifyEntity> implements ITaxModifyService{

    @Autowired
    private ITaxService taxService;
    @Autowired
    private IJspayableSourceService jspayableSourceService;
    @Autowired
    private IAcSetRelateService acSetRelateService;
    @Autowired
    private IPayableDetailService payableDetailService;

    @Override
    public void initTaxModify(Long taxId) {
        //1.查询到对应的应发工资计算子表id
        TaxEntity taxEntity = taxService.selectById(taxId);
        List<TaxDetailEntity> detailList = taxEntity.getDetailList().stream().filter(e -> StringUtils.isNotBlank(e.getYfgzjsBillDetailSourceType()) && "1".equals(e.getYfgzjsBillDetailSourceType())).collect(Collectors.toList());

        //2.根据应发工资计算子表id查询对应的 默认的单位 账套
        List<AcSetRelateEntity> acSetList = acSetRelateService.list(new QueryWrapper<AcSetRelateEntity>().in("org_id", detailList.stream().map(TaxDetailEntity::getTaxHoldOrgId).collect(Collectors.toList())));
        Map<Long, AcSetRelateEntity> acSetMap = acSetList.stream().collect(Collectors.toMap(p -> p.getOrgId(), Function.identity()));

        //3.保存对应的个税调整数据
        List<TaxModifyEntity> taxModifySaveList = new ArrayList<>();
        for (TaxDetailEntity detail : detailList) {
            TaxModifyEntity taxModifyEntity = new TaxModifyEntity();
            taxModifyEntity.setTaxHoldOrgId(detail.getDetailOrgId());
            taxModifyEntity.setTaxHoldOrgCode(detail.getDetailOrgCode());
            taxModifyEntity.setTaxHoldOrgName(detail.getDetailOrgName());
            taxModifyEntity.setAcSet(null != acSetMap.get(detail.getDetailOrgId()) ? acSetMap.get(detail.getDetailOrgId()).getAcSet() : null);
            taxModifyEntity.setAcSetCode(null != acSetMap.get(detail.getDetailOrgId()) ? acSetMap.get(detail.getDetailOrgId()).getAcSetCode() : null);


            //设置个税金额（累计应补/退税额）
            BigDecimal totalButuiTaxMny = detail.getTotalButuiTaxMny();
            taxModifyEntity.setTaxMny(totalButuiTaxMny);
            taxModifyEntity.setScale(new BigDecimal(1));
            taxModifyEntity.setTaxBillId(taxId);
            taxModifyEntity.setTaxBillDetailId(detail.getId());

            //是否默认单位
            taxModifyEntity.setIsDefault("1");
            taxModifySaveList.add(taxModifyEntity);
        }

        super.saveOrUpdateBatch(taxModifySaveList, taxModifySaveList.size());
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public void taxModifyApportion(Long taxId) {
        //个税调整 全删全加
        super.remove(new QueryWrapper<TaxModifyEntity>().eq("tax_bill_id", taxId));

        //1.查询到对应的应发工资计算子表id
        TaxEntity taxEntity = taxService.selectById(taxId);
        List<TaxDetailEntity> detailList = taxEntity.getDetailList().stream().filter(e -> StringUtils.isNotBlank(e.getYfgzjsBillDetailSourceType()) && "1".equals(e.getYfgzjsBillDetailSourceType())).collect(Collectors.toList());

        //2.根据应发工资计算子表id查询对应的 来源
        List<String> idCardList = detailList.stream().map(TaxDetailEntity::getIdCard).collect(Collectors.toList());
        List<JspayableSourceEntity> sourceEntityList = jspayableSourceService.list(new QueryWrapper<JspayableSourceEntity>().in("id_card", idCardList).eq("month", taxEntity.getMonth()));

        // 查应发工资上传子表的数据
        List<PayableDetailEntity> payableDetailList = payableDetailService.list(new QueryWrapper<PayableDetailEntity>().in("id", sourceEntityList.stream().map(JspayableSourceEntity::getSourceDetailId).collect(Collectors.toList())));
        Map<String, List<PayableDetailEntity>> payableDetailMap = payableDetailList.stream().collect(Collectors.groupingBy(PayableDetailEntity::getIdCard));


        //查账套
        List<AcSetRelateEntity> acSetList = acSetRelateService.list(new QueryWrapper<AcSetRelateEntity>().in("org_id", payableDetailList.stream().map(PayableDetailEntity::getGzffOrgId).collect(Collectors.toList())));
        Map<Long, AcSetRelateEntity> acSetMap = acSetList.stream().collect(Collectors.toMap(p -> p.getOrgId(), Function.identity()));

        //3.根据应发公积金调整单 保存对应的个税调整数据
        List<TaxModifyEntity> taxModifySaveList = new ArrayList<>();
        for (TaxDetailEntity taxDetailEntity : detailList) {
            List<PayableDetailEntity> payableDetailEntityList = payableDetailMap.get(taxDetailEntity.getIdCard());
            if (CollectionUtils.isNotEmpty(payableDetailEntityList)){
                List<TaxModifyEntity> taxModifyList = new ArrayList<>();
                BigDecimal totalButuiTaxMny = taxDetailEntity.getTotalButuiTaxMny();
                //总应发工资
                BigDecimal totalYfSalaryMny = payableDetailEntityList.stream().filter(p -> p.getYfSalaryMny() != null).map(PayableDetailEntity::getYfSalaryMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                int count = 0;
                for (PayableDetailEntity entity : payableDetailEntityList) {
                    TaxModifyEntity taxModifyEntity = new TaxModifyEntity();
                    taxModifyEntity.setTaxHoldOrgId(entity.getGzffOrgId());
                    taxModifyEntity.setTaxHoldOrgCode(entity.getGzffOrgCode());
                    taxModifyEntity.setTaxHoldOrgName(entity.getGzffOrgName());
                    taxModifyEntity.setAcSet(acSetMap.containsKey(entity.getGzffOrgId()) ? acSetMap.get(entity.getGzffOrgId()).getAcSet() : null);
                    taxModifyEntity.setAcSetCode(acSetMap.containsKey(entity.getGzffOrgId()) ? acSetMap.get(entity.getGzffOrgId()).getAcSetCode() : null);

                    //比例
                    BigDecimal scale = ComputeUtil.safeMultiply(ComputeUtil.safeDiv(entity.getYfSalaryMny(), totalYfSalaryMny), new BigDecimal(100));
                    taxModifyEntity.setScale(scale);

                    //这里如果计算有差则用先A*比例，后B*比例，总值再减A减B的方式得C值
                    //设置个税金额（累计应补/退税额）
                    if (payableDetailEntityList.size() == 1 || payableDetailEntityList.size() != ++count){
                        taxModifyEntity.setTaxMny(ComputeUtil.safeDiv(ComputeUtil.safeMultiply(totalButuiTaxMny, taxModifyEntity.getScale()), new BigDecimal(100)));
                    }else {
                        //最后一次循环，减去之前的金额
                        taxModifyEntity.setTaxMny(ComputeUtil.safeSub(totalButuiTaxMny, taxModifyList.stream().filter(p -> p.getTaxMny() != null).map(TaxModifyEntity::getTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add)));
                    }

                    taxModifyEntity.setTaxBillId(taxId);
                    taxModifyEntity.setTaxBillDetailId(taxDetailEntity.getId());

                    //是否默认单位
                    taxModifyEntity.setIsDefault(entity.getDetailOrgId().toString().equals(taxDetailEntity.getDetailOrgId().toString()) ? "1" : "2");
                    taxModifyList.add(taxModifyEntity);
                }
                taxModifySaveList.addAll(taxModifyList);
            }
        }
        super.saveOrUpdateBatch(taxModifySaveList, taxModifySaveList.size());
    }

}
