/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.salary.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.salary.bean.JspayableSourceEntity;
import com.ejianc.business.salary.bean.TaxEntity;
import com.ejianc.business.salary.service.IJspayableService;
import com.ejianc.business.salary.service.IJspayableSourceService;
import com.ejianc.business.salary.service.IPayableDetailService;
import com.ejianc.business.salary.service.ITaxDetailService;
import com.ejianc.business.salary.service.ITaxService;
import com.ejianc.business.salary.vo.JspayableSourceVO;
import com.ejianc.business.salary.vo.SourceDetailVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"jspayableSource"})
public class JspayableSourceController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IJspayableSourceService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IJspayableService jspayableService;
    @Autowired
    private IPayableDetailService payableDetailService;
    @Autowired
    private ITaxService taxService;
    @Autowired
    private ITaxDetailService taxDetailService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JspayableSourceVO> saveOrUpdate(@RequestBody JspayableSourceVO saveOrUpdateVO) {
        JspayableSourceEntity entity = (JspayableSourceEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, JspayableSourceEntity.class));
        this.service.saveOrUpdate((Object)entity, false);
        JspayableSourceVO vo = (JspayableSourceVO)BeanMapper.map((Object)((Object)entity), JspayableSourceVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JspayableSourceVO> queryDetail(Long id) {
        JspayableSourceEntity entity = (JspayableSourceEntity)((Object)this.service.selectById(id));
        JspayableSourceVO vo = (JspayableSourceVO)BeanMapper.map((Object)((Object)entity), JspayableSourceVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<JspayableSourceVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (JspayableSourceVO jspayableSourceVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<JspayableSourceVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), JspayableSourceVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("JspayableSource-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refJspayableSourceData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<JspayableSourceVO>> refJspayableSourceData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), JspayableSourceVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryPayrollSourceDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<SourceDetailVO>> queryPayrollSourceDetail(String idCard, String period, Long taxBillId) {
        TaxEntity taxEntity;
        Date month = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM");
        try {
            month = dateFormat.parse(period);
        }
        catch (ParseException e2) {
            e2.printStackTrace();
        }
        List<SourceDetailVO> sourceDetailVOS = this.jspayableService.querySourceDetail(idCard, month);
        if (CollectionUtils.isNotEmpty(sourceDetailVOS) && sourceDetailVOS.size() > 0 && null != taxBillId && null != (taxEntity = (TaxEntity)((Object)this.taxService.selectById(taxBillId))) && 1 != taxEntity.getBillState() && 3 != taxEntity.getBillState()) {
            sourceDetailVOS.forEach(e -> e.setTaxYfmsMny(e.getYfmsMny()));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", sourceDetailVOS);
    }

    @RequestMapping(value={"/updateTaxSource"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> updateTaxSource(@RequestBody List<SourceDetailVO> vos) {
        if (CollectionUtils.isNotEmpty(vos)) {
            for (SourceDetailVO sourceDetailVO : vos) {
                this.payableDetailService.update((Wrapper)((UpdateWrapper)new UpdateWrapper().eq((Object)"id", (Object)sourceDetailVO.getId())).set((Object)"tax_yfms_mny", (Object)sourceDetailVO.getTaxYfmsMny()));
            }
        } else {
            throw new BusinessException("\u5b50\u8868\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        this.taxDetailService.update((Wrapper)((UpdateWrapper)new UpdateWrapper().eq((Object)"id", (Object)vos.get(0).getTaxBillDetailId())).set((Object)"yfms_mny", (Object)vos.stream().filter(p -> p.getTaxYfmsMny() != null).map(SourceDetailVO::getTaxYfmsMny).reduce(BigDecimal.ZERO, BigDecimal::add)));
        return CommonResponse.success((String)"\u6279\u91cf\u4fee\u6539\u6765\u6e90\u6210\u529f\uff01");
    }
}

