/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.salary.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.salary.bean.RosterEntity;
import com.ejianc.business.salary.bean.SocialSecurityChangeSdetailEntity;
import com.ejianc.business.salary.service.IRosterService;
import com.ejianc.business.salary.service.ISocialSecurityChangeSdetailService;
import com.ejianc.business.salary.util.DetailIndexExcelReaderZzyj;
import com.ejianc.business.salary.vo.SocialSecurityChangeSdetailVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"socialSecurityChangeSdetail"})
public class SocialSecurityChangeSdetailController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private ISocialSecurityChangeSdetailService service;
    @Autowired
    private IRosterService rosterService;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SocialSecurityChangeSdetailVO> saveOrUpdate(@RequestBody SocialSecurityChangeSdetailVO saveOrUpdateVO) {
        BillCodeParam billCodeParam;
        CommonResponse billCode;
        SocialSecurityChangeSdetailEntity entity = (SocialSecurityChangeSdetailEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, SocialSecurityChangeSdetailEntity.class));
        if (!(entity.getId() != null && entity.getId() != 0L || (billCode = this.billCodeApi.generateBillCode(billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO))).isSuccess())) {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        this.service.saveOrUpdate((Object)entity, false);
        SocialSecurityChangeSdetailVO vo = (SocialSecurityChangeSdetailVO)BeanMapper.map((Object)((Object)entity), SocialSecurityChangeSdetailVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SocialSecurityChangeSdetailVO> queryDetail(Long id) {
        SocialSecurityChangeSdetailEntity entity = (SocialSecurityChangeSdetailEntity)((Object)this.service.selectById(id));
        SocialSecurityChangeSdetailVO vo = (SocialSecurityChangeSdetailVO)BeanMapper.map((Object)((Object)entity), SocialSecurityChangeSdetailVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SocialSecurityChangeSdetailVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (SocialSecurityChangeSdetailVO socialSecurityChangeSdetailVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SocialSecurityChangeSdetailVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SocialSecurityChangeSdetailVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("SocialSecurityChangeSdetail-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refSocialSecurityChangeSdetailData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<SocialSecurityChangeSdetailVO>> refSocialSecurityChangeSdetailData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SocialSecurityChangeSdetailVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/downloadInfo"})
    @ResponseBody
    public void downloadMaterial(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"SocialSecurityChangeSdetail-import.xlsx", (String)"\u793e\u4fdd\u8c03\u6574\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImportInfo"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> excelImportMaterial(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<SocialSecurityChangeSdetailVO> successList = new ArrayList<SocialSecurityChangeSdetailVO>();
        ArrayList<SocialSecurityChangeSdetailVO> errorList = new ArrayList<SocialSecurityChangeSdetailVO>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List<List<String>> result = DetailIndexExcelReaderZzyj.readExcel(mf);
        if (result != null && result.size() > 0) {
            ArrayList<String> idCardList = new ArrayList<String>();
            for (int i = 1; i < result.size(); ++i) {
                List<String> datas = result.get(i);
                idCardList.add(datas.get(1).trim());
            }
            Map<Object, Object> map = new HashMap();
            LambdaQueryWrapper lambdaQueryWrapper1 = new LambdaQueryWrapper();
            lambdaQueryWrapper1.eq(RosterEntity::getHrState, (Object)1);
            lambdaQueryWrapper1.in(RosterEntity::getIdCard, idCardList);
            lambdaQueryWrapper1.isNotNull(RosterEntity::getIdCard);
            List rosterEntityList = this.rosterService.list((Wrapper)lambdaQueryWrapper1);
            map = rosterEntityList.stream().collect(Collectors.toMap(p -> p.getIdCard(), Function.identity()));
            this.logger.info("\u4eba\u5458map: {}", (Object)JSONObject.toJSONString(map));
            for (int i = 1; i < result.size(); ++i) {
                List<String> datas = result.get(i);
                SocialSecurityChangeSdetailVO detailVO = new SocialSecurityChangeSdetailVO();
                detailVO.setId(Long.valueOf(IdWorker.getId()));
                try {
                    String idCard = datas.get(1).trim();
                    detailVO.setIdCard(idCard);
                    if (ObjectUtils.isEmpty((Object)map.get(idCard))) {
                        throw new Exception("\u6ca1\u6709\u8be5\u4eba\u5458\u4fe1\u606f\uff01");
                    }
                    RosterEntity rosterEntity = (RosterEntity)((Object)map.get(idCard));
                    String userName = datas.get(0).trim();
                    if (userName == null || !userName.equals(rosterEntity.getUserName())) {
                        throw new Exception("\u4eba\u5458\u8eab\u4efd\u8bc1\u53f7\u3001\u59d3\u540d\u4e0d\u5339\u914d\uff01");
                    }
                    detailVO.setUserName(userName);
                    detailVO.setUserId(rosterEntity.getUserId());
                    detailVO.setUserCode(rosterEntity.getUserCode());
                }
                catch (Exception e) {
                    detailVO.setErrorMsg("\u4eba\u5458\u540d\u79f0\u3001\u8eab\u4efd\u8bc1\u53f7\u9519\u8bef\uff01");
                    errorList.add(detailVO);
                    continue;
                }
                try {
                    String paymentBase = datas.get(2);
                    if (!StringUtils.isNotBlank((CharSequence)paymentBase)) {
                        throw new Exception("\u7f34\u8d39\u57fa\u6570\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    }
                    detailVO.setPaymentBase(new BigDecimal(paymentBase));
                }
                catch (Exception e) {
                    detailVO.setErrorMsg("\u7f34\u8d39\u57fa\u6570\u91d1\u989d\u9519\u8bef\uff01");
                    errorList.add(detailVO);
                    continue;
                }
                try {
                    String personAnnuityMoney = datas.get(3);
                    if (!StringUtils.isNotBlank((CharSequence)personAnnuityMoney)) {
                        throw new Exception("\u4e2a\u4eba\u517b\u8001\u91d1\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    }
                    detailVO.setPersonAnnuityMoney(new BigDecimal(personAnnuityMoney));
                    detailVO.setPersonAnnuityMoneyPercent(detailVO.getPersonAnnuityMoney().divide(detailVO.getPaymentBase(), 4, RoundingMode.HALF_UP).multiply(new BigDecimal(100)).setScale(2, RoundingMode.HALF_UP));
                }
                catch (Exception e) {
                    detailVO.setErrorMsg("\u4e2a\u4eba\u517b\u8001\u91d1\u91d1\u989d\u9519\u8bef\uff01");
                    errorList.add(detailVO);
                    continue;
                }
                try {
                    String companyAnnuityMoney = datas.get(4);
                    if (!StringUtils.isNotBlank((CharSequence)companyAnnuityMoney)) {
                        throw new Exception("\u516c\u53f8\u517b\u8001\u91d1\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    }
                    detailVO.setCompanyAnnuityMoney(new BigDecimal(companyAnnuityMoney));
                    detailVO.setCompanyAnnuityMoneyPercent(detailVO.getCompanyAnnuityMoney().divide(detailVO.getPaymentBase(), 4, RoundingMode.HALF_UP).multiply(new BigDecimal(100)).setScale(2, RoundingMode.HALF_UP));
                }
                catch (Exception e) {
                    detailVO.setErrorMsg("\u516c\u53f8\u517b\u8001\u91d1\u91d1\u989d\u9519\u8bef\uff01");
                    errorList.add(detailVO);
                    continue;
                }
                try {
                    String personMedicalMoney = datas.get(5);
                    if (!StringUtils.isNotBlank((CharSequence)personMedicalMoney)) {
                        throw new Exception("\u4e2a\u4eba\u533b\u7597\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    }
                    detailVO.setPersonMedicalMoney(new BigDecimal(personMedicalMoney));
                    detailVO.setPersonMedicalMoneyPercent(detailVO.getPersonMedicalMoney().divide(detailVO.getPaymentBase(), 4, RoundingMode.HALF_UP).multiply(new BigDecimal(100)).setScale(2, RoundingMode.HALF_UP));
                }
                catch (Exception e) {
                    detailVO.setErrorMsg("\u4e2a\u4eba\u533b\u7597\u91d1\u989d\u9519\u8bef\uff01");
                    errorList.add(detailVO);
                    continue;
                }
                try {
                    String companyMedicalMoney = datas.get(6);
                    if (!StringUtils.isNotBlank((CharSequence)companyMedicalMoney)) {
                        throw new Exception("\u516c\u53f8\u533b\u7597\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    }
                    detailVO.setCompanyMedicalMoney(new BigDecimal(companyMedicalMoney));
                    detailVO.setCompanyMedicalMoneyPercent(detailVO.getCompanyMedicalMoney().divide(detailVO.getPaymentBase(), 4, RoundingMode.HALF_UP).multiply(new BigDecimal(100)).setScale(2, RoundingMode.HALF_UP));
                }
                catch (Exception e) {
                    detailVO.setErrorMsg("\u516c\u53f8\u533b\u7597\u91d1\u989d\u9519\u8bef\uff01");
                    errorList.add(detailVO);
                    continue;
                }
                try {
                    String personUnemploymentMoney = datas.get(7);
                    if (!StringUtils.isNotBlank((CharSequence)personUnemploymentMoney)) {
                        throw new Exception("\u4e2a\u4eba\u5931\u4e1a\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    }
                    detailVO.setPersonUnemploymentMoney(new BigDecimal(personUnemploymentMoney));
                    detailVO.setPersonUnemploymentMoneyPercent(detailVO.getPersonUnemploymentMoney().divide(detailVO.getPaymentBase(), 4, RoundingMode.HALF_UP).multiply(new BigDecimal(100)).setScale(2, RoundingMode.HALF_UP));
                }
                catch (Exception e) {
                    detailVO.setErrorMsg("\u4e2a\u4eba\u5931\u4e1a\u91d1\u989d\u9519\u8bef\uff01");
                    errorList.add(detailVO);
                    continue;
                }
                try {
                    String companyUnemploymentMoney = datas.get(8);
                    if (!StringUtils.isNotBlank((CharSequence)companyUnemploymentMoney)) {
                        throw new Exception("\u516c\u53f8\u5931\u4e1a\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    }
                    detailVO.setCompanyUnemploymentMoney(new BigDecimal(companyUnemploymentMoney));
                    detailVO.setCompanyUnemploymentMoneyPercent(detailVO.getCompanyUnemploymentMoney().divide(detailVO.getPaymentBase(), 4, RoundingMode.HALF_UP).multiply(new BigDecimal(100)).setScale(2, RoundingMode.HALF_UP));
                }
                catch (Exception e) {
                    detailVO.setErrorMsg("\u516c\u53f8\u5931\u4e1a\u91d1\u989d\u9519\u8bef\uff01");
                    errorList.add(detailVO);
                    continue;
                }
                try {
                    String companyChildbirthMoney = datas.get(9);
                    if (!StringUtils.isNotBlank((CharSequence)companyChildbirthMoney)) {
                        throw new Exception("\u516c\u53f8\u751f\u80b2\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    }
                    detailVO.setCompanyChildbirthMoney(new BigDecimal(companyChildbirthMoney));
                    detailVO.setCompanyChildbirthMoneyPercent(detailVO.getCompanyChildbirthMoney().divide(detailVO.getPaymentBase(), 4, RoundingMode.HALF_UP).multiply(new BigDecimal(100)).setScale(2, RoundingMode.HALF_UP));
                }
                catch (Exception e) {
                    detailVO.setErrorMsg("\u516c\u53f8\u751f\u80b2\u91d1\u989d\u9519\u8bef\uff01");
                    errorList.add(detailVO);
                    continue;
                }
                try {
                    String companyInjuryMoney = datas.get(10);
                    if (!StringUtils.isNotBlank((CharSequence)companyInjuryMoney)) {
                        throw new Exception("\u4e2a\u4eba\u517b\u8001\u91d1\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    }
                    detailVO.setCompanyInjuryMoney(new BigDecimal(companyInjuryMoney));
                    detailVO.setCompanyInjuryMoneyPercent(detailVO.getCompanyInjuryMoney().divide(detailVO.getPaymentBase(), 4, RoundingMode.HALF_UP).multiply(new BigDecimal(100)).setScale(2, RoundingMode.HALF_UP));
                }
                catch (Exception e) {
                    detailVO.setErrorMsg("\u4e2a\u4eba\u517b\u8001\u91d1\u91d1\u989d\u9519\u8bef\uff01");
                    errorList.add(detailVO);
                    continue;
                }
                detailVO.setChangeReason(datas.get(11));
                detailVO.setRowState("add");
                successList.add(detailVO);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }
}

