/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.salary.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.financeintegration.PMSalary.api.IPMSalarySystemApi;
import com.ejianc.business.financeintegration.PMSalary.vo.PMGzDetailVO;
import com.ejianc.business.financeintegration.PMSalary.vo.PMGzVO;
import com.ejianc.business.salary.bean.PayrollEntity;
import com.ejianc.business.salary.bean.PushcwEntity;
import com.ejianc.business.salary.service.IPayrollService;
import com.ejianc.business.salary.service.IPushcwService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="payroll")
public class PayrollBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IPayrollService payrollService;
    @Autowired
    private IPushcwService pushcwService;
    @Autowired
    private IPMSalarySystemApi salarySystemApi;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.error((String)"\u6b64\u5355\u636e\u4e0d\u5141\u8bb8\u64a4\u56de\uff01");
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        PayrollEntity payrollEntity = (PayrollEntity)((Object)this.payrollService.selectById(billId));
        if (null == payrollEntity.getPayrollPersonList().get(0).getTotalButuiTaxMny()) {
            return CommonResponse.error((String)"\u8bf7\u5148\u5b8c\u6210\u4e2a\u7a0e\u8ba1\u7b97\u540e\u518d\u63d0\u4ea4\uff01");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse<PMGzVO> res;
        PayrollEntity payrollEntity = (PayrollEntity)((Object)this.payrollService.selectById(billId));
        List<PushcwEntity> actualMny = this.payrollService.getActualMny(payrollEntity.getMonth(), payrollEntity.getCompanyId());
        if (CollectionUtils.isNotEmpty(actualMny)) {
            this.pushcwService.saveBatch(actualMny);
        }
        if (!(res = this.salaryTakeEffect(payrollEntity)).isSuccess()) {
            this.logger.error("\u8c03\u7528PM\u8d22\u52a1\u6a21\u5757\u751f\u6548\u63a5\u53e3\u5931\u8d25\uff01message-{}", (Object)res.getMsg());
            return CommonResponse.error((String)"\u8c03\u7528PM\u8d22\u52a1\u6a21\u5757\u751f\u6548\u63a5\u53e3\u5931\u8d25");
        }
        return CommonResponse.success();
    }

    private CommonResponse<PMGzVO> salaryTakeEffect(PayrollEntity payrollEntity) {
        PMGzVO pmSalaryPayApplyVO;
        this.logger.info("\u8c03\u7528\u8d22\u52a1\u7684\u751f\u6548\u63a5\u53e3---ejc-profinance\u9879\u76ee---SalaryPayApplyBpmServiceImpl\u7c7b---salaryTakeEffect\u65b9\u6cd5---begin\uff0c\u85aa\u8d44\u5de5\u8d44\u5355ID-{}", (Object)payrollEntity.getId());
        List<PushcwEntity> acActualMny = this.payrollService.getAcActualMny(payrollEntity.getMonth(), payrollEntity.getCompanyId());
        List<PushcwEntity> idCardActualMny = this.payrollService.getIdCardActualMny(payrollEntity.getMonth(), payrollEntity.getCompanyId());
        if (CollectionUtils.isEmpty(acActualMny) || CollectionUtils.isEmpty(idCardActualMny)) {
            this.logger.error("\u6839\u636e\u5de5\u8d44\u5355ID-{}\uff0c\u67e5\u8be2\u4e0d\u5230\u5de5\u8d44\u6570\u636e\uff0c\u65e0\u6cd5\u8c03\u7528\u751f\u6548\u63a5\u53e3", (Object)payrollEntity.getId());
            return CommonResponse.error((String)("\u6839\u636e\u5de5\u8d44\u5355ID-\u3010" + payrollEntity.getId() + "\u3011\u67e5\u8be2\u4e0d\u5230\u5de5\u8d44\u652f\u4ed8\u7533\u8bf7\u6570\u636e\uff0c\u65e0\u6cd5\u8c03\u7528\u751f\u6548\u63a5\u53e3"));
        }
        this.logger.info("\u6839\u636e\u672c\u5de5\u8d44\u5355ID-{}\uff0c\u67e5\u8be2\u5230\u7684\u672c\u5de5\u8d44\u652f\u4ed8\u7533\u8bf7\u6570\u636e-{}", (Object)payrollEntity.getId(), (Object)JSONObject.toJSONString((Object)((Object)payrollEntity), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMM");
        ArrayList<PMGzVO> pmGzVOS = new ArrayList<PMGzVO>();
        ArrayList<PMGzVO> pmGzDetailVOS = new ArrayList<PMGzVO>();
        for (PushcwEntity pushcwEntity : acActualMny) {
            pmSalaryPayApplyVO = new PMGzVO();
            pmSalaryPayApplyVO.setId(IdWorker.getId() + "");
            pmSalaryPayApplyVO.setAcCode(pushcwEntity.getAcSetCode());
            pmSalaryPayApplyVO.setAcName(pushcwEntity.getAcSet());
            pmSalaryPayApplyVO.setYearMonth(sdf.format(pushcwEntity.getPeriod()));
            pmSalaryPayApplyVO.setPmBillId(pushcwEntity.getCode());
            pmSalaryPayApplyVO.setActualMny(pushcwEntity.getActual());
            pmSalaryPayApplyVO.setQuoteFlag("N");
            pmGzVOS.add(pmSalaryPayApplyVO);
        }
        for (PushcwEntity pushcwEntity : idCardActualMny) {
            pmSalaryPayApplyVO = new PMGzDetailVO();
            pmSalaryPayApplyVO.setId(IdWorker.getId() + "");
            pmSalaryPayApplyVO.setName(pushcwEntity.getDetailEmployeeName());
            pmSalaryPayApplyVO.setIdCard(pushcwEntity.getIdCard());
            pmSalaryPayApplyVO.setBankName(pushcwEntity.getBankName());
            pmSalaryPayApplyVO.setBankCount(pushcwEntity.getBankAccount());
            pmSalaryPayApplyVO.setBankAddress(pushcwEntity.getBankAddress());
            pmSalaryPayApplyVO.setPmBillId(pushcwEntity.getCode());
            pmSalaryPayApplyVO.setActualMny(pushcwEntity.getActual());
            pmGzDetailVOS.add(pmSalaryPayApplyVO);
        }
        ((PMGzVO)pmGzVOS.get(0)).setDetailList(pmGzDetailVOS);
        this.logger.info("\u5f00\u59cb\u8c03\u7528PM\u5de5\u8d44\u652f\u4ed8\u7533\u8bf7\u751f\u6548\u63a5\u53e3\uff0c\u63a5\u53e3\u53c2\u6570VO-{}", (Object)JSONObject.toJSONString(pmGzVOS));
        CommonResponse res = this.salarySystemApi.salaryTakeEffect(pmGzVOS);
        this.logger.info("\u8c03\u7528PM\u8d44\u91d1\u7684\u751f\u6548\u63a5\u53e3----SalaryPayApplyBpmServiceImpl\u7c7b---salaryTakeEffect\u65b9\u6cd5---end\uff0c\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c-{}", (Object)JSONObject.toJSONString((Object)res, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
        if (!res.isSuccess()) {
            return CommonResponse.error((String)("\u5de5\u8d44\u4fe1\u606f\u63a8\u9001\u4e2d\u95f4\u8868\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + res.getMsg()));
        }
        return res;
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    private CommonResponse<String> bpmBackCheck(Long billId, Integer state, String billTypeCode) {
        List<PushcwEntity> acActualMny;
        PayrollEntity payrollEntity = (PayrollEntity)((Object)this.payrollService.selectById(billId));
        if ((BillStateEnum.COMMITED_STATE.getBillStateCode().equals(payrollEntity.getBillState()) || BillStateEnum.PASSED_STATE.getBillStateCode().equals(payrollEntity.getBillState())) && null != payrollEntity && CollectionUtils.isNotEmpty(acActualMny = this.payrollService.getAcActualMny(payrollEntity.getMonth(), payrollEntity.getCompanyId()))) {
            PMGzVO pmSalaryPayApplyVO = new PMGzVO();
            pmSalaryPayApplyVO.setId(IdWorker.getId() + "");
            pmSalaryPayApplyVO.setPmBillId(acActualMny.get(0).getCode());
            CommonResponse res = this.salarySystemApi.salaryAbandonOrClose(pmSalaryPayApplyVO);
            this.logger.info("\u8c03\u7528PM\u5de5\u8d44\u652f\u4ed8\u7684\u5f03\u5ba1\u63a5\u53e3---ejc-profinance\u9879\u76ee---bpmBackCheck\u65b9\u6cd5---end\uff0c\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c-{}", (Object)JSONObject.toJSONString((Object)res, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
            if (!res.isSuccess()) {
                return CommonResponse.error((String)("\u5de5\u8d44\u652f\u4ed8\u7533\u8bf7\u67e5\u8be2\u8d22\u52a1\u7cfb\u7edf\u4e2d\u95f4\u8868\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + res.getMsg()));
            }
            PMGzVO resultVO = (PMGzVO)res.getData();
            if (null != resultVO) {
                if ("Y".equals(resultVO.getQuoteFlag())) {
                    return CommonResponse.error((String)"\u8be5\u7533\u8bf7\u5355\u5df2\u7ecf\u88ab\u8d22\u52a1\u7cfb\u7edf\u5f15\u7528\uff0c\u4e0d\u80fd\u64a4\u56de/\u5f03\u5ba1");
                }
                this.pushcwService.update((Wrapper)((UpdateWrapper)((UpdateWrapper)new UpdateWrapper().eq((Object)"period", (Object)payrollEntity.getMonth())).eq((Object)"company_id", (Object)payrollEntity.getCompanyId())).set((Object)"dr", (Object)1));
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

