package com.ejianc.business.salary.mapper;

import com.ejianc.business.salary.vo.RosterTransferVO;
import com.ejianc.business.salary.vo.RosterVO;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.salary.bean.RosterTransferEntity;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * 人员花名册-异动
 * 
 * @author generator
 * 
 */
@Mapper
public interface RosterTransferMapper extends BaseCrudMapper<RosterTransferEntity> {

    @Select("(SELECT id,start_time,'1' as num,org_code,org_name,department_code,department_name FROM `ejc_salary_roster_transfer`\n" +
            "where id_card = #{idCard}\n" +
            "and dr = 0\n" +
            "and start_time <= #{Date}\n" +
            "order by start_time desc\n" +
            "LIMIT 1)\n" +
            "union\n" +
            "(SELECT id,start_time,'2' as num,org_code,org_name,department_code,department_name FROM `ejc_salary_roster_transfer`\n" +
            "where id_card = #{idCard}\n" +
            "and dr = 0\n" +
            "and start_time > #{Date}\n" +
            "order by start_time asc\n" +
            "LIMIT 1)")
    List<RosterTransferVO> queryChangeListByIdcard(String idCard,String Date);


    @Select("SELECT * FROM `ejc_salary_roster_first`\n" +
            "where id_card = #{idCard}")
    RosterVO getFirstDataByIdcard(String idCard);
}
