package com.ejianc.business.salary.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.salary.vo.AcSetRelateVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.salary.mapper.AcSetRelateMapper;
import com.ejianc.business.salary.bean.AcSetRelateEntity;
import com.ejianc.business.salary.service.IAcSetRelateService;

/**
 * 账套组织关联表
 * 
 * @author generator
 * 
 */
@Service("acSetRelateService")
public class AcSetRelateServiceImpl extends BaseServiceImpl<AcSetRelateMapper, AcSetRelateEntity> implements IAcSetRelateService{

    @Override
    public AcSetRelateVO queryDetailByOrgId(Long orgId) {
        AcSetRelateEntity entity = this.getOne(new QueryWrapper<AcSetRelateEntity>().eq("org_id", orgId));
        return null != entity ? BeanMapper.map(entity, AcSetRelateVO.class) : new AcSetRelateVO();
    }
}
