package com.ejianc.business.salary.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.salary.bean.PayableDetailEntity;
import com.ejianc.business.salary.bean.PayableEntity;
import com.ejianc.business.salary.service.IPayableDetailService;
import com.ejianc.business.salary.service.IPayableService;
import com.ejianc.business.salary.vo.AcSetRelateVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.salary.mapper.AcSetRelateMapper;
import com.ejianc.business.salary.bean.AcSetRelateEntity;
import com.ejianc.business.salary.service.IAcSetRelateService;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 账套组织关联表
 * 
 * @author generator
 * 
 */
@Service("acSetRelateService")
public class AcSetRelateServiceImpl extends BaseServiceImpl<AcSetRelateMapper, AcSetRelateEntity> implements IAcSetRelateService{

    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IPayableService payableService;
    @Autowired
    private IPayableDetailService payableDetailService;
    @Autowired
    private IEmployeeApi employeeApi;
    @Autowired
    private IUserApi userApi;


    @Override
    public AcSetRelateVO queryDetailByOrgId(Long orgId, Integer orgType, String month, Boolean payableBillFlag) {
        AcSetRelateEntity entity = this.getOne(new QueryWrapper<AcSetRelateEntity>().eq("org_id", orgId));
        AcSetRelateVO acSetRelateVO = new AcSetRelateVO();
        if (null != entity){
            acSetRelateVO = BeanMapper.map(entity, AcSetRelateVO.class);
        }

        if (null != payableBillFlag && payableBillFlag){
            QueryWrapper<PayableEntity> queryWrapper = new QueryWrapper<>();
            //计算该组织对应数据
            if (null == orgType){
                CommonResponse<OrgVO> orgIdCrs = iOrgApi.getOneById(orgId);
                if (!orgIdCrs.isSuccess() || null == orgIdCrs.getData()) {
                    throw new BusinessException("查询组织信息失败！");
                }
                orgType = orgIdCrs.getData().getOrgType();
            }
            CommonResponse<OrgVO> parentByOrgId = iOrgApi.findParentByOrgId(orgId);
            if (!parentByOrgId.isSuccess() || null == parentByOrgId.getData()) {
                throw new BusinessException("查询组织信息失败！");
            }
            OrgVO parentOrg = parentByOrgId.getData();
            if (null != parentOrg){
                acSetRelateVO.setParentOrgCode(parentOrg.getCode());
                acSetRelateVO.setParentOrgId(parentOrg.getId());
                acSetRelateVO.setParentOrgName(parentOrg.getName());
            }


            if(5 == orgType) {
                queryWrapper.in("org_id", iOrgApi.findChildrenByParentId(parentOrg.getId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
            } else {
                queryWrapper.in("org_id", iOrgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
            }
            CommonResponse<List<Map<String, Object>>> listCommonResponse = userApi.getEmployeeList(null != parentOrg && null != parentOrg.getId() && 5 == orgType ? parentOrg.getId() : orgId);
            if (!listCommonResponse.isSuccess() || null == listCommonResponse.getData()) {
//                throw new BusinessException("查询组织信息失败！");
            }else {
                acSetRelateVO.setOrgPersonNum(listCommonResponse.getData().size());
            }

            // 应发工资上传其他数据赋值
            List<PayableEntity> allPayableList = payableService.list(queryWrapper);
            if (CollectionUtils.isNotEmpty(allPayableList) && allPayableList.size() > 0){
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
                List<PayableEntity> thisMonthData = allPayableList.stream().filter(e -> null != e.getMonth() && sdf.format(e.getMonth()).equals(month)).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(thisMonthData)){
                    acSetRelateVO.setOrgBillNum(thisMonthData.size() + 1);
                    acSetRelateVO.setOrgBillRegisterMny(thisMonthData.stream().filter(p -> p.getPayableSumMny() != null).map(PayableEntity::getPayableSumMny).reduce(BigDecimal.ZERO, BigDecimal::add));
                    acSetRelateVO.setOrgAllBillRegisterMny(acSetRelateVO.getOrgBillRegisterMny());
                    acSetRelateVO.setOrgBillApprovalMny(thisMonthData.stream().filter(p -> p.getPayableSumMny() != null && (p.getBillState() == 1 || p.getBillState() == 3)).map(PayableEntity::getPayableSumMny).reduce(BigDecimal.ZERO, BigDecimal::add));
                    List<PayableDetailEntity> payableDetailList = payableDetailService.list(new QueryWrapper<PayableDetailEntity>().in("payable_id", thisMonthData.stream().map(PayableEntity::getId).collect(Collectors.toList())));
                    if (CollectionUtils.isNotEmpty(payableDetailList) && payableDetailList.size() > 0){
                        acSetRelateVO.setSalaryPersonNum(payableDetailList.stream().filter(e -> null != e.getIdCard()).map(PayableDetailEntity::getIdCard).distinct().collect(Collectors.toList()).size());
                        acSetRelateVO.setAllSalaryPersonNum(acSetRelateVO.getSalaryPersonNum());
                    }

                }
                List<PayableEntity> lastMonthData = new ArrayList<>();
                for (PayableEntity jspayableEntity : allPayableList) {
                    Date lastMonth = DateUtils.addMonths(jspayableEntity.getMonth(), 1);
                    if (sdf.format(lastMonth).equals(month)){
                        lastMonthData.add(jspayableEntity);
                    }
                }
                if (CollectionUtils.isNotEmpty(lastMonthData)){
                    acSetRelateVO.setLastMonthMny(lastMonthData.stream().filter(p -> p.getPayableSumMny() != null).map(PayableEntity::getPayableSumMny).reduce(BigDecimal.ZERO, BigDecimal::add));
                    acSetRelateVO.setDifMonthMny(acSetRelateVO.getLastMonthMny());

                    if (CollectionUtils.isNotEmpty(thisMonthData)){
                        acSetRelateVO.setDifMonthMny(ComputeUtil.safeSub(acSetRelateVO.getLastMonthMny(), thisMonthData.stream().filter(p -> p.getPayableSumMny() != null).map(PayableEntity::getPayableSumMny).reduce(BigDecimal.ZERO, BigDecimal::add)));
                    }
                }else {
                    acSetRelateVO.setDifMonthMny(ComputeUtil.safeSub(BigDecimal.ZERO, thisMonthData.stream().filter(p -> p.getPayableSumMny() != null).map(PayableEntity::getPayableSumMny).reduce(BigDecimal.ZERO, BigDecimal::add)));
                }
            }
        }

        return acSetRelateVO;
    }
}
